
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/detonate.c,v 3.1 88/09/20 00:43:57 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#ifndef ibm032
#include <sys/ipc.h>
#include <sys/shm.h>
#endif ibm032
#include "defs.h"
#include "struct.h"
#include "data.h"

/* Detonate torp */

/*
** Detonating torps have become a difficult part of the game.  Players
** quickly learned that detonating their own torps when the cloud was
** around another player, caused that player to die very quickly.  I
** removed that feature because it lead to people not having to shoot
** well to collect kills.  Now when players detonate their own torps,
** the torps just vanish and become available for future firing.
*/

detmine()
{
    register int i;

    if (me->p_flags & PFWEP) {
	warning("Weapons overheated");
	return;
    }
    for (i = 0; i < MAXTORP; i++) {
	if (torps[i + (me->p_no * MAXTORP)].t_status == TMOVE) {
	    torps[i + (me->p_no * MAXTORP)].t_status = TOFF;
	}
	else if (torps[i + (me->p_no * MAXTORP)].t_status == TSTRAIGHT) {
	    torps[i + (me->p_no * MAXTORP)].t_status = TOFF;
	}
    }
}

/*
** Here we have another flaw.  Detonating other players torps can be a
** very quick way to die.  Why?  Because you always take some damage.
** Experienced players never detonate other players' torps.  Balance is
** really hard to obtain with this type of function.  Technically, a
** player could nearly continuously detonate torps (at least faster than
** they could be fired) and never be hurt, if I allowed less damage as
** a possible result.  So here it sits.
*/

detothers()
{
    register int h, i;
    int dx, dy;
    register struct torp *j;

    if (me->p_fuel < myship->s_detcost) {
	warning("Not enough fuel to detonate");
	return;
    }
    if (me->p_flags & PFWEP) {
	warning("Weapons overheated");
	return;
    }
    me->p_fuel -= myship->s_detcost;
    me->p_wtemp += myship->s_detcost / 5;

    for (h = 0; h < MAXPLAYER; h++) {
	if ((players[h].p_status == PFREE) || (h == me->p_no))
	    continue;
	for (i = h * MAXTORP; i < MAXTORP * (h + 1); i++) {
	    j = &torps[i];
	    if ((j->t_status == TMOVE) || (j->t_status == TSTRAIGHT)) {
		dx = j->t_x - me->p_x;
		dy = j->t_y - me->p_y;
		if (ABS(dx) > DETDIST || ABS(dy) > DETDIST) /* XXX */
		    continue;
		if (dx * dx + dy * dy < DETDIST * DETDIST)
		    j->t_status = TDET;
	    }
	}
    }
}
