
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/dmessage.c,v 3.1 88/09/20 00:43:59 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

dmessage()
{
    struct message *cur;
    char buf[80];

    if (messpend)
	return;
    if (mctl->mc_current == lastm) {
	if (mdisplayed) {
	    XClearWindow(dpy, messagew);
	    mdisplayed = 0;
	}
	return;
    }
    do {
	if (++lastm >= MAXMESSAGE)
	    lastm = 0;
	cur = &messages[lastm];
	if (cur->m_flags & MVALID) {
	    if ((cur->m_flags & MALL) ||
		((cur->m_flags & MTEAM) && (cur->m_recpt & me->p_team)) ||
		((cur->m_flags & MINDIV) && (cur->m_recpt == me->p_no))) {
		    if (mdisplayed) {
			XClearWindow(dpy, messagew);
			mdisplayed = 0;
		    }
		    (void) sprintf(buf, "%s", cur->m_data);
		    lastcount = strlen(buf);
		    if (lastcount > 80)
			lastcount = 80;
		    XText(messagew, MESSAGEBD, MESSAGEBD, buf, 
			lastcount, dfont, textColor, backColor);
		    XBell(dpy, 0);
		    mdisplayed = 1;
		    XFlush(dpy);
		    return;
	    }
	}
    } while (lastm != mctl->mc_current);
}
