
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/input.c,v 3.1 88/09/20 00:44:10 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include <errno.h>
#include "defs.h"
#include "struct.h"
#include "data.h"


static int	doTheRedrawDude, skipUpdates = 1;

initinput()
{
    XSelectInput(dpy, iconWin, ExposureMask);
    XSelectInput(dpy, w, 
	KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, mapw, 
	KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, messagew, 
	KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, tstatw, ExposureMask);
    XSelectInput(dpy, war,
	ExposureMask);
    XSelectInput(dpy, warf,
	ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, warr,
	ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, wark,
	ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, waro,
	ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, wargo,
	ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, warno,
	ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, helpWin, ExposureMask);
    XSelectInput(dpy, playerw, 
	KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
    XSelectInput(dpy, planetw, 
	KeyPressMask|ButtonPressMask|ButtonReleaseMask|ExposureMask);
}

setRedrawFlag()
{
	/* let the daemon know I'm real */
	if (!watch)
	    me->p_ghostbuster = 0;

	if (skipUpdates)
		doTheRedrawDude = 1;
	else
		doTheRedrawDude++;
}

input()
{
    XEvent data;
    XExposeEvent *tmp;
    XButtonEvent *tmp1;
    XKeyEvent *tmp2;
    char buf[5];
    int nchar;
    int fd;
    struct itimerval	udt;

    signal(SIGALRM, setRedrawFlag);
    udt.it_interval.tv_sec = 0;
    udt.it_interval.tv_usec = 200000;
    udt.it_value.tv_sec = 0;
    udt.it_value.tv_usec = 200000;
    setitimer(ITIMER_REAL, &udt, 0);

    tmp = (XExposeEvent *) &data;
    tmp1 = (XButtonEvent *) &data;
    tmp2 = (XKeyEvent *) &data;

    while (1) {
	while (doTheRedrawDude-- > 0) {
		intrupt();
	}
	while (!XPending(dpy)) {
	    fd = (1 << dpyno());
	    select(32, &fd, 0, 0, 0);
	    while (doTheRedrawDude-- > 0)
		intrupt();
	}
	XNextEvent(dpy, &data);
	if ((!(copilot || watch)) && (me->p_updates > delay)) {
	    me->p_flags &= ~(PFWAR);
	}
	switch ((int) data.type) {
	    case KeyPress:
		if (inputIgnored())
		    continue;
		if ((me->p_flags & PFSELFDEST) && (!watch)) {
		    me->p_flags &= ~PFSELFDEST;
		    warning("Self Destruct has been canceled");
		}
		nchar = XLookupString(tmp2, buf, 5, NULL, NULL);
		/* add null in case Xlib doesn't */
		buf[nchar] = '\0'; 
		
		if (nchar > 0) {
		    if (tmp2->window == messagew)
			smessage(*buf);
		    else
			keyaction(*buf, tmp2);
		}
		break;
	    case ButtonPress:
		if (inputIgnored())
			continue;
		if ((me->p_flags & PFSELFDEST) && (!watch)) {
		    me->p_flags &= ~PFSELFDEST;
		    warning("Self Destruct has been canceled");
		}
		if (tmp1->window == warf) 
		    waraction(tmp1);
		else if (tmp1->window == warr) 
		    waraction(tmp1);
		else if (tmp1->window == wark) 
		    waraction(tmp1);
		else if (tmp1->window == waro) 
		    waraction(tmp1);
		else if (tmp1->window == wargo) 
		    waraction(tmp1);
		else if (tmp1->window == warno) 
		    waraction(tmp1);
		else
		    buttonaction(tmp1);
		break;
	    case Expose:
		if (tmp->window == statwin && showStats)
			redrawStats(statwin);
		else if (tmp->window == tstatw)
			redrawTstats();
		else if (tmp->window == mapw)
		    redrawall = 1;
		else if (tmp->window == iconWin)
		    drawIcon();
		else if (tmp->window == helpWin)
		    fillhelp();
		else if (tmp->window == playerw)
		    playerlist();
		else if (tmp->window == planetw)
		    planetlist();
		else if (tmp->window == infow)
		    drawInfo();
		else if (tmp->window == war) 
		    warrefresh();
		else if (tmp1->window == warf) 
		    warrefresh();
		else if (tmp1->window == warr) 
		    warrefresh();
		else if (tmp1->window == wark) 
		    warrefresh();
		else if (tmp1->window == waro) 
		    warrefresh();
		else if (tmp1->window == wargo) 
		    warrefresh();
		else if (tmp1->window == warno) 
		    warrefresh();
		break;
	    default:
		break;
	}
    }
}

static int Ten=0;

keyaction(key, data)
char key;
XKeyEvent *data;
{
    char buf[80];
    unsigned char course;
    struct obtype *gettarget(), *target;
    struct player *p;
    struct planet *pl;

    if (watch && !index("LPSMiQ?hw ", key)) {
	char	buf[BUFSIZ];

	sprintf(buf, "'%c' command is not permitted in watch mode.", key);
	warning(buf);
	return;
    }
    switch(key) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    set_speed(key - '0' + Ten);
	    break;
	case 'X':
	    Ten+=10;
	    break;
	case 'k': /* k = set course */
	    course = getcourse(data->window, data->x, data->y);
	    set_course(course);
	    me->p_flags &= ~(PFPLOCK | PFPLLOCK);
	    break;
	case 'p': /* p = fire phasers */
	    course = getcourse(data->window, data->x, data->y);
	    phaser(course);
	    break;
	case 't': /* t = launch torps */
	    course = getcourse(data->window, data->x, data->y);
	    ntorp(course, TMOVE, data->time);
	    break;
	case 'd': /* d = detonate other torps */
	    detothers();
	    break;
	case 'D': /* D = detonate my torps */
	    detmine();
	    break;
	case '+': /* + = Put shields up */
	    shield_up();
	    break;
	case '-': /* - = Put shields down */
	    shield_down();
	    break;
	case 'u': /* u = toggle shields */
	case 's': /* For Serge */
	    shield_tog();
	    break;
	case 'b': /* b = bomb planet */
	    bomb_planet();
	    break;
	case 'z': /* z = beam up */
	    beam_up();
	    break;
	case 'x': /* x = beam down */
	    beam_down();
	    break;
	case 'R': /* R = Go into repair mode */
	    me->p_flags &= ~(PFPLOCK | PFPLLOCK);
	    repair();
	    break;
	case 'o': /* o = orbit nearest planet */
	    me->p_flags &= ~(PFPLOCK | PFPLLOCK);
	    orbit();
	    break;
	case 'Q':
	    if (copilot || watch)
		exit(1);
	    me->p_flags |= PFSELFDEST;
	    selfdest = me->p_updates + 100;
	    warning("Self destruct initiated");
	    break;
	case '?': /* ? = Redisplay all messages */
	    repeat_message();
	    break;
	case 'c': /* c = cloak */
	    cloak();
	    break;
	case 'C': /* C = coups */
	    coup();
	    break;
	case 'l': /* l = lock onto */
	    /* since a robot would never use this function (it's user
	       Interface dependent,) all the work is done here instead
	       of in interface.c */
	    target = gettarget(data->window, data->x, data->y,
		TARG_PLAYER|TARG_PLANET);
	    if (target->o_type == PLAYERTYPE) {
		me->p_flags |= PFPLOCK;
		me->p_flags &= ~(PFPLLOCK|PFORBIT|PFBEAMUP|PFBEAMDOWN|PFBOMB);
		me->p_playerl = target->o_num;
		p = &players[target->o_num];
		sprintf(buf, "Locking onto %s (%c%d)",
		    p->p_name,
		    teamlet[p->p_team],
		    p->p_no);
		warning(buf);
	    }
	    else { 	/* It's a planet */
		me->p_flags |= PFPLLOCK;
		me->p_flags &= ~(PFPLOCK|PFORBIT|PFBEAMUP|PFBEAMDOWN|PFBOMB);
		me->p_planet = target->o_num;
		pl = &planets[target->o_num];
		sprintf(buf, "Locking onto %s",
		    pl->pl_name);
		warning(buf);
	    }
	    break;
	case '@': /* @ = toggle copilot permissions */
	    me->p_flags ^= PFCOPILOT;
	    break;
	case '*': /* * = send in practice robot */
	    practice_robo();
	    break;
	case '&': /* * = send in a harder practice robot */
	    hard_robo();
	    break;

	/* Start of display functions */
	case ' ': /* ' ' = clear special windows */
	    if (ismapped(playerw))
		XUnmapWindow(dpy, playerw);
	    if (ismapped(planetw))
		XUnmapWindow(dpy, planetw);
	    if (infomapped)
		destroyInfo();
	    if (ismapped(helpWin))
		XUnmapWindow(dpy, helpWin);
	    if (ismapped(war))
		XUnmapWindow(dpy, war);
	    break;
	case 'L': /* L = Player list */
	    if (ismapped(playerw)) {
		XUnmapWindow(dpy, playerw);
	    } else {
	        int playerwX, playerwY, dummy;

	        XTranslateCoordinates( dpy, w, root, 0, 0, 
				      &playerwX, &playerwY, &dummy);
		playerwX += 5;
		playerwY += 5;
		XMoveWindow( dpy, playerw, playerwX, playerwY );
		XMapWindow(dpy, playerw);
	    }
	    break;
	case 'P': /* P = Planet list */
	    if (ismapped(planetw)) {
		XUnmapWindow(dpy, planetw);
	    } else {
	        int planetwX, planetwY, dummy;

	        XTranslateCoordinates( dpy, w, root, 0, 0, 
				      &planetwX, &planetwY, &dummy);
		planetwX += 5;
		planetwY += 5;
		XMoveWindow( dpy, planetw, planetwX, planetwY );
		XMapWindow(dpy, planetw);
	    }
	    break;
	case 'S': /* S = toggle stat mode */
	   if (showStats) {
		showStats = !showStats;
		closeStats(statwin);
	   } else {
		statwin = openStats(me);
		showStats = !showStats;
	   }
	   break;
	case 'M': /* M = Toggle Map mode */
	    mapmode = !mapmode;
	    break;
	case 'N': /* N = Toggle Name mode */
	    namemode = !namemode;
	    break;
	case 'i': /* i = get information */
	    if (!infomapped)
		inform(data->window, data->x, data->y);
	    else
		destroyInfo();
	    break;
	case 'h': /* h = Map help window */
	    if (ismapped(helpWin)) {
		XUnmapWindow(dpy, helpWin);
	    } else {
	        int helpX, helpY, dummy;

	        XTranslateCoordinates( dpy, baseWin, root, 0, 0, 
				      &helpX, &helpY, &dummy);
		helpY += WINSIDE + 2 * borderSize + 2 * messagesize;
		XMoveWindow( dpy, helpWin, helpX, helpY );
		XMapWindow(dpy, helpWin);
	    }
	    break;
	case 'w': /* w = map war stuff */
	    if (copilot) {
		warning("Copilots cannot alter war settings");
		break;
	    }
	    if (ismapped(war))
		XUnmapWindow(dpy, war);
	    else
		warwindow();
	    break;
	default:
	    XBell(dpy, 0);
	    break;
    }
    if (key!='X')
	Ten= 0;
}

buttonaction(data)
XButtonEvent *data;
{
    unsigned char course;
    struct obtype *gettarget(), *target;

    if (watch) {	/* Special case */
	target = gettarget(data->window, data->x, data->y,
	    TARG_PLAYER|TARG_CLOAK);
	setwatch(target->o_num);
	return;
    }

    if ((data->button & 0xf) == Button3) {
	course = getcourse(data->window, data->x, data->y);
	me->p_desdir = course;
	me->p_flags &= ~(PFPLOCK | PFPLLOCK);
    }
    else if ((data->button & 0xf) == Button1) {
	course = getcourse(data->window, data->x, data->y);
	ntorp(course, TMOVE, data->time);
    }
    else if ((data->button & 0xf) == Button2) {
	course = getcourse(data->window, data->x, data->y);
	phaser(course);
    }
}

getcourse(ww, x, y)
Window ww;
int x, y;
{
    if (ww == mapw) {
	int	me_x, me_y;

	me_x = me->p_x * WINSIDE / GWIDTH;
	me_y = me->p_y * WINSIDE / GWIDTH;
#ifdef SYSATAN2
	return((unsigned char) (atan2((double) (x - me_x),
	    (double) (me_y - y)) / 3.14159 * 128.));
#else
	return(myatan2(x - me_x, me_y - y));
	
#endif
    }
    else
#ifdef SYSATAN2
	return((unsigned char) (atan2((double) (x - WINSIDE/2),
	    (double) (WINSIDE/2 - y))
		/ 3.14159 * 128.));
#else
	return( myatan2(x - WINSIDE/2, WINSIDE/2 - y) );
#endif
}

inputIgnored()
{
	if (watch)
	    return(0);
	if (me->p_status != PALIVE)
	    return (1);
	if (me->p_flags & PFWAR) {
	    warning("Battle computers being re-programmed");
	    return (1);
	}
	return (0);
}

setwatch(pno)
int pno;
{
    me = &players[pno];
    myship = &me->p_ship;
    mystats = &me->p_stats;
    lastm = mctl->mc_current;
    redrawall = 1;
    if (showStats) {
	closeStats(statwin);
	statwin = openStats(me);
    }
}
