
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

/* This file will include all the interfaces between the input routines
    and the daemon.  They should be useful for writing robots and the
    like */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/interface.c,v 3.1 88/09/20 00:44:14 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

set_speed(speed)
int speed;
{
    me->p_desspeed = speed;
    me->p_flags &= ~(PFREPAIR | PFBOMB | PFORBIT | PFBEAMUP | PFBEAMDOWN);
}

set_course(dir)
unsigned char dir;
{
    me->p_desdir = dir;
    me->p_flags &= ~(PFBOMB | PFORBIT | PFBEAMUP | PFBEAMDOWN);
}

shield_up()
{
    me->p_flags |= PFSHIELD;
    me->p_flags &= ~(PFBOMB | PFREPAIR | PFBEAMUP | PFBEAMDOWN);
}

shield_down()
{
    me->p_flags &= ~PFSHIELD;
}

shield_tog()
{
    me->p_flags ^= PFSHIELD;
    me->p_flags &= ~(PFBOMB | PFREPAIR | PFBEAMUP | PFBEAMDOWN);
}

bomb_planet()
{
    if (!(me->p_flags & PFORBIT)) {
	warning("Must be orbiting to bomb");
	return;
    }
    me->p_flags |= PFBOMB;
    me->p_flags &= ~(PFSHIELD | PFREPAIR | PFBEAMUP | PFBEAMDOWN);
}

beam_up()
{
    if (!(me->p_flags & PFORBIT)) {
	warning("Must be orbiting to beam up.");
	return;
    }
    if (me->p_team != planets[me->p_planet].pl_owner) {
	warning("Those aren't our men.");
	return;
    }
    me->p_flags |= PFBEAMUP;
    me->p_flags &= ~(PFSHIELD | PFREPAIR | PFBOMB | PFBEAMDOWN);
}

beam_down()
{
    if (!(me->p_flags & PFORBIT)) {
	warning("Must be orbiting to beam down.");
	return;
    }
    me->p_flags |= PFBEAMDOWN;
    me->p_flags &= ~(PFSHIELD | PFREPAIR | PFBOMB | PFBEAMUP);
}

repair()
{
    me->p_desspeed = 0;
    me->p_flags |= PFREPAIR;
    me->p_flags &= ~(PFSHIELD | PFBOMB | PFBEAMUP | PFBEAMDOWN);
}

repair_off()
{
    me->p_flags &= ~PFREPAIR;
}

/*
case 'Q':
    me->p_flags |= PFSELFDEST;
    selfdest = me->p_updates + 100;
    warning("Self destruct initiated");
    return;
*/

repeat_message()
{
    if (++lastm == MAXMESSAGE) ;
	lastm = 0;
}

cloak()
{
    me->p_flags ^= PFCLOAK;
}

cloak_on()
{
    me->p_flags |= PFCLOAK;
}

cloak_off()
{
    me->p_flags &= ~PFCLOAK;
}
