
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/main.c,v 3.1 88/09/20 00:44:17 jeff Exp $";

#ifdef VARSIDE
int winside = WINSIDE;
int scale = SCALE;
#endif

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include <pwd.h>
#ifndef hpux
#include <sys/wait.h>
#endif hpux
#include "defs.h"
#include "struct.h"
#include "data.h"

int remapgalaxy;	/* if galaxy is to be remaped */
int noshipclass;	/* if configurable ships aren't allowed */
int debug;
jmp_buf env;

main(argc, argv)
int argc;
char **argv;
{
    int intrupt();
    int team;
    int pno;
    char *host = NULL;
    int usage = 0;
    int err = 0;
    char *name, *ptr, *rindex();
    char buf[80];
    struct passwd *pwent, *getpwuid();
    int reaper();
    extern	char	*shipclass;
    int dummy;

    name = *argv++;
    argc--;
    if ((ptr = rindex(name, '/')) != NULL)
	name = ptr + 1;
    while (*argv) {
	if (**argv == '-')
	    *++*argv;
	else
	    break;

	argc--;
	ptr = *argv++;
	while (*ptr) {
	    switch (*ptr) {
	    case 'u': usage++; break;
	    case 'c': 
		if (*argv == 0) {
		    fprintf(stderr, "Missing required player number\n");
		    err++;
		    break;
		}
		pno = atoi(*argv);
		argc--;
		argv++;
		if (pno < 0 || pno >= MAXPLAYER) {
		    fprintf(stderr, "Bad Player Number: %d\n", pno);
		    err++;
		} else
		    copilot++; 
		break;
#ifdef VARSIDE
	    case 'v':
		if (argv[0] == 0 || argv[1] == 0) {
		    fprintf(stderr, "Missing window size or scale for -v\n");
		    err++;
		    break;
		}
		winside = atoi(argv[0]);
		if (winside < 200 || winside > 10000) {
		    fprintf(stderr, "Window size (%d) out of range\n",winside);
		    err++;
		    break;
		}
		scale = atoi(argv[1]);
		if (scale < 10 || scale > 100) {
		    fprintf(stderr, "scale (%d) out of range\n",scale);
		    err++;
		    break;
		}
		argc -= 2;
		argv += 2;
		break;
#endif
	    case 'w': 
		if (*argv == 0) {
		    fprintf(stderr, "Missing required player number\n");
		    err++;
		    break;
		}
		pno = atoi(*argv);
		argc--;
		argv++;
		if (pno < 0 || pno >= MAXPLAYER) {
		    fprintf(stderr, "Bad Player Number: %d\n", pno);
		    err++;
		} else
		    watch++; 
		break;
	    case 'D':
		++debug;
		break;
	    case 'd':
		host = *argv;
		while ( *ptr )
		    ptr++;
		ptr--;
		argc--;
		argv++;
		break;
	    case 'g':
		XParseGeometry( *argv, &startX, &startY, &dummy, &dummy );
		while ( *ptr )
		    ptr++;
		ptr--;
		argc--;
		argv++;
		break;
	    case 'S':
		++noshipclass;
		break;
	    case 's':
		shipclass = *argv;
		argc--;
		argv++;
		break;
	    case 'r':
		++remapgalaxy;
		break;
	    default: 
		fprintf(stderr, "%s: unknown option '%c'\n", name, *ptr);
		err++;
		break;
	    }
	    ptr++;
	}
    }
    if (usage || err) {
	printUsage(name);
	exit(err);
    }
    if (watch && copilot) {
	printf("%s: Cannot simultaneously use both watch and copilot.",
		name);
	exit(err);
    }
    /* compatability */
    if (argc > 0)
	host = argv[0];
    srandom(getpid() * time((long *) 0));
    /* this creates the necessary x windows for the game */
    newwin(host, name);
    /* this finds the shared memory information */
    openmem();
    /* map the windows */
    mapAll();
    if ((!copilot) && (!watch)) {
	pno = findslot();
    }
    if (pno < 0) {
	/* print some appropriate message */
	exit(1);
    }
    me = &players[pno];
    myship = &me->p_ship;
    mystats = &me->p_stats;
    lastm = mctl->mc_current;
    signal(SIGINT, SIG_IGN);
    signal(SIGQUIT, SIG_IGN);
    (void) signal(SIGCLD, reaper);

    if ((!copilot) && (!watch)) {
	me->p_team = ALLTEAM;   /* Give full choice in startup window */
	setjmp(env);		/* Reentry point of game */
	/* give the player the motd and find out which team he wants */
	team = entrywindow();
	if (team == -1) {
	    if (me != NULL)
		savestats();
	    players[pno].p_status = PFREE;
	    exit(0);
	}
	time(&start_time);		/* For stat gathering */
	redrawall = 1;
	enter(team, XDisplayString(dpy), pno);
	XClearWindow(dpy, w);
	/*
	for (i = 0; i < NSIG; i++) {
	    signal(i, SIG_IGN);
	}
	*/

	if (showStats)			/* Default showstats are on. */
	    statwin = openStats(me);

	me->p_status = PALIVE;			/* Put player in game */
	me->p_ghostbuster = 0;
    }
    else if (copilot) {
	if (me->p_status != PALIVE)
	    exit(1);
	if (!(me->p_flags & PFCOPILOT)) {
	    printf("%s is not allowing copilots\n", me->p_name);
	    exit(1);
	}
	if (showStats)			/* Default showstats are on. */
	    statwin = openStats(me);

	if ((pwent = getpwuid(getuid())) == NULL)
	    sprintf(buf, "Unknown person joining as a copilot");
	else
	    sprintf(buf, "%-8s joining as a copilot", pwent->pw_name);
	
	pmessage(buf, pno, MINDIV, "GOD->YOU");
    }
    /* else (watch) */
    /* Get input until the player quits or dies */
    input();
}

printUsage(prog)
	char	*prog;
{
	printf("Usage: %s [-r] [-u] [-[cw] copilot-number] [-d display-name]\n",
		prog);
}

reaper(sig)
{
#ifdef hpux
    wait((int *) 0);
#else hpux
    while (wait3((union wait *) 0, WNOHANG, (struct rusage *) 0) > 0)
	;
#endif hpux
}
