/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

#include <math.h>
#include <stdio.h>

int at2tab1[256] = 
	{
	0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 
	2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 
	5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 
	7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 
	10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 
	12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 
	14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 
	16, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 
	18, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 
	20, 21, 21, 21, 21, 21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 
	22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 24, 24, 24, 24, 
	24, 24, 24, 24, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 27, 27, 27, 
	27, 27, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 
	29, 29, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 30, 30, 30, 
	30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31
	};

int at2tab2[256] = 
	{
	64, 63, 63, 63, 63, 63, 62, 62, 62, 62, 62, 62, 62, 61, 61, 61, 
	61, 61, 61, 60, 60, 60, 60, 60, 60, 59, 59, 59, 59, 59, 59, 59, 
	58, 58, 58, 58, 58, 58, 57, 57, 57, 57, 57, 57, 56, 56, 56, 56, 
	56, 56, 56, 55, 55, 55, 55, 55, 55, 54, 54, 54, 54, 54, 54, 54, 
	53, 53, 53, 53, 53, 53, 53, 52, 52, 52, 52, 52, 52, 52, 51, 51, 
	51, 51, 51, 51, 51, 50, 50, 50, 50, 50, 50, 50, 49, 49, 49, 49, 
	49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 47, 47, 47, 47, 47, 47, 
	47, 46, 46, 46, 46, 46, 46, 46, 46, 45, 45, 45, 45, 45, 45, 45, 
	45, 44, 44, 44, 44, 44, 44, 44, 44, 43, 43, 43, 43, 43, 43, 43, 
	43, 42, 42, 42, 42, 42, 42, 42, 42, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 37, 37, 
	37, 37, 37, 37, 37, 37, 37, 37, 36, 36, 36, 36, 36, 36, 36, 36, 
	36, 36, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 34, 34, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 33, 33, 33, 33, 33, 33, 33, 33, 
	33, 33, 33, 33, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32
	};

int
myatan2(y, x)
int y, x;
	{
	int signx, signy;
	int add=0, retsign=1;
	int t;

	signx = (x>=0) ? 1 : (-1); 
	if ( signx < 0 )
		{
		x = -x;
		retsign = -retsign;
		add = 128;
		}

	signy = (y>=0) ? 1 : (-1); 
	if ( signy < 0 )
		{
		y = -y;
		retsign = -retsign;
		}

	if ( x == 0 )
		return( (unsigned char) ( signy * 64 ) );

	if ( y == 0 )
		return( (unsigned char) ( ( 1-signx ) * 64 ) );

	if ( x == y )
		t = 32;
	else if ( x > y )
		t = at2tab1[(256 * y )/x];
	else
		t = at2tab2[(256 * x )/y];

	return( (unsigned char) ( add + (retsign * t) ) );
	}

inittabs()
	{
	int i;
	for ( i = 0; i < 256; i++ )
		{
		at2tab1[i] = (unsigned char) ( atan((double)((1.0/256.0)*((double)(i+0.5)))) / 3.14159 * 128.0 );
		if ( i == 0 )
			at2tab2[0] = 64;
		else
			at2tab2[i] = (unsigned char) (atan( (double)( 1 / ((1.0/256.0)*((double)(i+0.5))) )) / 3.14159 * 128 ); 
		}
	}

int
myhypot(x, y)
	int x, y;
	{
	return((int)sqrt((double)(x*x+y*y)));
	}
