
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/phaser.c,v 3.1 88/09/20 00:44:32 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

phaser(course)
unsigned char course;
{
    register int i;
    register struct player *j, *target;
    register struct phaser *mine;
    unsigned char dir;
    int range, trange;
    int	accuracy;
    char buf[80];

    mine = &phasers[me->p_no];

    if (mine->ph_status != PHFREE) {
	warning("Phasers have not recharged");
	return;
    }
    if (me->p_fuel < myship->s_phasercost) {
	warning("Not enough fuel for phaser");
	return;
    }
    if (me->p_flags & PFREPAIR) {
	warning("Can't fire while repairing");
	return;
    }
    if (me->p_flags & PFWEP) {
	warning("Weapons overheated");
	return;
    }
    if (me->p_flags & PFCLOAK) {
	warning("Cannot fire while cloaked, deactivating cloaking device");
	me->p_flags &= ~PFCLOAK;
	return;
    }

    me->p_fuel -= myship->s_phasercost;
    me->p_wtemp += myship->s_phasercost / 10;
    target = (struct player *) 0;
    mine->ph_dir = course;
    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	if ((j->p_status != PALIVE) || (j == me))
	    continue;
	if ((!((j->p_swar | j->p_hostile) & me->p_team)) &&
	    (!((me->p_swar | me->p_hostile) & j->p_team)))
		continue;
#ifdef SYSATAN2
	dir = (unsigned char) (atan2((double) (j->p_x - me->p_x),
	    (double) (me->p_y - j->p_y))
	    / 3.14159 * 128.);
#else
	dir = myatan2( j->p_x - me->p_x, me->p_y - j->p_y );
#endif
	trange = (int) hypot((double) (j->p_x - me->p_x),(double) (j->p_y - me->p_y));

	accuracy = trange==0 ? 128 : trange<=EXPDIST ? 64 :
	    atan(EXPDIST/sqrt((double)(trange*trange - EXPDIST*EXPDIST)))/3.14159*128.;

	if (angdist(dir, course) <= accuracy) {
	    if (target == 0) {
		target = j;
		range = trange;
	    }
	    else if (range > trange) {
		target = j;
		range = trange;
	    }
	}
    }

    if ((target == 0) || (range > PHASEDIST(myship))) {
	mine->ph_fuse = 10;
	mine->ph_status = PHMISS;
	warning("Phaser missed!!!");
    }
    else {
	mine->ph_fuse = 10;
	mine->ph_target = target->p_no;
	mine->ph_damage = (PHASEDIST(myship)- range) * myship->s_phaserdamage / PHASEDIST(myship);
	mine->ph_status = PHHIT;
	(void) sprintf(buf, "Phaser hit %s for %d points",
	    target->p_name,
	    mine->ph_damage);
	warning(buf);
    }
    mystats->st_phasers++;
}
