
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/scores.c,v 3.1 88/09/20 00:48:09 jeff Exp $";

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <pwd.h>
#include "defs.h"
#include "struct.h"

#define MAXENT 2000

struct stats old;

main()
{
    int fd;
    register int i;
    struct passwd *buf;

    fd = open(SCOREFILE, O_RDONLY, 0777);
    if (fd < 0) {
	perror(SCOREFILE);
	exit(1);
    }
    fprintf(stdout, "Name      rtime             cpu       kills  maxkills    losses  entries conqs coups     torps  phasers    abomb aship planets gens ratio Name\n");

    for (i = 0; i < MAXENT; i++) {
	if (read(fd, &old, sizeof(struct stats)) == 0)
	    break;
	if (old.st_entries > 0) {
	    buf = getpwuid(i);
	    if (buf <= 0)
		continue;
	    fprintf(stdout, "%-8s %15d %6d %11.2f    %6.2f %9d %8d %5d %5d %9d %8d %8d %5d %7d %4d %5.3f %-8s\n",
		buf->pw_name,
		old.st_time,
		old.st_cpu,
		old.st_kills,
		old.st_maxkills,
		old.st_losses,
		old.st_entries,
		old.st_conqs,
		old.st_coups,
		old.st_torps,
		old.st_phasers,
		old.st_armsbomb,
		old.st_armsship,
		old.st_planets,
		old.st_genocides,
		(old.st_losses ? old.st_kills / old.st_losses : 0.0),
		buf->pw_name);

	}
    }
}
