
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/startdaemon.c,v 3.1 88/09/20 00:44:54 jeff Exp $";


#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

startdaemon()
{
    int i;
    extern int noshipclass;
    extern int remapgalaxy;
    char *argv[5];
    int argc = 0;

    i = fork();
    if (i == 0) {
	XCloseDisplay(dpy);
	argv[argc++] = "daemon"; 
	if (noshipclass)
	    argv[argc++] = "-S";
	if (remapgalaxy)
	    argv[argc++] = "-r";
	argv[argc] = 0;
	execv(DAEMON, argv);
	perror(DAEMON);
	fprintf(stderr, "Couldn't start daemon!!!\n");
	_exit(1);
    }
}

practice_robo()
{
    char *arg1;
    register int i;
    register struct player *j;

    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	if (j->p_status != PALIVE)
	    continue;
	if (j == me)
	    continue;
	warning("Can't send in practice robot with other players in the game.");
	return;
    }

    if (fork() == 0) {
	(void) signal(SIGALRM, SIG_DFL);
	(void) close(0);
	(void) close(1);
	(void) close(2);
	(void) close(dpyno());
	switch (me->p_team) {
	    case FED:
		arg1 = "-Tf";
		break;
	    case ROM:
		arg1 = "-Tr";
		break;
	    case KLI:
		arg1 = "-Tk";
		break;
	    case ORI:
		arg1 = "-To";
		break;
	}
	execl(ROBOT, "robot", arg1, "-p", "-f", "-h", 0);
	/* If we get here, we are hosed anyway */
	_exit(1);
    }
}


hard_robo()
{
    char *arg1;
    register int i;
    register struct player *j;

    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	if (j->p_status != PALIVE)
	    continue;
	if (j == me)
	    continue;
	warning("Can't send in practice robot with other players in the game.");
	return;
    }

    if (fork() == 0) {
	(void) signal(SIGALRM, SIG_DFL);
	(void) close(0);
	(void) close(1);
	(void) close(2);
	(void) close(dpyno());
	switch (me->p_team) {
	    case FED:
		arg1 = "-Tf";
		break;
	    case ROM:
		arg1 = "-Tr";
		break;
	    case KLI:
		arg1 = "-Tk";
		break;
	    case ORI:
		arg1 = "-To";
		break;
	}
	execl(ROBOT, "robot", arg1, "-b", "-f", "-h", 0);
	/* If we get here, we are hosed anyway */
	_exit(1);
    }
}
