
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/util.c,v 3.1 88/09/20 00:44:59 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

/*
** Provide the angular distance between two angles.
*/
angdist(x, y)
unsigned char x, y;
{
    register unsigned char res;

    res = ABS(x - y);
    if (res > 128)
	return(256 - (int) res);
    return((int) res);
}

/*
** Find the object nearest mouse.  Returns a pointer to an
** obtype structure.  This is used for info and locking on.
**
** Because we are never interested in it, this function will
** never return your own ship as the target.
**
** Finally, this only works on the two main windows
*/

static struct obtype _target;

struct obtype *
gettarget(ww, x, y, targtype)
Window ww;
int x, y;
int targtype;
{
    register int i;
    register struct player *j;
    register struct planet *k;
    int	g_x, g_y;
    double dist, closedist;

    if (ww == mapw) {
	g_x = x * GWIDTH / WINSIDE;
	g_y = y * GWIDTH / WINSIDE;
    }
    else {
	g_x = me->p_x + ((x - WINSIDE/2) * SCALE);
	g_y = me->p_y + ((y - WINSIDE/2) * SCALE);
    }
    closedist = GWIDTH;

    if (targtype & TARG_PLANET) {
	for (i = 0, k = &planets[i]; i < MAXPLANETS; i++, k++) {
	    dist = hypot((double) (g_x - k->pl_x), (double) (g_y - k->pl_y));
	    if (dist < closedist) {
		_target.o_type = PLANETTYPE;
		_target.o_num = i;
		closedist = dist;
	    }

	}
    }

    if (targtype & TARG_PLAYER) {
	for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	    if (j->p_status != PALIVE)
		continue;
	    if ((j->p_flags & PFCLOAK) && (!(targtype & TARG_CLOAK)))
		continue;
	    if (j == me)
		continue;
	    dist = hypot((double) (g_x - j->p_x), (double) (g_y - j->p_y));
	    if (dist < closedist) {
		_target.o_type = PLAYERTYPE;
		_target.o_num = i;
		closedist = dist;
	    }
	}
    }

    if (closedist == GWIDTH) {		/* Didn't get one.  bad news */
	_target.o_type = PLAYERTYPE;
	_target.o_num = me->p_no;	/* Return myself.  Oh well... */
	return(&_target);
    }
    else {
	return(&_target);
    }
}

/*
** Tell us if a window is currently visible on the screen
*/

ismapped(win)
Window win;
{
    XWindowAttributes info;
    
    XGetWindowAttributes(dpy, win, &info);


    return (info.map_state != IsUnmapped);
}

#ifdef hpux

srandom(foo)
int foo;
{
    rand(foo);
}

random()
{
    return(rand());
}

#include <sys/resource.h>

getrusage(foo, buf)
int foo;
struct rusage *buf;
{
    buf->ru_utime.tv_sec = 0;
    buf->ru_stime.tv_sec = 0;
}

#include <sys/signal.h>

int (*
signal(sig, funct))()
int sig;
int (*funct)();
{
    struct sigvec vec, oldvec;

    sigvector(sig, 0, &vec);
    vec.sv_handler = funct;
    sigvector(sig, &vec, (struct sigvec *) 0);
}
#endif hpux
