
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/war.c,v 3.1 88/09/20 00:45:01 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"


static int newhostile;
static int reprogram;

/* Set up the war window and map it */
static char *feds = "FED - ";
static char *roms = "ROM - ";
static char *klis = "KLI - ";
static char *oris = "ORI - ";
static char *gos = "  Re-program";
static char *exs = "  Exit - no change";
static char *peaces = "Peace";
static char *hostiles = "Hostile";
static char *wars = "War";

warwindow()
{
    XMapWindow(dpy, war);
    newhostile = me->p_hostile;
    reprogram = 0;
    warrefresh();
}

warrefresh()
{
    fillwin(warf, feds, newhostile, me->p_swar, FED);
    fillwin(warr, roms, newhostile, me->p_swar, ROM);
    fillwin(wark, klis, newhostile, me->p_swar, KLI);
    fillwin(waro, oris, newhostile, me->p_swar, ORI);
    XText(wargo, 0, FONTHEIGHT(dfontinfo) / 2, gos, strlen(gos), dfont,
	textColor, backColor);
    XText(warno, 0, FONTHEIGHT(dfontinfo) / 2, exs, strlen(exs), dfont,
	textColor, backColor);
}

fillwin(win, string, hostile, warbits, team)
Window win;
char *string;
int hostile, warbits;
int team;
{
    char buf[80];
    XPixSet(win, 0, FONTHEIGHT(dfontinfo) / 2, FONTWIDTH(dfontinfo) * 20,
	FONTHEIGHT(dfontinfo), backColor); 
    if (team & warbits) {
	(void) sprintf(buf, "  %s%s", string, wars);
	XText(win, 0, FONTHEIGHT(dfontinfo) / 2, buf, strlen(buf), dfont,
	    rColor, backColor);
    }
    else if (team & hostile) {
	(void) sprintf(buf, "  %s%s", string, hostiles);
	XText(win, 0, FONTHEIGHT(dfontinfo) / 2, buf, strlen(buf), dfont,
	    yColor, backColor);
    }
    else {
	(void) sprintf(buf, "  %s%s", string, peaces);
	XText(win, 0, FONTHEIGHT(dfontinfo) / 2, buf, strlen(buf), dfont,
	    gColor, backColor);
    }
}

waraction(data)
XButtonEvent *data;
{
    int changes;

    if ((data->window != warno) && (watch)) {
	warning("can't modify war settings from watch");
	return;
    }
    if (data->window == warf) {
	if (me->p_swar & FED) {
	    warning("You are already at war with the Federation");
	    XBell(dpy, 0);
	}
	else {
	    newhostile ^= FED;
	}
    }
    if (data->window == warr) {
	if (me->p_swar & ROM) {
	    warning("You are already at war with the Romulans");
	    XBell(dpy, 0);
	}
	else {
	    newhostile ^= ROM;
	}
    }
    if (data->window == wark) {
	if (me->p_swar & KLI) {
	    warning("You are already at war with the Klingons");
	    XBell(dpy, 0);
	}
	else {
	    newhostile ^= KLI;
	}
    }
    if (data->window == waro) {
	if (me->p_swar & ORI) {
	    warning("You are already at war with the Orions");
	    XBell(dpy, 0);
	}
	else {
	    newhostile ^= ORI;
	}
    }
    warrefresh();

    if (data->window == wargo) {
	changes = me->p_hostile ^ newhostile;
	if (changes & FED) {
	    sendwarn("Federation", newhostile & FED, FED);
	}
	if (changes & ROM) {
	    sendwarn("Romulans", newhostile & ROM, ROM);
	}
	if (changes & KLI) {
	    sendwarn("Klingons", newhostile & KLI, KLI);
	}
	if (changes & ORI) {
	    sendwarn("Orions", newhostile & ORI, ORI);
	}
	me->p_hostile = newhostile;
	if (reprogram) {
	    delay = me->p_updates + 100;
	    me->p_flags |= PFWAR;	/* stop copilots, mostly */
	    warning("Pausing ten seconds to re-program battle computers.");
	}
	XUnmapWindow(dpy, war);
	return;
    }

    if (data->window == warno) {
	XUnmapWindow(dpy, war);
	return;
    }
}

sendwarn(string, atwar, team)
char *string;
int atwar;
int team;
{
    char buf[BUFSIZ];
    char addrbuf[10];

    if (atwar) {
	(void) sprintf(buf, "%s (%c%x) declaring war on the %s",
	    me->p_name,
	    teamlet[me->p_team],
	    me->p_no,
	    string);
	reprogram = 1;
    }
    else {
	(void) sprintf(buf, "%s (%c%x) declaring peace with the %s",
	    me->p_name,
	    teamlet[me->p_team],
	    me->p_no,
	    string);
    }

    (void) sprintf(addrbuf, " %c%x->%-3s",
	teamlet[me->p_team],
	me->p_no,
	teamshort[team]);
    pmessage(buf, team, MTEAM, addrbuf);
}
