/*
 * x11utils.c
 * X10 routines XTrek needs but which are not in X11
 * By Jeff Weinstein
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/x11utils.c,v 3.1 88/09/20 00:46:00 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/X10.h>
#include "data.h"
#include <stdio.h>

XText(w, x, y, str, len, font, fg, bg)
	Window w;
	int x, y;
	char * str;
	int len;
	Font font;
	int fg, bg;
	{
	static buf[512];
	static GC gc = 0;
	XFontStruct *fontinfo;
	static XAssocTable *assoc = NULL;
	XCharStruct charinfo;
	int dummy;

	bcopy(str, buf, len);

	if ( assoc == NULL )
		assoc = XCreateAssocTable(8);

	if ( gc == 0 )
		gc = XCreateGC(dpy, root, 0, NULL);

	XSetForeground(dpy, gc, fg);
	XSetBackground(dpy, gc, bg);
	XSetFont(dpy, gc, font);

	if ( ( fontinfo = (XFontStruct *)XLookUpAssoc(dpy, assoc, (XID)font) ) == (XFontStruct *)NULL ) 
		{
		fontinfo = XQueryFont(dpy, font);
		XMakeAssoc(dpy, assoc, (XID)font, (char *)fontinfo);
		}
	XTextExtents(fontinfo, buf, len, &dummy, &dummy, &dummy, &charinfo);
	y += charinfo.ascent;
	x -= charinfo.lbearing;
/*
	y += fontinfo->max_bounds.ascent;
	x -= fontinfo->max_bounds.lbearing;
*/

	XDrawImageString(dpy, w, gc, x, y, buf, len);
	/*XFlush(dpy);*/
	}

XTextMask(w, x, y, str, len, font, fg)
	Window w;
	int x, y;
	char * str;
	int len;
	Font font;
	int fg;
	{

	static GC gc = 0;
	XFontStruct *fontinfo;
	static XAssocTable *assoc = NULL;

	if ( assoc == NULL )
		assoc = XCreateAssocTable(8);

	if ( gc == 0 )
		gc = XCreateGC(dpy, root, 0, NULL);

	XSetForeground(dpy, gc, fg);
	XSetFont(dpy, gc, font);

	if ( ( fontinfo = (XFontStruct *)XLookUpAssoc(dpy, assoc, (XID)font) ) == (XFontStruct *)NULL ) 
		{
		fontinfo = XQueryFont(dpy, font);
		XMakeAssoc(dpy, assoc, (XID)font, (char *)fontinfo);
		}

	y += fontinfo->max_bounds.ascent;
	x -= fontinfo->max_bounds.lbearing;

	XDrawString(dpy, w, gc, x, y, str, len);
	/*XFlush(dpy);*/
	}

XPixSet(w, x, y, width, height, pixel)
	Window w;
	int x, y, width, height, pixel;
	{
	static GC gc = 0;

	if ( gc == 0 )
		gc = XCreateGC(dpy, root, 0, NULL);

	XSetForeground(dpy, gc, pixel);
	
	XFillRectangle(dpy, w, gc, x, y, width, height);
	/*XFlush(dpy);*/
	}

void
DrawGlyph( w, x, y, pixel, glyph )
	Window w;
	int x, y, pixel;
	char glyph;
	{
	static GC gc = 0;
	static Font xtrekfont;

	if ( gc == 0 )
		{
		gc = XCreateGC(dpy, root, 0, NULL);
		xtrekfont = XLoadFont(dpy, "xtrek\0");
		XSetFont(dpy, gc, xtrekfont);
		}

	XSetForeground(dpy, gc, pixel);
	XDrawString(dpy, w, gc, x, y, &glyph, 1);
	}

XPixFill(w, x, y, width, height, pixel, clipmask, func, planes)
	Window w;
	int x, y, width, height, pixel;
	Pixmap clipmask;
	int func, planes;
	{
	static GC gc = 0;

	if ( gc == 0 )
		{
		gc = XCreateGC(dpy, root, 0, NULL);
		XSetFillStyle(dpy, gc, FillStippled);
		}

	XSetForeground(dpy, gc, pixel);
	XSetFunction(dpy, gc, func);
	XSetPlaneMask(dpy, gc, planes);
	XSetStipple(dpy, gc, clipmask);
	XSetTSOrigin(dpy, gc, x, y);
	
	XFillRectangle(dpy, w, gc, x, y, width, height);

	/*XFlush(dpy);*/
	}

Pixmap
XMakeTile(pixel)
	int pixel;
	{
	static GC gc = 0;
	Pixmap pixmap;

	if ( gc == 0 )
		gc = XCreateGC(dpy, root, 0, NULL);

	XSetForeground(dpy, gc, pixel);
	pixmap = XCreatePixmap( dpy, root, 32, 32, DefaultDepth(dpy, screen) );
	
	XFillRectangle(dpy, pixmap, gc, 0, 0, 32, 32);
	XFlush(dpy);
	return(pixmap);
	}

XLine(w, x1, y1, x2, y2, width, height, pixel, func, planes)
	Window w;
	int x1, y1, x2, y2, width, height, pixel;
	int func, planes;
	{
	static GC gc = 0;

	if ( gc == 0 )
		gc = XCreateGC(dpy, root, 0, NULL);

	XSetForeground(dpy, gc, pixel);
	XSetFunction(dpy, gc, func);
	XSetPlaneMask(dpy, gc, planes);
	if ( width == 1 )
		width = 0;
	XSetLineAttributes(dpy, gc, width, LineSolid, CapButt, JoinMiter);
	
	XDrawLine(dpy, w, gc, x1, y1, x2, y2);
	/*XFlush(dpy);*/
	}

Window
X10CreateWindow(parent, x, y, width, height, borderwidth, border, bg)
	Window parent;
	int x, y, width, height, borderwidth;
	Pixmap border, bg;
	{
	Window w;
	XSetWindowAttributes attr;

	attr.background_pixmap = bg;
	attr.border_pixmap = border;
	w = XCreateWindow(dpy, parent, x, y, width, height, borderwidth, 
		DefaultDepth(dpy, screen), InputOutput, 
		DefaultVisual(dpy, screen), CWBackPixmap|CWBorderPixmap, &attr);
	XFlush(dpy);
	return(w);
	}

Pixmap
CreateBitmap(dpy, draw, data, w, h)
	Display *dpy;
	Drawable draw;
	char *data;
	int w, h;
	{
	XImage *image;
	static GC gc = 0;
	Pixmap pixmap;

	return( XCreateBitmapFromData(dpy, draw, data, w, h) );
	image = XCreateImage(dpy, DefaultVisual(dpy, screen), 1, XYBitmap, 0, data, w, h, 8, 0);

	pixmap = XCreatePixmap(dpy, draw, w, h, 1);

	if ( gc == 0 )
		gc = XCreateGC(dpy, pixmap, 0, NULL);

	XPutImage(dpy, pixmap, gc, image, 0, 0, 0, 0, w, h);
	XFree(image);
	XFlush(dpy);
	return(pixmap);
	}

xtIOError(dpy)
	Display *dpy;
	{
	fprintf(stderr, "Fatal I/O Error\n");
	perror("xtIOError");
	abort();
	}

Cursor
XCreateCursor( w, h, cursor, mask, xhot, yhot, fg, bg, alu)
	int w, h;
	char *cursor, *mask;
	int xhot, yhot, fg, bg, alu;
	{
	XColor curf, curb;
	Pixmap cur, curm;
	Cursor ret;

	cur = CreateBitmap(dpy, root, cursor, w, h);
	curm = CreateBitmap(dpy, root, mask, w, h);
	curf.pixel = fg;
	curb.pixel = bg;
	XQueryColor(dpy, cmap, &curf);
	XQueryColor(dpy, cmap, &curb);
	ret = XCreatePixmapCursor(dpy, cur, curm, &curf, &curb, xhot, yhot);
	XFreePixmap(dpy, cur);
	XFreePixmap(dpy, curm);
	return ( ret );
	}

	
