#ifndef lint
static char rcs_id[] = "$Header: reborder.c,v 1.2 87/12/22 13:56:28 rws Exp $";
#endif

/*
 *			  COPYRIGHT 1987
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
 * APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
 * SET FORTH ABOVE.
 *
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting documentation,
 * and that the name of Digital Equipment Corporation not be used in advertising
 * or publicity pertaining to distribution of the software without specific, 
 * written prior permission.
 */

/*
 * This program will regenerate reasonable window borders after some
 * unfriendly window manager has done them in...
 *
 * Author: Jim Gettys, Sept. 20
 */

#include <stdio.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <ctype.h>
#include <X11/Xatom.h>

Bool OkToReborder();
Bool OnList();

#define DEFAULT_BORDER_SIZE 2

main (argc, argv)
    int argc;
    char **argv;
{
    Display * dpy;
    int i;
    char *displayname = NULL;
    char *filename = NULL;
    Window *children;
    Window root, parent;
    unsigned int nchildren;
    char *wp;
    int nw = DEFAULT_BORDER_SIZE;

    for (i = 1; i < argc; i++) {
	if (index (argv[i], ':') != NULL) displayname = argv[i];
	else filename = argv[i];
	if (argv[i][0] == '-') wp = argv[i] + 1;
    }

    /* Open display  */
    if (!(dpy = XOpenDisplay (displayname))) {
	(void) fprintf (stderr, "%s: Can't open display '%s'\n",
		argv[0], XDisplayName (displayname));
	exit (1);
    }
    if (wp == NULL) wp = XGetDefault (dpy, argv[0], "borderwidth");
    if (wp != NULL && *wp != '\0')
	if (sscanf (wp, "%d", &nw) != 1) nw = DEFAULT_BORDER_SIZE;

   XQueryTree (dpy, DefaultRootWindow(dpy), &root, &parent, &children,
	&nchildren);
   for (i= 0; i < (int)nchildren; i++) {
	if (OkToReborder(dpy, children[i])) {
	        XWindowChanges cw;
		Window root;
		int depth;
		int width, height;
		int oldwidth;
		cw.border_width = nw;
		XGetGeometry(dpy, children[i], &root, &cw.x, &cw.y, 
			&width,	&height, &oldwidth, &depth);
		cw.x -= cw.border_width - oldwidth;
		cw.y -= cw.border_width - oldwidth;
		XConfigureWindow(dpy, children[i], 
			CWX|CWY|CWBorderWidth, &cw);
	}
   }
   XFree (children);
   XCloseDisplay(dpy);
}

Bool OnList(properties, nprops, atom)
   register Atom *properties;
   int nprops;
   register Atom atom;
{
   register int i;
   for (i = 0; i < nprops; i++) {
	if (properties[i] == atom) return True;
	}
   return False;
}

Bool OkToReborder(dpy, w)
   Display *dpy;
   Window w;
{
   Atom *properties;
   int nprops;
   properties = XListProperties(dpy, w, &nprops);
   if (OnList(properties, nprops, XA_WM_TRANSIENT_FOR)) {
	XFree(properties);
	return False;
	}
   XFree(properties);
   return True;
}
