.TH xsetsize 1
.SH NAME
.I xsetsize - 
allows you to move, resize, and iconify an windows from the command line.
.SH SYNOPSIS
.B xsetsize [-options ...]
.SH DESCRIPTION
.I Xsetsize
allows you to move, resize and iconify a window from the command line.  It
is useful for placing window exactly, changing border widths, and testing
robustness of programs.
.PP
If you are executing this file on login, make sure that you give your
window manager enough time to get set before trying to iconify the window.
.SH "OPTIONS"
.TP 8
.B "\-display \fIdisplay\fP"
This option specifies the name of the X server to contact.
.TP 8
.B "\-geometry \fIgeom\fP"
This option specifies the geometry string to be used when moving or resizing
windows or icons.  Note that icon sizing is not supported.
.TP 8
.B \-relative
This option indicates that the geometry specification should be interpreted
as a relative amount rather than an absolute amount.  This allows you push
windows around on the screen.
.TP 8
.B "\-bw \fIpixels\fP"
This option specifies the width of the window border in pixels.
.TP 8
.B \-iconic
This option indicates that the geometry, if given, should be used in moving
the icon.  It also causes the window to be iconified.  Thus, ``xsetsize
-iconic'' can be used to iconify a window without changing its size or
location.
.SH "SEE ALSO"
X(1), xwininfo(1), uwm(1), wm(1), xterm(1)
.SH ENVIRONMENT
.TP 10
.B WINDOWID 
to determine the window to use when the \fB\-env\fP option is given.
.br
.SH BUGS
There is a bug in uwm that does not allow the icon to be moved by anyone
else once it has been created, so the geometry specification for the icon
is ignored if it has previosly been iconified.
.PP
Negative locations for the icons do not work.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.SH AUTHOR
John E. Elsbree, Christopher J. VanHaren, Chris Peterson, MIT Project Athena;
Jim Fulton, MIT X Consortium.
