-------- diff /d/R3.bits/server/ddx/mi/mivaltree.c mivaltree.c --------
*** /d/R3.bits/server/ddx/mi/mivaltree.c	Tue Sep  6 11:49:37 1988
--- mivaltree.c	Thu Oct 20 19:40:57 1988
***************
*** 39,48 ****
--- 39,51 ----
  #include    "X.h"
  #include    "scrnintstr.h"
  #include    "windowstr.h"
  #include    "mi.h"
  #include    "region.h"
+ #ifdef sgi
+ #include    "regionstr.h"
+ #endif
  
  static RegionPtr	exposed = NullRegion;
  
  static void	(*clipNotify)() = 0;
  
***************
*** 432,441 ****
--- 435,450 ----
  				     * the marked children. pParent's clipList
  				     * merged with the borderClips of all
  				     * the marked children. */
      RegionPtr	  	childClip;  /* The new borderClip for the current
  				     * child */
+ #ifdef sgi
+     RegionPtr		rootClip;   /*  Used when validating at root, to
+ 				     * prevent top level GL windows from
+ 				     * clipping each other.
+ 				     */
+ #endif
      register ScreenPtr	pScreen;
      register WindowPtr	pWin;
  
      if (!anyMarked) 
      {
***************
*** 477,493 ****
       * Now go through the children of the root and figure their new
       * borderClips from the totalClip, passing that off to miComputeClips
       * to handle recursively. Once that's done, we remove the child
       * from the totalClip to clip any siblings below it.
       */
      for (pWin = pChild; pWin != NullWindow; pWin = pWin->nextSib) 
      {
  	if (pWin->viewable) 
          {
  	    if (pWin->marked) 
              {
! 		(* pScreen->Intersect) (childClip, totalClip, pWin->borderSize);
  		miComputeClips (pWin, pScreen, childClip);
  		(* pScreen->Subtract) (totalClip, totalClip, pWin->borderSize);
  	    }
  	    else if (pWin->visibility == VisibilityNotViewable)
  	    {
--- 486,521 ----
       * Now go through the children of the root and figure their new
       * borderClips from the totalClip, passing that off to miComputeClips
       * to handle recursively. Once that's done, we remove the child
       * from the totalClip to clip any siblings below it.
       */
+ #ifdef sgi
+     if (SGIWindowManager() && pParent->parent == NullWindow) {
+ 	rootClip = (* pScreen->RegionCreate) (NULL, 1);
+ 	(* pScreen->RegionCopy) (rootClip, pParent->borderSize);
+     } else
+ 	rootClip = NullRegion;
+     /*
+     ** Here at SGI we don't clip top level windows against each other if we are
+     ** running with a window manager becuase each top-level window is
+     ** automatically clipped by the hardware.  Thus when we calculate the
+     ** universe to pass to miComputeClips, we simply intersect our window size
+     ** with the root window size.
+     */
+ #endif
      for (pWin = pChild; pWin != NullWindow; pWin = pWin->nextSib) 
      {
  	if (pWin->viewable) 
          {
  	    if (pWin->marked) 
              {
! #ifdef sgi
! 		if (rootClip)
! 		    (* pScreen->Intersect) (childClip, rootClip, pWin->borderSize);
! 		else
! #endif
! 		    (* pScreen->Intersect) (childClip, totalClip, pWin->borderSize);
  		miComputeClips (pWin, pScreen, childClip);
  		(* pScreen->Subtract) (totalClip, totalClip, pWin->borderSize);
  	    }
  	    else if (pWin->visibility == VisibilityNotViewable)
  	    {
