#define N_ELEMENTS(array) (sizeof array / sizeof array[0])

#define KB_SGI4D	1
#define	MIN_KEYCODE	8	/* Don't use mouse button numbers */

#define SGI_CURSOR	10
#define SGI_OBJ		12345

#if defined(GL4D) || defined(GL4D2) || defined(GL4D3)
# define X4D
# define SGI_WIDTH	1280
# define SGI_HEIGHT	1024
# ifndef GL4D
# define RECTREAD
# endif
#endif

#ifdef GL2
# define SGI_WIDTH	1024
# define SGI_HEIGHT	768
#endif

#define BLT_SRC 0
#define BLT_DST 1

typedef unsigned short GLPixel;

/*
** Used by functions which handle re-draws and create windows to see if the
** windows look like what we expect them to when we get back from GL land.
*/

#define	NO_CHANGE		0x00
#define CHANGED_POSITION	0x01
#define CHANGED_SIZE		0x02

#define sgi_wm (root_winid == 0)

extern int winChanged, newX, newY, newW, newH, root_winid;

#define SGI_Y(Y_from_X11) (SGI_HEIGHT - 1 - (Y_from_X11))
#define SGI_YRANGE(yMin, yMax) SGI_Y(yMax), SGI_Y(yMin)

#ifdef VOIDBUGFIXED /* HELLOMICHAEL */
typedef void *XWinPointer;
#else
typedef char *XWinPointer;
#endif

typedef struct SGIWinSize {
    int	xorg, yorg;
    int	width, height;
    XWinPointer	pXWin;
    int	aspectx, aspecty,
	stepx, stepy,
	maxx, maxy,
	minx, miny;
    int	has_aspect:1, has_stepunit:1, has_preforigin:1,
	has_maxsize:1, has_minsize:1, is_popup:1, override:1;
} SGIWinSize;

extern struct MsPrivate {
    int fd;
    int x, y;
    int buttons;
} MsPrivate;

extern struct KbPrivate {
    int type;
    int fd;
    int offset;
    int bellVolume;
} KbPrivate;


/*-
 * TVTOMILLI(tv)
 *	Given a struct timeval, convert its time into milliseconds...
 */
#define TVTOMILLI(tv)	(((tv).tv_usec/1000)+((tv).tv_sec*1000))

#define BLACKPIXEL	1
#define WHITEPIXEL	0

/* sgiblthelper functions */
extern void sgiStartBlt();
extern int* sgiBltAddr(int,int,int,int);
extern int* sgiNextLine(int, int*, int);
extern int* sgiReadSpan(int, int, int, int);
extern void sgiStartBlt();

/* sgidraw functions */
extern void sgiPolylines();
extern void sgiPolyFillRect();
extern void sgiImageGlyphBlt();
extern void sgiPolyGlyphBlt();
