/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include	<gl.h>
#include	<gl/device.h>
#include	"sgifb.h"
#include	"sgigl.h"
#include	<gl/bitmap.h>

GLPixel		glscanline[SGI_WIDTH];	/* Buffer of GL sized pixels */
int		cWin = -1,		/* Last window winset'ed to */
		doScrMask,		/* DEBUG: Visually indicate scrmask */
		winChanged,		/* If a window moves or changes size */
		noportwin,
		haveCursor,		/* True if we have the cursor */
		cursorNo,		/* Cursor number we want to have */
		newX, newY,		/* It's new top,left */
		newW, newH;		/* and width height */
SGIWinSize	*winSizes;		/* Array of all top level X windows */
Colorindex	glcursor[6],		/* color cursor was before it came */
		cbgRed,cbgGreen,cbgBlue,/* Cursor background colors */
		cfgRed,cfgGreen,cfgBlue;/* Cursor foreground colors */

extern char *WM_WinName(), *WM_IconName();

#define GUESSWIN 0x100	/* Guesstimate number of windows */

void
GLgetpixels(buf, x, y, w)
    int x, y, w;
    char *buf;
{
    cmov2i(x, y);
    readpixels(w, glscanline);
    gl_to_x(glscanline, buf, w);
}

void
GLputpixels(buf, x, y, w)
    int x, y, w;
    char *buf;
{
    cmov2i(x, y);
    x_to_gl(buf, glscanline, w);
    writepixels(w, glscanline);
    {
	GLPixel		comp[SGI_WIDTH];	/* Buffer of GL sized pixels */
	int		i;

	cmov2i(x,y);
	readpixels(w, comp);
	for (i = 0; i < w; i++)
	    if (glscanline[i] != comp[i])
		GLdebug();
    }
}

x_to_gl(xp, glp, w)
    register unsigned char *xp;
    register unsigned short *glp;
    register int w;
{
    while (w-- > 0) {
	*glp++ = *xp++;
    }
}

gl_to_x(glp, xp, w)
    register unsigned short *glp;
    register unsigned char *xp;
    register int w;
{
    while (w-- > 0)
	*xp++ = *glp++;
}

int curColor;
void
GLcolor(c)
{
    color(curColor = c);
}

#ifdef GLDEBUG
struct gldebug {
    int backface;
    int buffer;
    int cmmode;
    int color;
    short cposx;
    short cposy;
    Boolean depthcuemode;
    int displaymode;
    int drawmode;
    Matrix matrix;
    int monitor;
    int pattern;
    int planes;
    short scrmaskleft;
    short scrmaskright;
    short scrmaskbottom;
    short scrmasktop;
    int shademodel;
    short viewleft;
    short viewright;
    short viewbottom;
    short viewtop;
    int writemask;
    int zbuffer;
};

GLdebug()
{
    struct gldebug g;

    g.zbuffer = getzbuffer();
    g.writemask = getwritemask();
    getviewport(&g.viewleft, &g.viewright, &g.viewbottom, &g.viewtop);
    g.shademodel = getsm();
    getscrmask(&g.scrmaskleft,&g.scrmaskright,&g.scrmaskbottom,&g.scrmasktop);
    g.planes = getplanes();
    g.pattern = getpattern();
    g.monitor = getmonitor();
    getmatrix(g.matrix);
    g.drawmode = getdrawmode();
    g.displaymode = getdisplaymode();
    g.depthcuemode = getdcm();
    getcpos(&g.cposx, &g.cposy);
    g.color = getcolor();
    g.cmmode = getcmmode();
    g.buffer = getbuffer();
    g.backface = getbackface();
}
#endif

void
GLrectfill(x, y, w, h)
{
    if (h == 1) {
	GLmoveto(x, y);
	GLlineto(x + w - 1, y);
    } else if (w == 1) {
	GLmoveto(x, y);
	GLlineto(x, y + h - 1);
    } else
	rectfi(x, y, x + w - 1, y + h - 1);
}

void
GLrectcopy(x, y, w, h, nx, ny)
{
    y = SGI_Y(y + h - 1);
    ny = SGI_Y(ny + h - 1);
    if (sgi_wm) {
	x -= winSizes[cWin].xorg;
	y -= winSizes[cWin].yorg;
	nx -= winSizes[cWin].xorg;
	ny -= winSizes[cWin].yorg;
    }
    rectcopy (x, y, x+w-1, y+h-1, nx, ny);
}

void
GLsetcursor(cn, z1, z2)
{
    cursorNo = cn;
    if (haveCursor)
	setcursor(cn, 0, 0);
}

void
GLcursordraw()
{
    drawmode(CURSORDRAW);
}

void
GLnormaldraw()
{
    drawmode(NORMALDRAW);
}

void
GLcursorcolors(bgRed, bgGreen, bgBlue, fgRed, fgGreen, fgBlue)
{
    if (haveCursor) {
	GLcursordraw();
	mapcolor(2, bgRed, bgGreen, bgBlue);
	mapcolor(3, fgRed, fgGreen, fgBlue);
	GLnormaldraw();
    }
    cbgRed = bgRed; cbgGreen = bgGreen; cbgBlue = bgBlue;
    cfgRed = fgRed; cfgGreen = fgGreen; cfgBlue = fgBlue;
}

GLhavecursor(haveIt)
{
    if (haveCursor = haveIt) {
	GLcursordraw();
	getmcolor(2, glcursor, glcursor+1, glcursor+2);
	getmcolor(3, glcursor+3, glcursor+4, glcursor+5);
	setcursor(cursorNo, 0, 0);
	mapcolor(2, cbgRed, cbgGreen, cbgBlue);
	mapcolor(3, cfgRed, cfgGreen, cfgBlue);
	GLnormaldraw();
    } else {
	GLcursordraw();
	mapcolor(2, glcursor[0], glcursor[1], glcursor[2]);
	mapcolor(3, glcursor[3], glcursor[4], glcursor[5]);
	GLnormaldraw();
    }
}

void
GLcurstype(n)
{
    switch (n) {
	case 16: curstype(C16X2); break;
	case 32: curstype(C32X2); break;
    }
}


short masks[16] = {
    0x5555, 0x2222, 0x5555, 0x8888, 0x5555, 0x2222, 0x5555, 0x8888,
    0x5555, 0x2222, 0x5555, 0x8888, 0x5555, 0x2222, 0x5555, 0x8888
};

void
GLginit()
{
    foreground();
    noport();
    noportwin = winopen("NeWS BUG!!");
    /*
    ** This clears the noport out of the contraints structures
    */
    winconstraints();
    winconstraints();
    defpattern(1, 16, masks);
}

void
GLrootopen()
{
    prefposition(0, SGI_WIDTH-1, 0, SGI_HEIGHT-1);
    noborder();
    cWin = root_winid = winopen("xroot");
    ortho2(-0.5, SGI_WIDTH-0.5, SGI_HEIGHT-0.5, -0.5);
    GLqueue_devices();
}

GLwinopen(pWin)
XWinPointer pWin;
{
    SGIWinSize tmp;
    register int wid;
    int realW, realH;
    static int firstWindow = 0;
    char *icon_title;
    char *win_title;

    /*
    ** Get the hints from the window properties
    */
    WM_WindowHints(pWin, &tmp);
    icon_title = WM_IconName(pWin);
    win_title = WM_WinName(pWin);
    /*
    ** Handle windows with missing titles
    */
    if (win_title) {
	if (!icon_title)
	    icon_title = win_title;
    } else if (icon_title)
	win_title = icon_title;
    else {
	win_title = "X11 Client";
	icon_title = "x11";
    }
    /*
    ** Set up initial appearance of window
    */
    if (tmp.is_popup || tmp.override) {
	noborder();
	prefposition(tmp.xorg, tmp.xorg+tmp.width-1,
		     tmp.yorg, tmp.yorg+tmp.height-1);
    } else
	prefsize(tmp.width, tmp.height);
    wid = winopen(icon_title);
    wintitle(win_title);
    /*
    ** Now give the window the proper set of constraints
    */
    if (tmp.is_popup || tmp.override)
	noborder();	/* This is so the frame controls don't appear */
    winconstraints();
    if (tmp.is_popup || tmp.override) {
	noborder();
	prefposition(tmp.xorg, tmp.xorg+tmp.width-1,
		     tmp.yorg, tmp.yorg+tmp.height-1);
    }
    if (tmp.has_aspect)
	keepaspect(tmp.aspectx, tmp.aspecty);
    if (tmp.has_stepunit) {
	fudge(tmp.width % tmp.stepx, tmp.height % tmp.stepy);
	stepunit(tmp.stepx, tmp.stepy);
    }
    if (tmp.has_minsize)
	minsize(tmp.minx, tmp.miny);
    if (tmp.has_maxsize)
	minsize(tmp.maxx, tmp.maxy);
    winconstraints();
    /*
    ** Do first window initialization
    */
    if (firstWindow == 0) {
	GLqueue_devices();
	shademodel(FLAT);
	firstWindow = wid;
	winSizes = (SGIWinSize *) Xalloc(GUESSWIN * sizeof (SGIWinSize));
    }
    if (wid >= GUESSWIN)
	FatalError("window table exceeded in winopen\n");
    /*
    ** Get viewport/ortho right and return
    */
    winSizes[wid] = tmp;
    GLshapewindow(wid);
    return wid;
}

GLshapewindow(wid)
{
    int xpos, ypos, xsize, ysize, border;

    winChanged = NO_CHANGE;
    GLwinset(wid);
    reshapeviewport();
    if (wid == noportwin)
	return;
    getsize(&xsize, &ysize);
    getorigin(&xpos, &ypos);
    ortho2(xpos-0.5, (xpos+xsize)-0.5, SGI_Y(ypos)+0.5, SGI_Y(ypos+ysize)+0.5);
    if (winSizes[wid].width != xsize || winSizes[wid].height != ysize) {
	winSizes[wid].width = xsize;
	winSizes[wid].height = ysize;
	winChanged |= CHANGED_SIZE;
    }
    if (winSizes[wid].xorg != xpos || winSizes[wid].yorg != ypos) {
	winSizes[wid].xorg = xpos;
	winSizes[wid].yorg = ypos;
	winChanged |= CHANGED_POSITION;
    }
    border = _WinBorder(winSizes[wid].pXWin);
    newX = winSizes[wid].xorg;
    newY = SGI_Y(ypos)-ysize+1;
    newW = winSizes[wid].width - 2 * border;
    newH = winSizes[wid].height - 2 * border;
}

XWinPointer _WinPtr(wid) { return winSizes[wid].pXWin; }

void
GLreshapeviewport()
{
    reshapeviewport();
}

GLadjustMouseX(hwX)
{
    return hwX;
}

GLadjustMouseY(hwY)
{
    return SGI_Y(hwY);
}

GLqueue_devices()
{
    static int queued = 0;

    if (queued)
	return;
    queued = 1;
    qdevice(WINFREEZE);
    qdevice(WINTHAW);
    qdevice(WINQUIT);
    qdevice(DEPTHCHANGE);
    qdevice(MOUSEX);
    qdevice(MOUSEY);
    qdevice(LEFTMOUSE);
    qdevice(MIDDLEMOUSE);
    qdevice(RIGHTMOUSE);
    qdevice(RAWKEYBD);
}

void
GLmoveto(x, y)
{
    move2i(x, y);
}

void
GLpoint(x, y)
{
    pnt2i(x,y);
}

void
GLlineto(x, y)
{
    draw2i(x,y);
}

void
GLmakeobj()
{
    makeobj(SGI_OBJ);
}

void
GLcloseobj()
{
    closeobj();
}

void
GLcallobj()
{
    callobj(SGI_OBJ);
}

void
GLscrmask(x, y, w, h)
{
    y = SGI_Y(y + h - 1);	/* Get coordinate of bottom left corner */
    if (sgi_wm) {
	x -= winSizes[cWin].xorg;
	y -= winSizes[cWin].yorg;
    }
    cached_scrmask(x, x + w - 1, y, y + h - 1);
}

GLfixscrmask()
{
    if (sgi_wm)
	cached_scrmask(0, winSizes[cWin].width-1, 0, winSizes[cWin].height-1);
    else
	cached_scrmask(0, SGI_WIDTH-1, 0, SGI_HEIGHT-1);
}

cached_scrmask(left, right, bottom, top)
{
    static int cached = 0;
    static Screencoord cl, cr, cb, ct;

    if (cached && (cl == left && cr == right && cb == bottom && ct == top))
	return;
    cached=1;
    scrmask(cl = left, cr = right, cb = bottom, ct = top);
}

void
GLwritemask(n)
    long	n;
{ writemask(n);
}

void
GLwinset(winID)
{
    if (cWin != winID) {
	winset(winID);
	cWin = winID;
    }
}

void
GLwinclose(winID)
{
    winclose(winID);
    if (winID == cWin)
	cWin = -1;
}

void
GLstartbitmap()
{
    gl_beginstring();
}

void
GLdrawbitmap(pbm)
    Bitmap *pbm;
{
    gl_drawbitmap(pbm);
}

void
GLfinishbitmap()
{
    gl_endstring();
}

#ifdef RECTREAD
void
GLrectread(x, y, w, h, pbits)
    int x, y, w, h;
    char *pbits;
{
    y = SGI_Y(y + h - 1);	/* Get coordinate of bottom left corner */
    if (sgi_wm) {
	x -= winSizes[cWin].xorg;
	y -= winSizes[cWin].yorg;
    }
    rectread(x, y, x+w-1, y+h-1, pbits);
}

void
GLrectwrite(x, y, w, h, pbits)
    int x, y, w, h;
    char *pbits;
{
    y = SGI_Y(y + h - 1);	/* Get coordinate of bottom left corner */
    if (sgi_wm) {
	x -= winSizes[cWin].xorg;
	y -= winSizes[cWin].yorg;
    }
    rectwrite(x, y, x+w-1, y+h-1, pbits);
}
#endif
