/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include	"X.h"
#include	"Xos.h"
#define NEED_EVENTS	/* Tell XProto I want event structures */
#include	"Xproto.h"
#include	"input.h"
#include	"windowstr.h"
#include	"sgifb.h"
#include	<gl/device.h>

static unsigned long sgiLastEventTime;
int debug_menu;

void
ProcessInputEvents()
{
    register short dev;
    short val, moved = 0;
    DevicePtr pMouse, pKeybd;
    struct MsPrivate *pMP;
    xEvent x;

    pMouse = LookupPointerDevice();
    pKeybd = LookupKeyboardDevice();
    pMP = (struct MsPrivate *)pMouse->devicePrivate;
    while (qtest()) {
	SetTimeSinceLastInputEvent();
	dev = qread(&val);
	if (ISKEYBD(dev)) {
	    extern int doScrMask;

	    if (dev == ENDKEY)
		doScrMask = val;
	    AssignEventPoint(&x, pMP);
	    x.u.keyButtonPointer.time = sgiLastEventTime;
	    x.u.keyButtonPointer.rootY = pMP->y;
	    x.u.u.detail = dev + KbPrivate.offset;
	    x.u.u.type = val ? KeyPress : KeyRelease;
	    (*pKeybd->processInputProc)(&x, pKeybd);
	    continue;
	}
	switch (dev) {

	    case RIGHTMOUSE:
		if (getbutton(PRINTSCREENKEY) == 1) {
		    switch (dopup(debug_menu)) {
			case 1: winpop(); break;
			case 2: winpush(); break;
			case 3: exit(0); break;
		    }
		    break;
		}
	    case LEFTMOUSE:
	    case MIDDLEMOUSE:
		qSendButtonEvent(pMouse, dev, val, pMP);
		break;

	    case MOUSEX:
		pMP->x = GLadjustMouseX(val);
		moved++;
		break;

	    case MOUSEY:
		pMP->y = GLadjustMouseY(val);
		moved++;
		break;
		
	    case REDRAW:
		if (sgi_wm) {
		    GLshapewindow(val);
		    RedrawGLWindow(val);
		} else {
		    extern WindowRec	WindowTable[];
		    extern int NakedWindow();

		    TraverseTree(&WindowTable[0], NakedWindow, 0);
		    HandleExposures(&WindowTable[0]);
		}
		break;

	    case INPUTCHANGE:
		/*
		** If I am getting the input focus, paint the cursor the
		** "proper" color.
		*/
		if (val)
		    GLhavecursor(TRUE);
		else
		    GLhavecursor(FALSE);
		break;
	    case DEPTHCHANGE:
		if (sgi_wm)
		    RestackGLWindows();
		break;
	    case WINQUIT:
		KillGLWindow(val);
		break;
	}
    }
    if (moved) {
	AssignEventPoint(&x, pMP);
	x.u.keyButtonPointer.time = sgiLastEventTime;
	x.u.u.detail = 0;
	x.u.u.type = MotionNotify;
	(*pMouse->processInputProc)(&x, pMouse);
    }
}

qSendButtonEvent(pMouse, but, val, pMP)
    register int but, val;
    DevicePtr pMouse;
    struct MsPrivate *pMP;
{
    xEvent x;

    AssignEventPoint(&x, pMP);
    x.u.keyButtonPointer.time = sgiLastEventTime;
    x.u.u.type = val ? ButtonPress : ButtonRelease;
    /*
    ** Encode the buttons like the sun:
    ** 1 == left 2 == middle, 3 -- right
    ** from:
    ** 101 == right 102 == middle 103 == left
    */
    x.u.u.detail =  3 - (but - RIGHTMOUSE);
    (*pMouse->processInputProc)(&x, pMouse);
}

SetTimeSinceLastInputEvent()
{
    struct timeval now;

    gettimeofday(&now, (struct timezone *)0);
    sgiLastEventTime = TVTOMILLI(now);
}

/*-
 *-----------------------------------------------------------------------
 * TimeSinceLastInputEvent --
 *	Function used for screensaver purposes by the os module.
 *
 * Results:
 *	The time in milliseconds since there last was any
 *	input.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
int
TimeSinceLastInputEvent()
{
    struct timeval	now;

    gettimeofday (&now, (struct timezone *)0);

    if (sgiLastEventTime == 0) {
	sgiLastEventTime = TVTOMILLI(now);
    }
    return TVTOMILLI(now) - sgiLastEventTime;
}

AssignEventPoint(ep, pMP)
    xEvent *ep;
    struct MsPrivate *pMP;
{
    ep->u.keyButtonPointer.rootX = pMP->x;
    ep->u.keyButtonPointer.rootY = pMP->y;
    ep->u.keyButtonPointer.eventX = pMP->x;
    ep->u.keyButtonPointer.eventY = pMP->y;
}

/*
 * DDX - specific abort routine.  Called by AbortServer().
 */
void
AbortDDX()
{
}

/* Called by GiveUp(). */
void
ddxGiveUp()
{
}

int
ddxProcessArgument (argc, argv, i)
    int	argc;
    char *argv[];
    int	i;
{
    return 0;
}

void
ddxUseMsg()
{
}
