/****************************************************************************/
/* events.c  -- HIGH-LEVEL events HANDLING */
/****************************************************************************/
#include "events.h"
/****************************************************************************/
/****************************************************************************/
#define	NEED_EVENTS	/* INCLUDE ONLY EVENT STRUCTURES OF Xproto.h */
#include "Xproto.h"	/* GET xEvent TYPEDEF */

#include "X.h"		/* GET KEYCODE typedef FOR input.h */
#include "input.h"	/* GET DevicePtr TYPEDEF */

#include "inpevent.h"
#include "timetick.h"	/* DATE EVENTS when they are processed, RATHER THAN
		WHEN THEY OCCURED, IN ORDER TO SAVE THE ADDITIONAL STORAGE
		OF A TIMESTAMP FOR EACH EVENT */
#include "assert.h"
/****************************************************************************/
COORD	lastcoord=	{0,0};	/* COORDINANT OF MOUSE SINCE LAST MOVEMENT
	-- DO NOT POLL THE MOUSE EVERY TIME AN EVENT IS PROCESSED,
	JUST REMEMEBER ITS LAST POSITON */
/****************************************************************************/
/****************************************************************************/
#include "queue.h"
/* QUEUE ALL INPUT EVENTS */
QUEUEID	queue;

/* NOTE:  THIS queue IS SHARED BY key.c AND mouse.c.  IT IS THROUGH THIS
QUEUE THAT INPUT EVENTS ARE PIPED TO ProcessInputEvents() */
/****************************************************************************/
/***************************************************************************/
/* Def. of Porting Layer: Input Initialization (5.1.5) */
/****************************************************************************/
extern	DevicePtr
	AddInputDevice(CARD32 deviceID, DeviceProc deviceProc, Bool autoStart);
extern	void	RegisterPointerDevice(DevicePtr device, int numMotionEvents);
extern	void	RegisterKeyboardDevice(DevicePtr device);

#include "key.h"
#include "ptr_inp.h"
void	InitInput(int argc, char *argv[]) {
	queue= queue_create(sizeof(INPEVENT),1000);
	assert(queue);
	SetInputCheck(queue->tail,queue->head);

	RegisterKeyboardDevice(	AddInputDevice(1,key_deviceproc,TRUE));
	RegisterPointerDevice(	AddInputDevice(2,ptr_inp_deviceproc,TRUE),0);
        /* NOTE: NO BUFFERED MOTION EVENTS SUPPORTED */
}
/****************************************************************************/
/****************************************************************************/
/* Def. Porting Layer: Processing Events (5.1.2) */
/****************************************************************************/
void	ProcessInputEvents(void)
{
	INPEVENT	inpevent;
	DevicePtr	curkeyboard=	LookupKeyboardDevice();
	DevicePtr	curmouse=	LookupPointerDevice();
	
	while (queue_sub(queue,&inpevent)) {
		xEvent	xevent;
		DevicePtr device=		curmouse;

		/* DECIDE IF IT'S A KEYBOARD EVENT OR A MOUSE EVENT,
		AND STORE ANYTHING IMPORTANT IN xevent */
		switch(inpevent.type) {
			case(KeyPress):
			case(KeyRelease):
				device=		curkeyboard;
			case(ButtonPress):
			case(ButtonRelease):
				xevent.u.u.detail=
						inpevent.input.xkeycode;
				break;
			case(MotionNotify):
				lastcoord=	inpevent.input.coord;
				break;
			default:
				/* "Event for Undefined Device in ProcessInputEvents()!" */
				assert(0);
		}
		/* xEvent FIELDS REQUIRED FOR EVERY EVENT */
		xevent.u.u.type=			inpevent.type;
		xevent.u.keyButtonPointer.time=		timetick();
		xevent.u.keyButtonPointer.rootX=	lastcoord.x;
		xevent.u.keyButtonPointer.rootY=	lastcoord.y;

                /* TELL  DIX TO PROCESS THE EVENT */
		(*device->processInputProc)(&xevent,device);
	}
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/

