/****************************************************************************/
/* ptr_out.h -- X-WINDOW CURSOR ROUTINES FOR IBM PC FAMILY		    */
/****************************************************************************/
#ifndef	_ptr_out_h
#define	_ptr_out_h
/****************************************************************************/
#include "cursorstr.h"
#include "misc.h"	/* FOR Bool TYPEDEF */
#include "miscstruct.h"
#include "scrnintstr.h"
/****************************************************************************/
/* see section 5.2.5 of Def. of Porting Layer for more details */
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
Bool	RealizeCursor(ScreenPtr pScr, CursorPtr pCurs);
/****************************************************************************/
Bool	UnrealizeCursor(ScreenPtr pScr, CursorPtr pCurs);
/****************************************************************************/
Bool	DisplayCursor(ScreenPtr pScr, CursorPtr pCurs);
/****************************************************************************/
void	RecolorCursor(ScreenPtr pScr, CursorPtr pCurs);
/****************************************************************************/
void	ConstrainCursor(ScreenPtr pScr, BoxPtr pBox);
	/* CONSTRAINS THE CURSOR TO A PARTICULAR BOX ON THE SCREEN */
/****************************************************************************/
void	PointerNonInterestBox(ScreenPtr pScr, BoxPtr pBox);
	/* TURN OFF MOTION EVENTS FOR A PARTICULAR BOX -- NOT SUPPORTED */
/****************************************************************************/
void	CursorLimits(ScreenPtr pScr, CursorPtr pCurs, BoxPtr pHotBox, BoxPtr pTopLeftBox);
	/* FOR NOW, THE CURSOR HOTSPOT HAS NO LIMTS.  RETURN THE SCREEN "BOX" */
/****************************************************************************/
Bool	SetCursorPosition(ScreenPtr pScr, unsigned int newx, unsigned int newy);
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#endif