/****************************************************************************/
/* queue.c	- queue DATA ABSTRACTION				    */
/*		Michael B. Parker			14 July 1987 	    */
/****************************************************************************/
#include "queue.h"
/****************************************************************************/
/****************************************************************************/
QUEUEID	queue_create(unsigned elmts, unsigned elmtsize) {
	unsigned	buffsize=	(elmts+1)*elmtsize;
	QUEUEID	queue=	(QUEUEID)malloc(buffsize+sizeof(QUEUE));
	if (queue) {
		queue->head=	queue->tail=	&(queue->bot);
		queue->top=	&(queue->bot)+ buffsize;
		queue->elmtsize=	elmtsize;
	}
	return(queue);
}
/****************************************************************************/
/****************************************************************************/
#define	queue_wrapinc(queue,ptr) (			\
	( ((ptr)+= (queue)->elmtsize) >= ((queue)->top) )	\
	?((ptr)= (queue)->bot)				\
	:(ptr)                                         	\
	)
/****************************************************************************/
BOOL	queue_full(QUEUEID queue) {
	char *tmp=	queue->head;
	return((BOOL)(queue_wrapinc(queue,tmp)==(queue->tail)));
}
/****************************************************************************/
BOOL	queue_add(QUEUEID queue, void *elmt) {
	if (!queue_full(queue)) {
		memcpy(queue->head,elmt,queue->elmtsize);
		queue_wrapinc(queue,queue->head);
		return(BOOL_TRUE);
	}
	return(BOOL_FALSE);
}
/****************************************************************************/
BOOL	queue_sub(QUEUEID queue, void *elmt) {
	if (!queue_empty(queue)) {
		memcpy(elmt,queue->tail,queue->elmtsize);
		queue_wrapinc(queue,queue->tail);
		return(BOOL_TRUE);
	}
	return(BOOL_FALSE);
}
/****************************************************************************/
/****************************************************************************/
#define	queue_sdif(queue)	((queue)->top - (queue)->bot)
#define	queue_ddif(queue)	((queue)->head - (queue)->tail)
/****************************************************************************/
unsigned	queue_elmtsfull(QUEUEID queue) {
	int ddif=	queue_ddif(queue);
	if (ddif<0)	ddif+=	queue_sdif(queue);
	return(ddif/queue_elmtsize(queue));
}
/****************************************************************************/
unsigned	queue_elmtsempty(QUEUEID queue) {
	int ddif=	-queue_ddif(queue);
	if (ddif<=0)	ddif+=	queue_sdif(queue);
	return(ddif/queue_elmtsize(queue)-1);
}
/****************************************************************************/
void	queue_printstatus(QUEUEID queue) {
	printf("\n\nqueue_printstatus(QUEUEID %p): Queue Status Functions...",queue);
	printf("\n\tqueue_elmts(): %d",queue_elmts(queue));
	printf("\n\tqueue_elmtsize(): %d",queue_elmtsize(queue));
	printf("\n\tqueue_empty(): %d",(int)queue_empty(queue));
	printf("\n\tqueue_elmtsempty(): %d",queue_elmtsempty(queue));
	printf("\n\tqueue_full(): %d",(int)queue_full(queue));
	printf("\n\tqueue_elmtsfull(): %d",queue_elmtsfull(queue));
}
/****************************************************************************/
void	queue_printelmts(QUEUEID queue) {
	unsigned elmtsize=	queue_elmtsize(queue);
	printf("\n\nqueue_printelmts(QUEUEID %p): Print all elements of the queue...",queue);
	
	stackalloc(elmt,elmtsize,{
		unsigned	elmts=	queue_elmtsfull(queue);
		while (elmts--) {
			unsigned 	elmtpos;
			queue_sub(queue,&elmt);
			printf("\n\t\t");
			for (elmtpos= 0; elmtpos < elmtsize; ++elmtpos)
				printf("%02x ",(int)(elmt[elmtpos]));
			queue_add(queue,&elmt);
		}
      	});
}			
/****************************************************************************/
void	queue_printall(QUEUEID queue) {
	queue_printstatus(queue);
	queue_printelmts(queue);
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/* INTERNAL PROCEDURES FOR DEBUGGING PURPOSES */
/****************************************************************************/
void	queue_print(QUEUEID queue) {
	char	*dat;
	printf("\n\nqueue_print(QUEUEID %p): Raw Queue Status...");
	printf("\n\tqueue->bot:\t%p,\tqueue->top:\t%p.",queue->bot,queue->top);
	printf("\n\tqueue->tail:\t%p,\tqueue->head:\t%p.",queue->tail,queue->head);
	printf("\n");
	for (dat=queue->bot;dat<(queue->top);++dat)
		printf(" %02x",((int)(*dat)) & 0x00FF);
}
/****************************************************************************/
void	queue_test1(void) {
	QUEUEID	queue;
	printf("\n\nqueue_test1():  Queue create, destroy, & status-function test...");
	printf("\nqueue_create(5,2): %p",queue= queue_create(5,2));
	queue_printall(queue);
	printf("\nqueue_destroy().");
	queue_destroy(queue);
}
/****************************************************************************/
void	queue_add_tst(QUEUEID queue, int var) {
	printf("\n\tvar: %d, queue_add(queue,&var): %d, var: %d",var,(int)queue_add(queue,(char *)&var),var);
	queue_printstatus(queue);
}
/****************************************************************************/
void	queue_sub_tst(QUEUEID queue, int var) {
	printf("\n\tvar: %d, queue_sub(queue,&var): %d, var: %d",var,(int)queue_sub(queue,(char *)&var),var);
	queue_printstatus(queue);
}
/****************************************************************************/
void	queue_test2(void) {
	QUEUEID	queue;
	int	e1=	1;
	int	e2=	2;
	int	e3=	3;
	int	e4=	4;

	printf("\n\nqueue_test2():  Adding and subtracting test...");
	printf("\nqueue_create(5,2): %p",queue= queue_create(5,2));
	queue_printstatus(queue);
	queue_sub_tst(queue,e1);
	queue_add_tst(queue,e1);
	queue_add_tst(queue,e2);
	queue_add_tst(queue,e3);
	queue_add_tst(queue,e4);
	queue_add_tst(queue,e3);
	queue_add_tst(queue,e2);
	queue_add_tst(queue,e1);
	queue_sub_tst(queue,e2);
	queue_sub_tst(queue,e1);
	queue_add_tst(queue,e3);
	queue_sub_tst(queue,e4);
	queue_sub_tst(queue,e3);
	queue_sub_tst(queue,e2);
	queue_sub_tst(queue,e1);
	queue_sub_tst(queue,e2);
	queue_sub_tst(queue,e3);
	printf("\nqueue_destroy().");
	queue_destroy(queue);
}	
/****************************************************************************/
/*
#include <mp\debug.h>
void	main() {
	debug_init();
	queue_test1();
	queue_test2();
}
*/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
	