/****************************************************************************/
/* queue.h	- queue DATA ABSTRACTION				    */
/*		Michael B. Parker			14 July 1987 	    */
/****************************************************************************/
#ifndef	_queue_h
#define	_queue_h
/****************************************************************************/
#include <mp/bool.h>
/****************************************************************************/
/****************************************************************************/
typedef struct {
	char 		*head,*tail;
	unsigned	elmtsize;
	char		*top;
	char		bot[0];
} QUEUE;
typedef	QUEUE	*QUEUEID;
/****************************************************************************/
QUEUEID	queue_create(unsigned elmts, unsigned elmtsize);
/****************************************************************************/
#define	queue_destroy(queue)	(free(queue))
/****************************************************************************/
#define	queue_elmtsize(queue)	((queue)->elmtsize)
/****************************************************************************/
#define	queue_empty(queue)	((queue)->head==(queue)->tail)
/****************************************************************************/
BOOL	queue_full(QUEUEID queue);
/****************************************************************************/
BOOL	queue_add(QUEUEID queue, void *elmt);
/****************************************************************************/
BOOL	queue_sub(QUEUEID queue, void *elmt);
/****************************************************************************/
#define	queue_elmts(queue)	(((queue)->top - (queue)->bot)/(queue_elmtsize(queue))-1)
/****************************************************************************/
unsigned	queue_elmtsfull(QUEUEID queue);
/****************************************************************************/
unsigned	queue_elmtsempty(QUEUEID queue);
/****************************************************************************/
void	queue_printstatus(QUEUEID queue);
/****************************************************************************/
void	queue_printelmts(QUEUEID queue);
/****************************************************************************/
void	queue_printall(QUEUEID queue);
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#endif
	