/*
 * dclock -- program to demonstrate how to use the digital-clock widget.
 * To specify a date, the date format is a string of characters.  If a
 * character in the string is a %-sign, the next character is examined
 * and a value is inserted into the string.  Example:
 *    dclock -date "Today is %W"
 * The date string will print "Today is" and then the %W will be replaced
 * by the current weekday name.  The parameters are:
 *    %W	full weekday name
 *    %w	three-char weekday name (sun, mon, tue, wed...)
 *    %M	full month name
 *    %m        three-char abbreviation for that month (jan, feb, mar...)
 *    %d	The date (numerical number of the month)
 *    %Y	full year (4 digits)
 *    %y	2-digit year number
 *
 * To specify seconds to be displayed, use "-seconds" or use the resource
 * manager: *Dclock.seconds: on
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include "Dclock.h"

static XrmOptionDescRec options[] = {
    {"-date",	 "*Dclock.date",	XrmoptionSepArg, NULL },
    {"-seconds", "*Dclock.seconds",	XrmoptionNoArg, "TRUE" },
    {"-bell",	 "*Dclock.bell",	XrmoptionNoArg, "TRUE" },
    {"-scroll",  "*Dclock.scroll",	XrmoptionNoArg, "TRUE" },
    {"-noscroll","*Dclock.scroll",	XrmoptionNoArg, "FALSE" },
};

static void
Usage(name)
String name;
{
    static char *help_message[] = {
	"where options include:",
	"    -bg color                  background color",
	"    -fg color                  foreground color",
	"    -fn font			font name",
	"    -rv                        reverse video",
	"    -geometry geom             size of mailbox",
	"    -display host:dpy          X server to contact",
	"    -seconds [on/off]		display seconds",
	"    -bell [on/off]		ring bell each half hour",
	"    -scroll [on/off]		turn off scrolling",
	"    -date \"date format\"	show the date in specified format",
	NULL
    };
    char **cpp;

    fprintf(stderr, "usage: %s [-options ...]\n", name);
    for (cpp = help_message; *cpp; cpp++)
	fprintf(stderr, "%s\n", *cpp);
    exit(1);
}

main(argc, argv)
char *argv[];
{
    Widget toplevel;
    char *name, *rindex();

    if (name = rindex(argv[0], '/'))
	name++;
    else
	name = argv[0];

    toplevel = XtInitialize(name, "DClock", options, XtNumber(options),
			    &argc,argv);

    if (argc != 1)
	Usage(name);

    XtCreateManagedWidget("dclock", dclockWidgetClass, toplevel, NULL, 0);

    XtRealizeWidget(toplevel);
    XtMainLoop();
}
