/*
 * xwatch.c -- a front end program to support the Mailwatch widget.
 * This was written by Dan Heller <island!argv@sun.com> --send bugs,
 * comments, flames and other humorous material to me (C.O.D.'s ok)
 */
#include <stdio.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "Mailwatch.h"

static XrmOptionDescRec options[] = {
    {"-update",    "*Mailwatch.update",    XrmoptionSepArg, NULL},
    {"-file",      "*Mailwatch.file",      XrmoptionSepArg, NULL},
    {"-up_flag",   "*Mailwatch.up_flag",   XrmoptionSepArg, NULL},
    {"-down_flag", "*Mailwatch.down_flag", XrmoptionSepArg, NULL},
};

static void
Usage(ProgramName)
String ProgramName;
{
    static char *help_message[] = {
	"where options include:",
	"    -update seconds                how often to check for mail",
	"    -bg color                      background color",
	"    -fg color                      foreground color",
	"    -rv                            reverse video",
	"    -file file                     file to watch for new mail",
	"    -up_flag file		    icon to show for up flag",
	"    -down_flag file		    icon to show for down flag",
	"    -geometry geom                 size of mailbox",
	"    -display host:dpy              X server to contact",
	NULL
    };
    char **cpp;

    fprintf(stderr, "usage: %s [-options ...]\n", ProgramName);
    for (cpp = help_message; *cpp; cpp++)
	fprintf(stderr, "%s\n", *cpp);
    exit(1);
}

Widget w;

/*
 * Callback routine to print new mail when it arrives.
 */
void
print_mail(w, client_data, mail_info)
MailwatchWidget w;
caddr_t client_data; /* unused */
String mail_info;    /* returned by the widget */
{
    (void) fputs(mail_info, stdout);
}

void
main(argc, argv)
int argc;
char *argv[];
{
    Widget toplevel;
    String ProgramName;

    ProgramName = argv[0];

    toplevel = XtInitialize("xwatch", "XWatch", options, XtNumber(options),
	&argc, argv);
    if (argc != 1)
	Usage(ProgramName);

    w = XtCreateManagedWidget("xwatch", mailwatchWidgetClass, toplevel,NULL,0);
    XtAddCallback(w, XtNcallback, print_mail, NULL);

    XtRealizeWidget(toplevel);
    XtMainLoop();
}
