.TH XWATCH 1 "1 March 1988" "X Version 11"
.SH NAME
xwatch - mailbox watch program for X11R2
.SH SYNOPSIS
.B xwatch
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The
.I xwatch
program (by default) displays a little image of a mailbox.  When there
is no mail, the flag on the mailbox is down.  When mail arrives, the flag
goes up, the mailbox beeps, and information about the new mail (author,
time of arrival, and the subject of the message) is printed on the stdout.
This program is nothing more than a wrapper around the Mailwatch widget
not to be confused with the Mailbox widget used by
.I xbiff.
.sp
When the user reads his mail or accesses his mailbox in any way, the
user is in effect acknowledging that he is aware of the new mail and
the flag is returned to the down position.
.sp
.I Xwatch
looks for the left and middle mouse button events.  Upon receipt of a
left button event, xwatch will check for new mail immediately.  If the
user clicks the middle button in the icon, the icon is cleared and all
new mail is considered to have been read by the user and the flag is forced
down.
.sp
.SH OPTIONS
.I Xwatch
accepts all of the standard X Toolkit command line options along with the
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on the standard error.
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which \fIxwatch\fP
should update its display.
.TP 8
.B \-file \fIfilename\fP
This option specifies the name of the file which should be monitored.  By
default, it watches /usr/spool/mail/\fIusername\fP, where \fIusername\fP
is your login name.
.TP 8
.B \-down_flag \fIfilename\fP
.TP 8
.B \-up_flag \fIfilename\fP
These options specify files which contain X11 format bitmap images to be
used instead of the default images.  They need not be the same size and
can even be the same file.  The "flag up" image is always displayed in
reverse video while the "flag down" image is always displayed in normal video.
If the
.I reverse video
option is specified, these will be reversed.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xwatch:
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is ``white.''
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is ``black.''
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for the foreground of the window.
The default is ``black.''
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the mailbox window;
see \fIX(1)\fP.
.TP 8
.B \-display \fIdisplay\fP
This option specifies the X server to contact; see \fIX(1)\fP.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH X DEFAULTS
This program uses the 
.I Mailwatch
widget whose name is "Mailwatch."  Therefore, when setting resources in
your resource database that are Mailwatch-widget specific, set them as in:
.sp
.ti +2
*Mailwatch.down_flag: mail.icon.1
.ti +2
*Mailwatch.up_flag: mail.icon.2
.sp
.I Xwatch
understands all of the core resource names and classes as well as:
.PP
.TP 8
.B file (\fPclass\fB File)
Specifies the name of the file to monitor.  The default is to watch
/usr/spool/mail/\fIusername\fP, where \fIusername\fP is your login name.
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the mailbox.  This defaults to the width
the larger of the two icons (up and down flags) used.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the mailbox.  This defaults to the height of
the larger of the two icons (up and down flags) used.
.TP 8
.B update (\fPclass\fB Interval)
Specifies the frequency in seconds at which the mail should be checked.
The default time is 30 seconds.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the foreground.
The default is ``black'' since the core default for background is ``white.''
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background should be reversed.
.TP 8
.B up_flag (\fPclass\fB File)
.TP 8
.B down_flag (\fPclass\fB File)
Specifies the filename to read for the up flag and the down flag icons
respectively.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1),
xrdb(1),
stat(2)
.SH BUGS
The mailbox bitmaps are ugly, but now you have an option to use better
looking ones if you want.
.sp
In order for
.I Xwatch
to display information about incoming mail, the file from which the
mail is scanned must be in the format which has the string, "From "
separating the sequential messages.  If you use a mail delivery program
which does not store messages in this format (MMDF for example), then
you will get no output about new mail information and
.I xwatch
will be virtually identical to
.I xbiff
except for some general bug fixes.
.SH AUTHOR
Dan Heller <island!argv@sun.com>
