/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:    WClassing.h
 **
 **   Project:     X Widgets
 **
 **   Description: Code/Definitions for widget classing mechanism.
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *************************************<+>*************************************/

/*
 * The defines that will make widget classing work.
 *
 * There are comments to guide the programmer while modifying this
 * code.  These comments should probably be read from the last to the
 * first.
 *
 * Application code size will grow in proportion to the number of
 * widget classes referenced in the following tables.
 */

/*
 * Include the structure definitions
 * and structure load procedure definition.
 */
#include <Xw/WClassingP.h>

/*
 * For each task there must be a static variable and a static pointer
 * to that variable.  This allows an completely unambiguous
 * determination between task pointers and widget class pointers.
 */
static int XwButtonTsp;
static int *XwButtonTask = &XwButtonTsp;

static int XwImageEditTsp;
static int *XwImageEditTask = &XwImageEditTsp;

static int XwLayoutTsp;
static int *XwLayoutTask = &XwLayoutTsp;

static int XwMenuTsp;
static int *XwMenuTask = &XwMenuTsp;

static int XwScrollTsp;
static int *XwScrollTask = &XwScrollTsp;

static int XwTextEditTsp;
static int *XwTextEditTask = &XwTextEditTsp;

static int XwTitleTsp;
static int *XwTitleTask = &XwTitleTsp;

/*
 * View Tables associate strings with widget classes.  These are the 
 * available views for a given class.  The string is the value set in
 * the database.  The widget class is the class of the widget which
 * will be instantiated.  The first entry in each view table is the 
 * default view for that task.
 *
 * The include files are the widget public include files for the 
 * available widgets, so that the class pointers are defined.
 *
 * The initialization is particularly ugly because WidgetClasses are 
 * only available at runtime (after link, because they are extern's).
 * Rather than have the user write their own initialization routine
 * and maintain it, the initialization is done in a table driven
 * fashion.  The maintenance is done by keeping the tables up to date.
 *
 * To add more views to for a task just extend the appropriate table,
 * and make sure that the appropriate file is included.
 */
#include <Xw/PButton.h>
#include <Xw/Toggle.h>
static XwViewTableEntry XwButtonViews[2];
static XwWCViewLoadProc XwLoadButtonViews()
{
	XwLoadViewTable(XwButtonViews,0,
		"XwPushButton",XwpushButtonWidgetClass);
	XwLoadViewTable(XwButtonViews,1,
		"XwToggle",XwtoggleWidgetClass);
}

#include <Xw/ImageEdit.h>
static XwViewTableEntry XwImageEditViews[1];
static XwWCViewLoadProc XwLoadImageEditViews()
{
	XwLoadViewTable(XwImageEditViews,0,
		"XwImageEdit",XwimageEditWidgetClass);
}

#include <Xw/BBoard.h>
#include <Xw/RCManager.h>
#include <Xw/Form.h>
static XwViewTableEntry XwLayoutViews[3];
static XwWCViewLoadProc XwLoadLayoutViews()
{
	XwLoadViewTable(XwLayoutViews,0,
		"XwBulletinBoard", XwbulletinWidgetClass);
	XwLoadViewTable(XwLayoutViews,1,
		"XwRowColumnManager", XwrowColWidgetClass);
	XwLoadViewTable(XwLayoutViews,2,
		"XwForm", XwformWidgetClass);
}

#include <Xw/PopupMgr.h>
static XwViewTableEntry XwMenuViews[1];
static XwWCViewLoadProc XwLoadMenuViews()
{
	XwLoadViewTable(XwMenuViews,0,
		"XwPopUp", XwpopupmgrWidgetClass);
}

#include <Xw/SWindow.h>
static XwViewTableEntry XwScrollViews[1];
static XwWCViewLoadProc XwLoadScrollViews()
{
	XwLoadViewTable(XwScrollViews,0,
		"XwScrolledWindow", XwswindowWidgetClass);
}

#include <Xw/TextEdit.h>
static XwViewTableEntry XwTextEditViews[1];
static XwWCViewLoadProc XwLoadTextEditViews()
{
	XwLoadViewTable(XwTextEditViews,0,
		"XwTextEdit", XwtexteditWidgetClass);
}

#include <Xw/TitleBar.h>
static XwViewTableEntry XwTitleViews[1];
static XwWCViewLoadProc XwLoadTitleViews()
{
	XwLoadViewTable(XwTitleViews,0,
		"XwTitleBar", XwtitlebarWidgetClass);
}

/*
 * The following table is used to load the view structures.
 * All load procs must be in this structure.
 */
XwWCViewLoadProc XwWCViewLoadProcs[] = {
	(XwWCViewLoadProc) XwLoadButtonViews,
	(XwWCViewLoadProc) XwLoadImageEditViews,
	(XwWCViewLoadProc) XwLoadLayoutViews,
	(XwWCViewLoadProc) XwLoadMenuViews,
	(XwWCViewLoadProc) XwLoadScrollViews,
	(XwWCViewLoadProc) XwLoadTextEditViews,
	(XwWCViewLoadProc) XwLoadTitleViews,
};

int XwNumWCViewLoadProcs = XtNumber(XwWCViewLoadProcs);

/*
 * The widget view Table or task table.
 *
 * This table associates task pointers with resource strings, default
 * views (widget classes), and a view table.  It is important that
 * every available task pointer has an entry in this table.  Otherwise,
 * the table search falls through, and the task pointer will be treated
 * as a widget class pointer (results of this error are undefined).
 */
XwTaskTableEntry XwTasks[] = {
	{ &XwButtonTsp, "ButtonTask",
		XwButtonViews, XtNumber(XwButtonViews) },
	{ &XwImageEditTsp, "ImageEditTask",
		XwImageEditViews, XtNumber(XwImageEditViews) },
	{ &XwLayoutTsp, "LayoutTask",
		XwLayoutViews, XtNumber(XwLayoutViews) },
	{ &XwMenuTsp, "MenuTask",
		XwMenuViews, XtNumber(XwMenuViews) },
	{ &XwScrollTsp, "ScrollTask",
		XwScrollViews, XtNumber(XwScrollViews) },
	{ &XwTextEditTsp, "TextEditTask",
		XwTextEditViews, XtNumber(XwTextEditViews) },
	{ &XwTitleTsp, "TitleTask",
		XwTitleViews, XtNumber(XwTitleViews) }
};

int XwNumTasks = XtNumber(XwTasks);

/*
 * This allows us to trap the XtCreateWidget call in the application
 * code and preprocess the class pointer.  In this way we can get
 * complete resource specification.  We also can pass task pointers
 * in and magically turn them into widget class pointer.
 */
extern Widget XwCreateWidget();

#define XtCreateWidget(name,class,parent,args,num)\
		XwCreateWidget(name,class,parent,args,num)

/*
 * This is the trap for XtCreateManagedWidget.
 */
extern Widget XwCreateManagedWidget();

#define XtCreateManagedWidget(name,class,parent,args,num)\
		XwCreateManagedWidget(name,class,parent,args,num)

