/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:    WClassingP.h
 **
 **   Project:     X Widgets
 **
 **   Description: Code/Definitions for widget classing mechanism.
 **
 *****************************************************************************
 **   
 **   Copyright (c) 1988 by Hewlett-Packard Company
 **   Copyright (c) 1988 by the Massachusetts Institute of Technology
 **   
 **   Permission to use, copy, modify, and distribute this software 
 **   and its documentation for any purpose and without fee is hereby 
 **   granted, provided that the above copyright notice appear in all 
 **   copies and that both that copyright notice and this permission 
 **   notice appear in supporting documentation, and that the names of 
 **   Hewlett-Packard or  M.I.T.  not be used in advertising or publicity 
 **   pertaining to distribution of the software without specific, written 
 **   prior permission.
 **   
 *****************************************************************************
 *************************************<+>*************************************/
/*
 * Structures used for widget classing.
 */

/*
 * The view table entry structure.  Used to associate a resource
 * string with a widget class.
 */
typedef struct _XwViewTableEntry {
	String	name;
	WidgetClass	wClass;
} XwViewTableEntry, *XwViewTable;

/*
 * The task table entry structure.  Used to associate a task
 * pointer with a resource class and a view table.
 */
typedef struct _XwTaskTableEntry {
	int	* task;
	String	task_class;
	XwViewTable	views;
	int	num_views;
} XwTaskTableEntry, *XwTaskTable;

typedef void (*XwWCViewLoadProc)();

/*
 * The public procedures for widget Classing.
 */
void XwLoadViewTable();
Widget XwCreateWidget();
