/********************************************************
*							*
*	Test Program for Sbitmap Widget			*
*							*
*	Version 1.0	 4/ 5/88	M.Abe		*
*							*
********************************************************/

/********************************************************
*							*
*	Include definitions				*
*							*
********************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Box.h>
#include <X11/SBitmap.h>

/********************************************************
*							*
*	Global variable					*
*							*
********************************************************/

Widget normal_label;

/********************************************************
*							*
*	Report the syntax error for calling bitmap	*
*							*
********************************************************/

Syntax(call)
char *call;
{
	fprintf(stderr, "%s : Syntax error\n", call);
	exit(1);
}

/********************************************************
*							*
*	Main program starts here			*
*							*
********************************************************/

void main(argc, argv)
unsigned int argc;
char **argv;
{
    Widget toplevel, box;
    Widget big_label;
    Widget reverse_label;
    Widget fat_border_label;
    Widget no_border_label;
    Widget big_font_label;
    Widget left_justify_label;
    Widget right_justify_label;
    Widget bitmap_label;
    Arg args[2];

    int width, height, x_hot, y_hot;
    Pixmap pixmap;
    Arg arg[2];
    XFontStruct fs;
    char tmp[100];

    static char label[20];
    static Arg label_args[1];

	toplevel = XtInitialize(argv[0], "SBitmap",
					NULL, 0, &argc, argv);
	if (argc != 1) Syntax(argv[0]);

	box = XtCreateManagedWidget( "buttonBox", boxWidgetClass,
					toplevel, (ArgList)NULL, 0);


		normal_label = XtCreateManagedWidget("normalLabel",
		    sBitmapWidgetClass, box, (ArgList)NULL, 0);

		strcpy(label, "ABCDEFG");
		label_args[0].name = XtNlabel;
		label_args[0].value = (XtArgVal)label;
		big_label = XtCreateManagedWidget("bigLabel",
			sBitmapWidgetClass, box, (ArgList)label_args,1);

		reverse_label = XtCreateManagedWidget("reverseLabel",
			sBitmapWidgetClass, box, (ArgList)NULL, 0);

		fat_border_label = XtCreateManagedWidget(
			"fatBorderLabel", sBitmapWidgetClass, box,
			(ArgList)NULL, 0);

		no_border_label = XtCreateManagedWidget("noBorderLabel",
			sBitmapWidgetClass, box, (ArgList)NULL, 0);

		big_font_label = XtCreateManagedWidget("bigFontLabel",
			sBitmapWidgetClass, box, (ArgList)NULL, 0);

		left_justify_label = XtCreateManagedWidget(
			"leftJustifyLabel", sBitmapWidgetClass, box,
			(ArgList)NULL, 0);

		right_justify_label = XtCreateManagedWidget(
			"rightJustifyLabel", sBitmapWidgetClass, box,
			(ArgList)NULL, 0);

		bitmap_label = XtCreateManagedWidget("bitmapLabel",
			sBitmapWidgetClass , box, (ArgList)NULL, 0);

	XtRealizeWidget(toplevel);

	args[0].name = XtNx;
	args[0].value = (XtArgVal)0;
	args[1].name = XtNy;
	args[1].value = (XtArgVal)0;
	XtSetValues(normal_label, args, 2);

	XtMainLoop();
}
