/********************************************************
*							*
*	Test Program for Menu Widget			*
*							*
*	Version 0.1	 1/18/88	M.Abe		*
*	Version 0.2	 1/28/88	M.Abe		*
*	Version 0.3	 3/15/88	M.Abe		*
*	Version 0.4	 3/23/88	M.Abe		*
*	Version 0.5	 4/21/88	M.Abe		*
*							*
********************************************************/

/********************************************************
*							*
*	Include definitions				*
*							*
********************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Box.h>
#include <X11/SMenu.h>
#include <X11/SBitmap.h>
#include <X11/SButton.h>

/********************************************************
*							*
*	Report the syntax error for calling button	*
*							*
********************************************************/

Syntax(call)
char *call;
{
	fprintf(stderr, "%s : Syntax error\n", call);
	exit(1);
}

/********************************************************
*							*
*	Global variables				*
*							*
********************************************************/

Widget menu;

/********************************************************
*							*
*	Call back procedure				*
*							*
********************************************************/

void quit_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	Arg arg[2];
	int i;
	WidgetList wlist;

	arg[0].name = XtNselectList;
	arg[0].value = (XtArgVal)NULL;
	arg[1].name = XtNnumSelect;
	arg[1].value = (XtArgVal)NULL;
	XtGetValues(menu, arg, 2);

	wlist = (WidgetList)arg[0].value;
	arg[0].name = XtNlabel;
	for (i = 0; i < arg[1].value; i++) {
		arg[0].value = (XtArgVal)NULL;
		XtGetValues(wlist[i], arg, 1);
		fprintf(stderr, "%s is selected\n", arg[0].value);
	}
	exit();
}

void menu_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	fprintf(stderr, "menu call back %d\n", callData);
}

/********************************************************
*							*
*	Main program starts here			*
*							*
********************************************************/

void main(argc, argv)
unsigned int argc;
char **argv;
{
	Widget toplevel;
	Widget box;
	Widget quit_button;
	int i;

	static XtCallbackRec callback[] = {
		{ quit_proc , NULL },
		{ NULL, NULL },
	};
	static XtCallbackRec menu_callback[] = {
		{ menu_proc , NULL },
		{ NULL, NULL },
	};
	static Arg arg[] = {
		{XtNcallback, (XtArgVal)callback},
	};

	static XtMenuItem items[] = {
	     {(Widget)NULL,"button0",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button1",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button2",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button3",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button4",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button5",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button6",(WidgetClass)NULL,(ArgList)NULL,0},
	     {(Widget)NULL,"button7",(WidgetClass)NULL,(ArgList)NULL,0},
	};
	static Arg menu_arg[] = {
		{XtNcallback, (XtArgVal)menu_callback},
		{XtNitems, (XtArgVal)items},
		{XtNnumItems, (XtArgVal)(XtNumber(items))},
	};

	for (i = 0; i < XtNumber(items); i++)
				items[i].class = sBitmapWidgetClass;

	toplevel = XtInitialize(argv[0], "SMenu", NULL, 0, &argc, argv);
	if (argc != 1) Syntax(argv[0]);

	box = XtCreateManagedWidget("box", boxWidgetClass, toplevel,
						(ArgList)NULL, 0);

	    quit_button = XtCreateManagedWidget("quit",
				sButtonWidgetClass, box,
				(ArgList)arg, XtNumber(arg));

	    menu = XtCreateManagedWidget("menu", sMenuWidgetClass,
			box, (ArgList)menu_arg, XtNumber(menu_arg));

	XtRealizeWidget(toplevel);
	XtMainLoop();
}
