/* xscroll.c : Simple demonstration of Scroll Widget */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/SStringDefs.h>
#include <X11/SScroll.h>
#include <stdio.h>


static XrmOptionDescRec options[] = {
{"-or",		"*scrollOrientation",		XrmoptionSepArg,	NULL},
{"-x",		"*x",				XrmoptionSepArg,	NULL},
{"-y",		"*y",				XrmoptionSepArg,	NULL},
{"-w",		"*width",			XrmoptionSepArg,	NULL},
{"-h",		"*height",			XrmoptionSepArg,	NULL},
{"-bdw",	"*borderWidth",			XrmoptionSepArg,	NULL},
{"-point",	"*scrollPointMode",		XrmoptionNoArg,		"on"},
{"-side",	"*scrollBtnSide",		XrmoptionNoArg,		"on"},
{"-hidethm",	"*scrollHideResThm",		XrmoptionNoArg,		"on"},
{"-ina",	"*inactive",			XrmoptionNoArg,		"on"},
{"-thmfix",	"*scrollThumbFix",		XrmoptionNoArg,		"on"},
{"-rep",	"*intervalTime",		XrmoptionSepArg,	NULL},
{"-btnraw",	"*scrollButtonRaw",		XrmoptionNoArg,		"on"},
{"-barraw",	"*scrollBarRaw",		XrmoptionNoArg,		"on"},
{"-thmraw",	"*scrollThumbRaw",		XrmoptionNoArg,		"on"},
{"-minH",	"*scrollMinH",			XrmoptionSepArg,	NULL},
{"-maxH",	"*scrollMaxH",			XrmoptionSepArg,	NULL},
{"-posH",	"*scrollPositionH",		XrmoptionSepArg,	NULL},
{"-shownH",	"*scrollShownH",		XrmoptionSepArg,	NULL},
{"-smoothH",	"*scrollSmoothH",		XrmoptionSepArg,	NULL},
{"-thmlenH",	"*scrollThumbLenH",		XrmoptionSepArg,	NULL},
{"-btnlenH",	"*scrollButtonLenH",		XrmoptionSepArg,	NULL},
{"-minV",	"*scrollMinV",			XrmoptionSepArg,	NULL},
{"-maxV",	"*scrollMaxV",			XrmoptionSepArg,	NULL},
{"-posV",	"*scrollPositionV",		XrmoptionSepArg,	NULL},
{"-shownV",	"*scrollShownV",		XrmoptionSepArg,	NULL},
{"-smoothV",	"*scrollSmoothV",		XrmoptionSepArg,	NULL},
{"-thmlenV",	"*scrollThumbLenV",		XrmoptionSepArg,	NULL},
{"-btnlenV",	"*scrollButtonLenV",		XrmoptionSepArg,	NULL},
{"-top",	"*hotSpot",			XrmoptionNoArg,	       "top"},
{"-middle",	"*hotSpot",			XrmoptionNoArg,	    "middle"},
{"-last",	"*hotSpot",			XrmoptionNoArg,	      "last"},
};

static void callback();

static int pos = 0;
static Widget scroll;

static XtCallbackRec callbackList[] =
	{ {callback, NULL}, {NULL, NULL} };

static void callback(widget,closure,e)
Widget widget;
caddr_t closure;
SscrollEvent *e;
{
    static int inactive = 0;
    static Arg arg = { XtNinactive, 0 };

    if (pos)
	fprintf(stderr,"[t:%x o:%x h:%d v:%d] ",
	    e->scrollEv_type,e->scrollEv_obj,e->scrollEv_posH,
		e->scrollEv_posV); fflush();
    if (e->scrollEv_obj & ScrollObj_Scroll) {
	inactive = !inactive;
	arg.value = inactive;
	XtSetValues(scroll,&arg,1);
    }
}

/*
 * Report the syntax for calling xscroll
 */
Syntax(call)
char *call;
{
}

void main(argc, argv)
unsigned int argc;
char **argv;
{
    Widget toplevel;
    static    Arg args[8];
    Pixmap pixmap;

    toplevel = XtInitialize(
	argv[0], "SScroll", options, XtNumber(options), &argc, argv);
    if (argc != 1) {
	Syntax(argv[0]);
	pos ++;
    }

    args[0].name = XtNcallback;
    args[0].value = (XtArgVal)(caddr_t)callbackList;

    scroll = XtCreateManagedWidget(argv[0], sScrollWidgetClass, toplevel,
	(ArgList)args, (unsigned int)1);

    XtRealizeWidget(toplevel);
    XtMainLoop();
}
