/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SBitmap.h,v 1.1 88/08/20 09:06:39 michael Exp $ Sony Corporation
 *
 * $Log:	SBitmap.h,v $
 * Revision 1.1  88/08/20  09:06:39  michael
 * Initial revision
 * 
 */
/********************************************************
*							*
*	Public header for Sony bitmap Widget		*
*							*
*	Written by M.Abe				*
*							*
********************************************************/

#ifndef _XtSBitmap_h
#define _XtSBitmap_h

typedef struct {
    Position        x;
    Position        y;
    Dimension       width;
    Dimension       height;
} XtTextExtent;

#define	DefaultBitmapPath	"/usr/sony/lib/X11/bitmaps"

/* resources for label */
#define XtNleftLabel		"leftLabel"
#define XtNlabel		"label"
#define XtNrightLabel		"rightLabel"

/* resources for font */
#define XtNleftFont		"leftFont"
#define XtNfont			"font"
#define XtNrightFont		"rightFont"

#ifdef KANJI
/* resources for kanjiFont */
#define XtNleftKanjiFont	"leftKanjiFont"
#define XtNkanjiFont		"kanjiFont"
#define XtNrightKanjiFont	"rightKanjiFont"
#define XtCKanjiFont		"KanjiFont"
#endif KANJI

/* resources for text entent */
#define	XtNleftTextExt		"leftTextExt"
#define	XtNtextExt		"textExt"
#define	XtNrightTextExt		"rightTextExt"
#define	XtCTextExt		"TextExt"

/* resources for path */
#define	XtNbitmapPath		"bitmapPath"
#define	XtCBitmapPath		"BitmapPath"

#define	XtNbitmapFile		"bitmapFile"
#define XtNhighlightBitmapFile  "highlightBitmapFile"
#define XtNselectedBitmapFile	"selectedBitmapFile"
#define XtNselhighBitmapFile	"selhighBitmapFile"
#define XtNinsensitiveBitmapFile "insensitiveBitmapFile"
#define XtNbackgroundFile	"backgroundFile"
#define	XtCBitmapFile		"BitmapFile"

/* resources for colors */
#define	XtNtransparent		"transparent"
#define	XtCTransparent		"Transparent"
#define XtNforeground		"foreground"
#define XtNhighlightBorder      "highlightBorder"
#define XtNselectedBorder	"selectedBorder"

/* resources for flags and modes */
#ifndef _XtAutoAdjust_e
#define _XtAutoAdjust_e
#define	XtNautoAdjust		"autoAdjust"
#define	XtCAutoAdjust		"AutoAdjust"
#endif _XtAutoAdjust_e

#define	XtNselected		"selected"
#define	XtCSelected		"Selected"

#define	XtNhighlightMode	"highlightMode"
#define	XtNselectMode		"selectMode"
#define	XtCHighlightMode	"HighlightMode"

#ifndef _XtOrientation_e
#define _XtOrientation_e
typedef enum {XtorientHorizontal, XtorientVertical} XtOrientation;
#endif _XtOrientation_e

/* resources for geometry */
#define XtNinternalWidth	"internalWidth"
#define XtNinternalHeight	"internalHeight"

/* resources for cursor */
#ifndef _XtCursor_e
#define _XtCursor_e
#define	XtNcursor		"cursor"
#define XtCCursor		"Cursor"
#endif _XtCursor_e

#ifndef _XtInternal_e
#define _XtInternal_e
typedef enum {
    XtInternalNone,	/* No internal border */
    XtInternalRect,	/* Rectangle internal border */
    XtInternalRRect,	/* Round rectangle internal border */
    XtInternalShadow,	/* Rectangle internal border width shadow */
} XtInternal;
#endif _XtInternal_e
 
#define XtNinterval		"interval"	/* not supported yet */
#define XtCInterval		"Interval"

#define	XtNinternal		"internal"	/* not supported yet */
#define	XtCInternal		"Internal"

extern WidgetClass     sBitmapWidgetClass;

typedef struct _SBitmapClassRec   *SBitmapWidgetClass;
typedef struct _SBitmapRec        *SBitmapWidget;

#endif _XtSBitmap_h
/* DON'T ADD STUFF AFTER THIS */
