#ifndef lint
static char rcsid[] = "$Header: SButton.c,v 1.1 88/08/20 09:06:21 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SButton.c,v $
 * Revision 1.1  88/08/20  09:06:21  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/********************************************************
*							*
*	Sony Button Widget				*
*							*
*	Written by M.Abe				*
*							*
*	Version	1.00	 7/27/88			*
*		First release				*
*							*
********************************************************/

/********************************************************
*							*
*	Include definition				*
*							*
********************************************************/

#include <stdio.h>
#include <ctype.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Misc.h>

#include <X11/SButton.h>
#include <X11/SButtonP.h>

/********************************************************
*							*
*	Private procedure definitions			*
*							*
********************************************************/

static	void	ClassInitialize();
static	void	Initialize();
static	void	Realize();
static	void	Resize();
static	void	Redisplay();
static	Boolean	SetValues();
static	void	Destroy();

static	void	Set();
static	void	Unset();
static	void	Highlight();
static	void	Unhighlight();
static	void	TimerOn();
static	void	TimerOff();
static	void	Notify();

/********************************************************
*							*
*	Full class record constant			*
*							*
********************************************************/

static char defaultTranslations[] =
	"<Btn1Down>: set() \n\
	<Btn1Up>: notify() unset() \n\
	<EnterWindow>: highlight() \n\
	<LeaveWindow>: unhighlight()";

static int zero = 0;
static Boolean true = TRUE;
static Boolean false = FALSE;

static XtResource resources[] = { 
    {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
	XtOffset(SButtonWidget, sbitmap.cursor), XtRString, "opendot"},
    {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	XtOffset(SButtonWidget, sbutton.callbacks), XtRCallback,
	(caddr_t)NULL},
    {XtNintervalTime, XtCIntervalTime, XtRInt, sizeof(int),
	XtOffset(SButtonWidget ,sbutton.interval_time), XtRInt,
	(caddr_t)&zero},
    {XtNflash, XtCFlash, XtRInt, sizeof(int),
	XtOffset(SButtonWidget ,sbutton.flash), XtRInt, (caddr_t)&zero},
};  

static XtActionsRec actionsList[] = {
	{"set",		Set},
	{"unset",	Unset},
	{"highlight",	Highlight},
	{"unhighlight",	Unhighlight},
	{"timeron",	TimerOn},
	{"timeroff",	TimerOff},
	{"notify",	Notify},
};

SButtonClassRec sButtonClassRec = {
  {
    (WidgetClass) &sBitmapClassRec,	/* superclass		*/
    "SButton",				/* class_name		*/
    sizeof(SButtonRec),			/* size			*/
    NULL,				/* class initialize	*/
    NULL,				/* class_part_initialize*/
    FALSE,				/* class_inited		*/
    Initialize,				/* initialize		*/
    NULL,				/* initialize_hook	*/
    XtInheritRealize,			/* realize		*/
    actionsList,			/* actions		*/
    XtNumber(actionsList),		/* num_actions		*/
    resources,                          /* resources	        */
    XtNumber(resources),                /* resource_count	*/
    NULLQUARK,                          /* xrm_class	        */
    FALSE,				/* compress_motion	*/
    TRUE,
    TRUE,
    FALSE,				/* visible_interest	*/
    Destroy,				/* destroy		*/
    XtInheritResize,			/* resize		*/
    Redisplay,				/* expose		*/
    SetValues,				/* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_values_hook	*/
    NULL,				/* accept_focus		*/
    XtVersion,                          /* version		*/
    NULL,                               /* callback_private	*/
    defaultTranslations,                /* tm_table		*/
    NULL,                               /* query_geometry	*/
  },  /* CoreClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* SBitmapClass fields initialization */
  {
    0,                                     /* field not used    */
  },  /* SButtonClass fields initialization */
};

  /* for public consumption */
WidgetClass sButtonWidgetClass = (WidgetClass) &sButtonClassRec;

/********************************************************
*							*
*	Private Procedures				*
*							*
********************************************************/

/********************************************************
*							*
*	Class Initialize				*
*							*
********************************************************/

static void ClassInitialize()
{
} 

/********************************************************
*							*
*	Initialize					*
*							*
********************************************************/

static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal num_args;
{
    SButtonWidget bw =(SButtonWidget)new;
    SButtonWidget req = (SButtonWidget)request;

    bw->sbutton.activated = FALSE;
    bw->sbutton.interval_id = 0;

    (*XtClass(new)->core_class.resize) ((Widget)bw);
} 

/********************************************************
*							*
*	Realize						*
*							*
********************************************************/

static void Realize(w, valueMask, attributes) 
register Widget w;
Mask valueMask;
XSetWindowAttributes *attributes;
{
} 

/********************************************************
*							*
*	Destroy						*
*							*
********************************************************/

static void Destroy(w)
Widget w;
{
	/* must free GCs and pixmaps */
}

/********************************************************
*							*
*	Resize						*
*							*
********************************************************/

static void Resize(w)
Widget	w;
{
}

/********************************************************
*							*
*	Redisplay					*
*							*
*********************************************************/

static void Redisplay(w, event)
Widget w;
XEvent *event;
{
    (*XtSuperclass(w)->core_class.expose) (w, event);
}

/********************************************************
*							*
*	Set Value					*
*							*
*********************************************************/

static Boolean SetValues (current, request, new, last)
Widget current, request, new;
Boolean last;
{
    SButtonWidget cur = (SButtonWidget) current;
    SButtonWidget req = (SButtonWidget) request;
    SButtonWidget bw = (SButtonWidget) new;
    Boolean redisplay_request = FALSE;

    if (cur->sbutton.interval_time != bw->sbutton.interval_time &&
	bw->sbutton.interval_id) {
	    XtRemoveTimeOut(bw->sbutton.interval_id);
	    bw->sbutton.interval_id =
		XtAddTimeOut(bw, bw->sbutton.interval_time);
    }

    return (redisplay_request);
}

/********************************************************
*							*
*	Action procedure				*
*							*
********************************************************/
/********************************************************
*							*
*	Set 						*
*							*
********************************************************/

#define RedisplayBitmapWidget(w) ((*((SBitmapWidgetClass)XtSuperclass(w))->sbitmap_class.redisplay)((Widget)w, event))

static void Set(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long num_param;
{
	SButtonWidget bw = (SButtonWidget)w;

	bw->sbutton.activated = TRUE;
	bw->sbitmap.highlighted = TRUE;
	RedisplayBitmapWidget(bw);
}

/********************************************************
*							*
*	Unset 						*
*							*
********************************************************/

static void Unset(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
Cardinal *num_param;
{
	SButtonWidget bw = (SButtonWidget)w;

	bw->sbutton.activated = FALSE;
	if (bw->sbitmap.highlighted) {
		bw->sbitmap.highlighted = FALSE;
		RedisplayBitmapWidget(bw);
	}
}

/********************************************************
*							*
*	Highlight					*
*							*
********************************************************/

static void Highlight(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long num_param;
{
	SButtonWidget bw = (SButtonWidget)w;

	if (bw->sbutton.activated) {
	    bw->sbitmap.highlighted = TRUE;
	    RedisplayBitmapWidget(bw);
	}
}

/********************************************************
*							*
*	Unhighlight 					*
*							*
********************************************************/

static void Unhighlight(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long num_param;
{
	SButtonWidget bw = (SButtonWidget)w;

	if (bw->sbutton.activated) {
	    bw->sbitmap.highlighted = FALSE;
	    RedisplayBitmapWidget(bw);
	}
}

/********************************************************
*							*
*	Notify						*
*							*
********************************************************/

static void Notify(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SButtonWidget bw = (SButtonWidget)w;
	int i, j;
	Boolean always= FALSE;

	for (i = 0; i < *num_param; i++) {
	    if (!strcmp(param[i], "always")) {
		always = TRUE;
	    }
	}

	if (always) {
	    XtCallCallbacks((Widget)bw, XtNcallback, event);
	} else if (bw->sbitmap.highlighted) {
	     for (i = 0; i < bw->sbutton.flash; i++) {
		bw->sbitmap.highlighted = FALSE;
		RedisplayBitmapWidget(bw);
		XSync(XtDisplay(bw), 1);
		for (j = 3000; j; j--);
		bw->sbitmap.highlighted = TRUE;
		RedisplayBitmapWidget(bw);
		XSync(XtDisplay(bw), 1);
		for (j = 3000; j; j--);
	    }
	    XtCallCallbacks((Widget)bw, XtNcallback, event);
	}
}

static void Timeout(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
	SButtonWidget bw = (SButtonWidget)client_data;

	XtCallCallbacks((Widget)bw, XtNcallback, NULL);
	bw->sbutton.interval_id = XtAddTimeOut(
			bw->sbutton.interval_time, Timeout, bw);
}

/********************************************************
*							*
*	Timer On					*
*							*
********************************************************/

static void TimerOn(w, event)
Widget w;
XEvent *event;
{
	SButtonWidget bw = (SButtonWidget)w;

	if (bw->sbutton.activated)
	    if (bw->sbutton.interval_time > 0) {
		bw->sbutton.interval_id = XtAddTimeOut(
			bw->sbutton.interval_time, Timeout, bw);
	}
}

/********************************************************
*							*
*	Timer Off					*
*							*
********************************************************/

static void TimerOff(w, event)
Widget w;
XEvent *event;
{
	SButtonWidget bw = (SButtonWidget)w;

	if (bw->sbutton.activated)
	    if (bw->sbutton.interval_id) {
		XtRemoveTimeOut(bw->sbutton.interval_id);
		bw->sbutton.interval_id = 0;
	    }
}
