/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SButtonP.h,v 1.1 88/08/20 09:06:42 michael Exp $ Sony Corporation
 *
 * $Log:	SButtonP.h,v $
 * Revision 1.1  88/08/20  09:06:42  michael
 * Initial revision
 * 
 */
/********************************************************
*							*
*	Private header for Sony Button Widget		*
*							*
*	Written by M.Abe				*
*							*
********************************************************/

#ifndef _XtSButtonPrivate_h
#define _XtSButtonPrivate_h

#include "X11/SBitmapP.h"
#include "X11/SButton.h"

/********************************************************
*							*
*	Class structure					*
*							*
********************************************************/

/* New fields for the Button widget class record */
typedef struct _SButtonClass 
  {
    int makes_compiler_happy;  /* not used */
  } SButtonClassPart;

/* Full class record declaration */
typedef struct _SButtonClassRec {
    CoreClassPart	core_class;
    SBitmapClassPart     sbitmap_class;
    SButtonClassPart     sbutton_class;
} SButtonClassRec;

extern SButtonClassRec sButtonClassRec;

/********************************************************
*							*
*	Instance (widget) structure 			*
*							*
********************************************************/

/* New fields for the Button widget record */
typedef struct {
	/* resources */
	XtCallbackList	callbacks;
	int		flash;				/* Resource */
	int 		interval_time;			/* Resource */

	/* private state */
	Boolean		activated;
	XtIntervalId	interval_id;
} SButtonPart;

/* Full widget declaration */
typedef struct _SButtonRec {
    CorePart         core;
    SBitmapPart      sbitmap;
    SButtonPart       sbutton;
} SButtonRec;

#endif _XtSButtonPrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */
