/********************************************************
*							*
*	Private header for Sony Image Widget		*
*							*
*	Copyright (C) 1988 by Sony			*
*	Written by M.Abe				*
*							*
********************************************************/
/*
 * $Header: SImageP.h,v 1.1 88/08/20 09:06:47 michael Exp $ Sony Corporation
 *
 * $Log:	SImageP.h,v $
 * Revision 1.1  88/08/20  09:06:47  michael
 * Initial revision
 * 
 */

#ifndef _XtSImagePrivate_h
#define _XtSImagePrivate_h

#include "SImage.h"
#include <X11/CoreP.h>

typedef struct {
	int x, y, width, height;
} Rect;

/********************************************************
*							*
*	Class structure					*
*							*
********************************************************/

/* New fields for the SImage widget class record */
typedef struct _SImageClass 
  {
	int	dummy;
  } SImageClassPart;

/* Full class record declaration */
typedef struct _SImageClassRec {
    CoreClassPart	core_class;
    SImageClassPart     simage_class;
} SImageClassRec;

extern SImageClassRec sImageClassRec;

/********************************************************
*							*
*	Instance (widget) structure 			*
*							*
********************************************************/

/* New fields for the SBitmap widget record */
typedef struct {
	/* resources */
	Visual		*visual;
	XImage		*image;
	XtCallbackList	callbacks;

	/* private state */
	GC		gc;
	Boolean		activated;
	Rect		rect;
	int		offset_x;
	int		offset_y;
	int		preferred_width;
	int		preferred_height;
} SImagePart;

/* Full widget declaration */
typedef struct _SImageRec {
    CorePart	core;
    SImagePart	simage;
} SImageRec;

#endif _XtSImagePrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */
