/*
 * BargraphP.h - Bargraph widget for X11 Toolkit
 * 
 * Author:	Mike Yang
 * 		Western Research Laboratory
 *	 	Digital Equipment Corporation
 * Date:	Mon Aug 9 1988
 * Copyright (c) 1988 Mike Yang
 *
 * A slight modification of code taken from the Scrollbar widget
 *
 */

#ifndef _BargraphP_h
#define _BargraphP_h

#include "Bargraph.h"
#include <X11/CoreP.h>

typedef struct {
  Pixel	  foreground;	/* thumb foreground color */
  XtOrientation orientation;	/* horizontal or vertical */
  Pixmap	  thumb;	/* thumb color */
  float	  top;		/* What percent is above the win's top */
  float	  shown;	/* What percent is shown in the win */
  int		  length;	/* either height or width */
  int		  thickness;	/* either width or height */
  GC		  gc;		/* a (shared) gc */
  int		  topLoc;	/* Pixel that corresponds to top */
  int		  shownLength;	/* Num pixels corresponding to shown */
  Pixel fill_color;
  Pixmap fill_pixmap;
} BargraphPart;

typedef struct _BargraphRec {
  CorePart core;
  BargraphPart bargraph;
} BargraphRec;

typedef struct _BargraphClass {
  int make_compiler_happy;
} BargraphClassPart;

typedef struct _BargraphClassRec {
  CoreClassPart core_class;
  BargraphClassPart bargraph_class;
/*
} BargraphClassRec, *BargraphWidgetClass;
*/
} BargraphClassRec;

extern BargraphClassRec bargraphClassRec;

#endif _Bargraphp_h
