#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Atoms.h>
#include <X11/Shell.h>
#include <X11/Cardinals.h>
#include "Lbl.h"
#include "Tbl.h"
#include "Sensitive.h"
#include "Command.h"

static XrmOptionDescRec options[] =
{
 {"-lbw",	"*Lbl.borderWidth",	XrmoptionSepArg,	NULL}
,{"-icw",	"*Tbl.interWidth",	XrmoptionSepArg,	NULL}
,{"-icw0",	"*tbl0.interWidth",	XrmoptionSepArg,	NULL}
,{"-icw1a",	"*tbl1a.interWidth",	XrmoptionSepArg,	NULL}
,{"-icw1b",	"*tbl1b.interWidth",	XrmoptionSepArg,	NULL}
,{"-ich",	"*Tbl.interHeight",	XrmoptionSepArg,	NULL}
,{"-ich0",	"*tbl0.interHeight",	XrmoptionSepArg,	NULL}
,{"-ich1a",	"*tbl1a.interHeight",	XrmoptionSepArg,	NULL}
,{"-ich1b",	"*tbl1b.interHeight",	XrmoptionSepArg,	NULL}
,{"-iw",	"*Tbl.internalWidth",	XrmoptionSepArg,	NULL}
,{"-iw0",	"*tbl0.internalWidth",	XrmoptionSepArg,	NULL}
,{"-iw1a",	"*tbl1a.internalWidth",	XrmoptionSepArg,	NULL}
,{"-iw1b",	"*tbl1b.internalWidth",	XrmoptionSepArg,	NULL}
,{"-ih",	"*Tbl.internalHeight",	XrmoptionSepArg,	NULL}
,{"-ih0",	"*tbl0.internalHeight",	XrmoptionSepArg,	NULL}
,{"-ih1a",	"*tbl1a.internalHeight",XrmoptionSepArg,	NULL}
,{"-ih1b",	"*tbl1b.internalHeight",XrmoptionSepArg,	NULL}
,{"-file",	"*tbl1a.formatFile",	XrmoptionSepArg,	NULL}
,{"-string",	"*tbl1a.formatString",	XrmoptionSepArg,	NULL}
,{"-resize",	"*Tbl.resizeParticipants", XrmoptionSepArg,	NULL}
,{"-er",	"*tbl1a.equalRows",	XrmoptionNoArg,		"True"}
,{"-ec",	"*tbl1a.equalColumns",	XrmoptionNoArg,		"True"}
};

static void Activate_text() ;
static void Activate_justify() ;
static void Activate_gravity() ;
static void Activate_fill() ;
static void convert_nl () ;

static void CvtStringToJustify() ;	/* Resource Converter */
static void CvtStringToGravity() ;	/* Resource Converter */

static XrmQuark	XrmQEleft, XrmQEcenter, XrmQEright ;	/* Justification */

static XrmQuark	XrmQEn, XrmQEne, XrmQEe, XrmQEse,	/* Gravity */
	        XrmQEs, XrmQEsw, XrmQEw, XrmQEnw, XrmQEc ;

static XtCallbackRec callback_text[] =
    { { Activate_text, NULL }	,{ NULL, NULL } } ;

static XtCallbackRec callback_justify[] =
    { { Activate_justify, NULL },{ NULL, NULL } } ;

static XtCallbackRec callback_gravity[] =
    { { Activate_gravity, NULL },{ NULL, NULL } } ;

static XtCallbackRec callback_fill[] =
    { { Activate_fill, NULL }	,{ NULL, NULL } } ;


Widget lbl[100] ;
Widget tbl0, tbl1a, tbl1b ;
static char lbl_text[100] ;
Cardinal n_widgets ;

static Arg cmd_arg ;

static Arg lbl_args[] =
    {
     {XtNlabel, (XtArgVal) lbl_text}
    ,{XtNjustify, (XtArgVal) XtJustifyCenter}
    } ;

static Arg tbl0_args[] =
    {
     {XtNformatString, (XtArgVal) "c c."}
    ,{XtNinterWidth, (XtArgVal) 10}
    ,{XtNinterHeight, (XtArgVal) 10}
    ,{XtNinternalWidth, (XtArgVal) 10}
    ,{XtNinternalHeight, (XtArgVal) 10}
    } ;

static Arg tbl1b_args[] =
    {
     {XtNformatString, (XtArgVal) "c."}
    ,{XtNinterHeight, (XtArgVal) -1}
    ,{XtNinternalWidth, (XtArgVal) 10}
    ,{XtNinternalHeight, (XtArgVal) 10}
    } ;

void
main (argc, argv)
    unsigned int argc;
    char **argv;
{
Cardinal i ;
Widget toplevel;

static Arg toplevel_args[] =
    {
    {XtNallowShellResize, (XtArgVal) True}
    } ;

if (argc < 2)
	{
	fprintf (stderr, "Usage: %s #_of_widgets\n", argv[0]) ;
	fprintf (stderr, "          [-file widget_description_file]\n") ;
	fprintf (stderr, "          [-string widget_description]\n") ;
	fprintf (stderr, "          ... (see source)\n") ;
	exit (1) ;
	}

XrmQEleft   = XrmStringToQuark("left") ;
XrmQEcenter = XrmStringToQuark("center") ;
XrmQEright  = XrmStringToQuark("right") ;
XtAddConverter( XtRString, XtRJustify, CvtStringToJustify, NULL, 0 ) ;

XrmQEn   = XrmStringToQuark("n") ;
XrmQEe   = XrmStringToQuark("e") ;
XrmQEs   = XrmStringToQuark("s") ;
XrmQEw   = XrmStringToQuark("w") ;
XrmQEne   = XrmStringToQuark("ne") ;
XrmQEnw   = XrmStringToQuark("nw") ;
XrmQEse   = XrmStringToQuark("se") ;
XrmQEsw   = XrmStringToQuark("sw") ;
XrmQEc   = XrmStringToQuark("c") ;
XtAddConverter( XtRString, XtRGravity, CvtStringToGravity, NULL, 0 ) ;

n_widgets = atoi (argv[1]) ;

toplevel = XtInitialize (NULL, "Demo", options, XtNumber(options), &argc, argv);

/*
 * tbl0 merely places the two layouts side by side
 * tbl1a is the variable test layout
 * tbl1b is the fixed cmd modifier layout
 */

tbl0 = XtCreateManagedWidget ("tbl0", tblWidgetClass, toplevel,
				tbl0_args, XtNumber(tbl0_args)) ;
tbl1a = XtCreateManagedWidget ("tbl1a", tblWidgetClass, tbl0, NULL, NULL) ;
tbl1b = XtCreateManagedWidget ("tbl1b", tblWidgetClass, tbl0,
				tbl1b_args, XtNumber(tbl1b_args)) ;

/*
 * load up the test layout with label widgets
 */

for (i=0; i < n_widgets;  i++)
    {
    char widget_name[100] ;

    sprintf (lbl_text, "Widget\n%d", i) ;
    sprintf (widget_name, "Widget%d", i) ;
    lbl[i] = XtCreateManagedWidget (widget_name, lblWidgetClass, tbl1a,
				    lbl_args, ONE) ;
    }

/*
 * load up the cmd layout with command widgets
 */

XtSetArg (cmd_arg, XtNcallback, (XtArgVal) callback_text) ;
lbl[i++] = XtCreateManagedWidget ("_text_", commandWidgetClass, tbl1b,
				&cmd_arg, ONE) ;

XtSetArg (cmd_arg, XtNcallback, (XtArgVal) callback_justify) ;
lbl[i++] = XtCreateManagedWidget ("_justify_", commandWidgetClass, tbl1b,
				&cmd_arg, ONE) ;

XtSetArg (cmd_arg, XtNcallback, (XtArgVal) callback_gravity) ;
lbl[i++] = XtCreateManagedWidget ("_gravity_", commandWidgetClass, tbl1b,
				&cmd_arg, ONE) ;

XtSetArg (cmd_arg, XtNcallback, (XtArgVal) callback_fill) ;
lbl[i++] = XtCreateManagedWidget ("_fill_", commandWidgetClass, tbl1b,
				&cmd_arg, ONE) ;

/*
 * go...
 */

XtRealizeWidget (toplevel) ;
XtSetValues (toplevel, toplevel_args, XtNumber(toplevel_args)) ;
XtMainLoop () ;
}

/*
 * The following four routines all work the same way.
 * They open a file of the same name as the label.
 * The first integer read is the number of widgets to modify
 * This is followed by pairs of widget numbers and new values
 */

/**
 *** Modifies the label of a widget
 **/

#include <X11/IntrinsicP.h>
#include "/X11/lib/tbl/TblP.h"

static void
Activate_text (w, closure, call_data)
    Widget w;
    caddr_t closure;
    caddr_t call_data;
{
FILE *fd ;
Cardinal i, n, m ;

fd = fopen ("_text_", "r") ;
if (fd <= 0)
	fprintf (stderr, "NO _text_ file!\n") ;
fscanf (fd, "%d", &n) ;
for (i=0;  i < n;  i++)
	{
	Cardinal j ;
	fscanf (fd, "%d", &m) ;
	fread (lbl_text, 1, 1, fd) ;
	fscanf (fd, "%[^\n]s", lbl_text) ;
	if (m < 0 || m >= n_widgets)
		{
		fprintf (stderr, "Error: widget %d does not exist\n", m) ;
		continue ;
		}
	convert_nl (lbl_text) ;
	XtSetValues (lbl[m], lbl_args, ONE) ;
	}
fclose (fd) ;
return ;
}

/**
 *** Modifies the justification of the label of a widget
 **/

static void
Activate_justify (w, closure, call_data)
    Widget w;
    caddr_t closure;
    caddr_t call_data;
{
FILE *fd ;
Cardinal i, n, m ;
XrmValue from, to ;

from.size = sizeof (String) ;
from.addr = (caddr_t) lbl_text ;

fd = fopen ("_justify_", "r") ;
if (fd <= 0)
	fprintf (stderr, "NO _justify_ file!\n") ;
fscanf (fd, "%d", &n) ;

for (i=0;  i < n;  i++)
	{
	Cardinal j ;
	LblWidget lw ;

	fscanf (fd, "%d", &m) ;
	fscanf (fd, "%s", lbl_text) ;
	if (m < 0 || m >= n_widgets)
		{
		fprintf (stderr, "Error: widget %d does not exist\n", m) ;
		continue ;
		}
	XtConvert (NULL, XtRString, &from, XtRJustify, &to) ;
	XtSetArg(lbl_args[1], XtNjustify, (XtArgVal) (*((XtJustify *)to.addr)));
	XtSetValues (lbl[m], &lbl_args[1], ONE) ;
	}
fclose (fd) ;
return ;
}

/**
 *** Modifies the gravity of a widget
 **/

static void
Activate_gravity (w, closure, call_data)
    Widget w;
    caddr_t closure;
    caddr_t call_data;
{
FILE *fd ;
Cardinal i, n, m ;
XrmValue from, to ;

from.size = sizeof (String) ;
from.addr = (caddr_t) lbl_text ;

fd = fopen ("_gravity_", "r") ;
if (fd <= 0)
	fprintf (stderr, "NO _gravity_ file!\n") ;
fscanf (fd, "%d", &n) ;

for (i=0;  i < n;  i++)
	{
	Cardinal j ;
	LblWidget lw ;

	fscanf (fd, "%d", &m) ;
	fscanf (fd, "%s", lbl_text) ;
	if (m < 0 || m >= n_widgets)
		{
		fprintf (stderr, "Error: widget %d does not exist\n", m) ;
		continue ;
		}
	XtConvert (NULL, XtRString, &from, XtRGravity, &to) ;
	XtSetArg(lbl_args[1], XtNgravity, (XtArgVal) (*((XtGravity *)to.addr)));
	lw = (LblWidget) lbl[m] ;
	XtSetValues (lbl[m], &lbl_args[1], ONE) ;
	}
fclose (fd) ;
return ;
}

/**
 *** Modifies the fill mode of a widget
 **/

static void
Activate_fill (w, closure, call_data)
    Widget w;
    caddr_t closure;
    caddr_t call_data;
{
FILE *fd ;
Cardinal i, n, m ;
XrmValue from, to ;

from.size = sizeof (String) ;
from.addr = (caddr_t) lbl_text ;

fd = fopen ("_fill_", "r") ;
if (fd <= 0)
	fprintf (stderr, "NO _fill_ file!\n") ;
fscanf (fd, "%d", &n) ;

for (i=0;  i < n;  i++)
	{
	Cardinal j ;
	LblWidget lw ;

	fscanf (fd, "%d", &m) ;
	fscanf (fd, "%s", lbl_text) ;
	if (m < 0 || m >= n_widgets)
		{
		fprintf (stderr, "Error: widget %d does not exist\n", m) ;
		continue ;
		}
	XtConvert (NULL, XtRString, &from, XtRBoolean, &to) ;
	XtSetArg(lbl_args[1], XtNfillColumn, (XtArgVal)(*((Boolean *)to.addr)));
	lw = (LblWidget) lbl[m] ;
	XtSetValues (lbl[m], &lbl_args[1], ONE) ;
	}
fclose (fd) ;
return ;
}

/***** **** *** ** * convert_nl * ** *** **** *****/

/*
 * convert instances of "\n" into '\n' and collapse the remainder of the text
 */

static void
convert_nl (text)
    char *text ;
{
Cardinal i, j ;
Cardinal len = strlen(text) ;

for (i=0;  i < len;  i++)
    {
    if (text[i] == '\\' && text[i+1] == 'n')
	{
	text[i] = '\n' ;
	j = i+1 ;
	while (text[j] != 0)
	    {
	    text[j] = text[j+1] ;
	    j++ ;
	    }
	}
    }
return ;
}

/**
 *** Resource Converters
 **/

#include <ctype.h>

/*
 * Convert String To Justify
 */

static void CvtStringToJustify(args, num_args, fromVal, toVal)
    XrmValuePtr *args ;		/* unused */
    Cardinal	*num_args ;	/* unused */
    XrmValuePtr fromVal ;
    XrmValuePtr toVal ;
{
static XtJustify	e ; /* must be static! */
XrmQuark	q ;
Cardinal	i ;
char	*s = (char *) fromVal->addr ;
char    lowerName[1000] ;

if (s == NULL) return ;

for (i=0; i<=strlen(s); i++)
    {
    char c = s[i] ;
    lowerName[i] = isupper(c) ? (char) tolower(c) : c ;
    }

q = XrmStringToQuark(lowerName) ;

toVal->size = sizeof(XtJustify) ;
toVal->addr = (caddr_t) &e ;

if (q == XrmQEleft)   { e = XtJustifyLeft;   return; }
if (q == XrmQEcenter) { e = XtJustifyCenter; return; }
if (q == XrmQEright)  { e = XtJustifyRight;  return; }

toVal->size = 0 ;
toVal->addr = NULL ;
return ;
}

/*
 * Convert String To Gravity
 */

static void CvtStringToGravity(args, num_args, fromVal, toVal)
    XrmValuePtr *args ;		/* unused */
    Cardinal	*num_args ;	/* unused */
    XrmValuePtr fromVal ;
    XrmValuePtr toVal ;
{
static XtGravity	e ; /* must be static! */
XrmQuark	q ;
Cardinal	i ;
char	*s = (char *) fromVal->addr ;
char    lowerName[1000] ;

if (s == NULL) return ;

for (i=0; i<=strlen(s); i++)
    {
    char c = s[i] ;
    lowerName[i] = isupper(c) ? (char) tolower(c) : c ;
    }

q = XrmStringToQuark(lowerName) ;

toVal->size = sizeof(XtGravity) ;
toVal->addr = (caddr_t) &e ;

if (q == XrmQEn)	{ e = XtNorthGravity;   return; }
if (q == XrmQEe)	{ e = XtEastGravity;   return; }
if (q == XrmQEs)	{ e = XtSouthGravity;   return; }
if (q == XrmQEw)	{ e = XtWestGravity;   return; }
if (q == XrmQEne)	{ e = XtNorthEastGravity;   return; }
if (q == XrmQEnw)	{ e = XtNorthWestGravity;   return; }
if (q == XrmQEse)	{ e = XtSouthEastGravity;   return; }
if (q == XrmQEsw)	{ e = XtSouthWestGravity;   return; }
if (q == XrmQEc)	{ e = XtCenterGravity;   return; }

toVal->size = 0 ;
toVal->addr = NULL ;
return ;
}

