/* 
 * CommandP.h - Private definitions for Command widget
 */

#ifndef _XtCommandP_h
#define _XtCommandP_h

#include "Command.h"
#include "SensitiveP.h"

/***********************************************************************
 *
 * Command Widget Private Data
 *
 ***********************************************************************/

/************************************
 *
 *  Class structure
 *
 ***********************************/


   /* New fields for the Command widget class record */
typedef struct _CommandClass 
  {
    int makes_compiler_happy;  /* not used */
  } CommandClassPart;

   /* Full class record declaration */
typedef struct _CommandClassRec {
    CoreClassPart	core_class;
    LblClassPart	lbl_class;
    SensitiveClassPart	sensitive_class;
    CommandClassPart    command_class;
} CommandClassRec;

extern CommandClassRec commandClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

    /* New fields for the Command widget record */
typedef struct {
    /* resources */
    Dimension   highlight_thickness;
    XtCallbackList callbacks;

    /* private state */
    Pixmap      gray_pixmap;
    GC          highlight_GC;
    GC          inverse_GC;
    GC          inverse_text_GC;
    Boolean     set;
    Boolean     highlighted;
    Boolean     display_set;
    Boolean     display_highlighted;
} CommandPart;


/*    XtEventsPtr eventTable;*/


   /* Full widget declaration */
typedef struct _CommandRec {
    CorePart         core;
    LblPart	     lbl;
    SensitivePart    sensitive;
    CommandPart      command;
} CommandRec;

#endif _XtCommandP_h


