/* 
 * LblP.h - Private definitions for Lbl widget
 */

#ifndef _XtLblP_h
#define _XtLblP_h

/* #include <X11/Lbl.h> */
#include "Lbl.h"

/* New fields for the Lbl widget class record */

typedef struct {int foo ;} LblClassPart ;

/* Full class record declaration */
typedef struct _LblClassRec
    {
    CoreClassPart	core_class ;
    LblClassPart	lbl_class ;
    } LblClassRec ;

extern LblClassRec lblClassRec ;

/* New fields for the Lbl widget record */

typedef struct
    {
    /* resources */
    Pixel	foreground ;
    XFontStruct	*font ;
    char	*lbl ;
    XtJustify	justify ;
    XtGravity	gravity ;
    int		internal_width ;
    int		internal_height ;
    float	line_factor ;

    /* private state */
    GC		normal_GC ;
    Position	*x ;
    Position	*y ;
    int		total_height ;
    int		total_width ;
    int		line_height ;
    int		*line_width ;
    unsigned int *len ;
    unsigned int *locations ;
    unsigned int n_lines ;
    } LblPart ;


/*
 * Full instance record declaration
 */

typedef struct _LblRec
    {
    CorePart	core ;
    LblPart	lbl ;
    } LblRec ;

#endif _XtLblP_h
