/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

This code was derived from a file that contained the notice in
disclaimer.h.  Insofar as my modifications are concerned, I grant
the same permissions and make the same disclaimers.

Gene W. Dykes, Program of Computer Graphics, Cornell University

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "disclaimer.h"
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "SensitiveP.h"

#define IsSensitive(w) ((w)->core.sensitive && (w)->core.ancestor_sensitive)

static Cursor defaultCursor = None;
static Pixmap defaultPixmap = NULL;

#define offset(field) XtOffset(SensitiveWidget, sensitive.field)

static XtResource resources[] =
    {
  {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor),
     offset(cursor), XtRCursor, (caddr_t)&defaultCursor},
  {XtNinsensitiveBorder, XtCInsensitive, XtRPixmap, sizeof(Pixmap),
     offset(insensitive_border), XtRPixmap, (caddr_t)&defaultPixmap}
    } ;

#undef offset

static void Initialize(), ClassPartInitialize(), Realize() ;
static Boolean SetValues(), ChangeSensitive() ;
static void GetgrayGC () ;

SensitiveClassRec sensitiveClassRec =
{
  { /* core fields */
    /* superclass		*/	(WidgetClass) &lblClassRec,
    /* class_name		*/	"Sensitive",
    /* widget_size		*/	sizeof(SensitiveRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	XtInheritResize,
    /* expose			*/	NULL,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
  },
  { /* label fields */
    0,
  },
  { /* sensitive fields */
    /* change_sensitive		*/	ChangeSensitive
  }
};

WidgetClass sensitiveWidgetClass = (WidgetClass)&sensitiveClassRec;

static void ClassPartInitialize(class)
    WidgetClass class;
{
    register SensitiveWidgetClass c = (SensitiveWidgetClass)class;

    if (c->sensitive_class.change_sensitive == XtInheritChangeSensitive)
	c->sensitive_class.change_sensitive = ChangeSensitive;
return ;
}


/* ARGSUSED */
static void Realize(w, valueMask, attributes)
    register Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    Pixmap border_pixmap;

    if (!IsSensitive(w)) {
	/* change border to gray; have to remember the old one,
	 * so XtDestroyWidget deletes the proper one */
	if (!((SensitiveWidget)w)->sensitive.insensitive_border)
	    ((SensitiveWidget)w)->sensitive.insensitive_border =
		XtGrayPixmap( XtScreen(w) );
        border_pixmap = w->core.border_pixmap;
	attributes->border_pixmap =
	  w->core.border_pixmap = ((SensitiveWidget)w)->sensitive.insensitive_border;

	*valueMask |= CWBorderPixmap;
	*valueMask &= ~CWBorderPixel;
    }

    if ((attributes->cursor = ((SensitiveWidget)w)->sensitive.cursor) != None)
	*valueMask |= CWCursor;

    XtCreateWindow( w, (unsigned int)InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attributes );

    if (!IsSensitive(w))
	w->core.border_pixmap = border_pixmap;

}

static Boolean
SetValues (current, request, new)
    Widget current, request, new;
{
SensitiveWidget csw = (SensitiveWidget) current ;
SensitiveWidget rsw = (SensitiveWidget) request ;
SensitiveWidget nsw = (SensitiveWidget) new ;

if ((csw->core.sensitive != nsw->core.sensitive ||
     csw->core.ancestor_sensitive != nsw->core.ancestor_sensitive))
    {
    ChangeSensitive( new );
    }

if (csw->lbl.foreground != rsw->lbl.foreground
    || csw->lbl.font->fid != rsw->lbl.font->fid)
    {
    XtDestroyGC (csw->sensitive.gray_GC);
    GetgrayGC (nsw);
    }

return False;
}


static Boolean ChangeSensitive(w)
    register Widget w;
{
    if (XtIsRealized(w)) {
	if (IsSensitive(w))
	    if (w->core.border_pixmap != UnspecifiedPixmap)
		XSetWindowBorderPixmap( XtDisplay(w), XtWindow(w),
				        w->core.border_pixmap );
	    else
		XSetWindowBorder( XtDisplay(w), XtWindow(w), 
				  w->core.border_pixel );
	else {
	    if (!((SensitiveWidget)w)->sensitive.insensitive_border)
		((SensitiveWidget)w)->sensitive.insensitive_border =
		    XtGrayPixmap( XtScreen(w) );
	    XSetWindowBorderPixmap( XtDisplay(w), XtWindow(w),
				    ((SensitiveWidget)w)->
				        sensitive.insensitive_border );
	}
    }
    return False;
}

static void
GetgrayGC (sw)
    SensitiveWidget sw;
{
XGCValues	values;

values.foreground = sw->lbl.foreground;
values.font	  = sw->lbl.font->fid;
values.tile       = XtGrayPixmap(XtScreen((Widget)sw));
values.fill_style = FillTiled;

sw->sensitive.gray_GC = XtGetGC ((Widget)sw, 
    (unsigned) GCForeground | GCFont | GCTile | GCFillStyle, 
    &values);
return ;
}

static void
Initialize (request, new)
    Widget request, new;
{
GetgrayGC ((SensitiveWidget) new) ;
return ;
}
