/* Tbl widget private definitions */

#ifndef _TblP_h
#define _TblP_h

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/ConstrainP.h>	/* Superclass Private Include File	*/
#include "Tbl.h"		/* Class Public Include File		*/

/*
 * Prepare for declaring new fields added to superclass widget structure
 */

#define MAX_TBL_COLS	100
#define MAX_TBL_ROWS	100

typedef enum { TBL_ITEM, TBL_HSPAN, TBL_VSPAN }
	XtPrimaryType ;

#ifndef _XtJustify_e
#define _XtJustify_e
typedef enum {XtJustifyLeft, XtJustifyCenter, XtJustifyRight}
	XtJustify ;
#endif

typedef enum { TBL_FIRST_PASS, TBL_NO_FORMAT, TBL_STRING_FORMAT }
	XtFormatMode ;

typedef struct s_item
    {
    XtPrimaryType primary ;/* widget or a span				*/
    XtJustify justify ;	/* justification of  text			*/
    XtGravity g ;	/* gravity of child				*/
    Boolean e ;		/* equal columns in this row			*/
    Boolean f ;		/* this column takes up the slack		*/
    Widget pw ;		/* points to widget responsible for this item	*/
    Cardinal pi ;	/* points to upper-left of this spanned item	*/
    Cardinal pj ;	/* points to upper-left of this spanned item	*/
    int	 width ;	/* save until needed by XtConfigureWidget	*/
    int	 height ;	/* save until needed by XtConfigureWidget	*/
    int adj_width ;	/* adjusted for spanning members		*/
    String text ;	/* item text					*/
    } ElementRecord ;

/*
 * The new fields added to superclass widget structure
 *
 * "Int" is often used instead of "Dimension" and "Cardinal" because there is
 * frequent use of these variables in expressions involving signed arithmentic
 */

typedef struct _TblPart
    {
    /* resources */
    Boolean	equal_columns ;	    /* XtNequalColumns			    */
    Boolean	equal_rows ;	    /* XtNequalRows			    */
    String	format_file ;	    /* Tbl description file		    */
    String	format_string ;	    /* Tbl description string		    */
    int	inter_width ;	    /* horizontal distance between children */
    int	inter_height ;	    /* vertical distance between children   */
    int	internal_width ;    /* horizontal space surrounding children*/
    int	internal_height ;   /* vertical space surrounding children  */
    XtResizeParticipants resize_participants ; /* what expands on resizes   */

    /* private state */
    ElementRecord *item[MAX_TBL_ROWS] ; /* stats for each matrix element    */
    int		*r_item ;	    /* number of "items" in a row	    */
    int		rows ;		    /* number of rows in matrix		    */
    int		cols[MAX_TBL_ROWS] ;/* number of cols in each row	    */
    int		max_cols ;	    /* need to save for resize calculations */
    Boolean	*equal_cols ;	    /* whether columns in this row are equal*/
    Boolean	*vspan_status ;	    /* whether this row is vert spanned	    */
    Boolean	initting ;	    /* whether InitLayout is active	    */
    Boolean	force_width ;	    /* whether width has been fumped	    */
    int		standalone_width ;  /* minimum width of table		    */
    int		standalone_height ; /* minimum height of table		    */
    int		typical_border ;
    Dimension	pre_almost_width ;
    Dimension	pre_almost_height ;
    Dimension	new_width ;	    /* set in ETS, xfer'd to core.width in  */
    Dimension	new_height ;        /* DoLayout                             */
    XtFormatMode format_mode ;	    /* file or string	    		    */
    /* needed only during parsing */
    int		string_breaker ;
    Cardinal	n_cols ;
    Cardinal	data_row ;
    ElementRecord temp_elements[MAX_TBL_COLS] ;
    ElementRecord *null_elements ;
    /* */
    int		child_border_width ;
    Pixel	child_border_color ;
    Pixel	child_background_color ;
    Pixel	child_foreground_color ;
    } TblPart ;

/*
 * The complete widget instance structure for this widget
 */

typedef struct _TblRec
    {
    CorePart		core ;
    CompositePart	composite ;
    ConstraintPart	constraint ;
    TblPart		tbl ;
    } TblRec ;

/*
 * The new fields added to superclass constraint structure
 */

typedef struct _TblConstraintsPart
    {
    Boolean	almost_status ;
    Boolean	differ_geometry ;
    Boolean	fill_column; /* this widget's column will fill on sts	*/
    int		span_width ; /* # of elements spanned			*/
    int		span_height ;
    int		sts_width ;  /* standalone table size			*/
    int		sts_height ;
    Position	ets_x ;      /* enclosed table positions		*/
    Position	ets_y ;
    int		ss_width ;  /* standalone size				*/
    int		ss_height ;
    int		ets_width ;  /* enclosed table size			*/
    int		ets_height ;
    Dimension	almost_width ;  /* Values returned with an Almost reply */
    Dimension	almost_height ;
    Dimension	almost_border ;
    Widget	almost_widget ;
    Position	almost_x ;
    Position	almost_y ;
    } TblConstraintsPart ;

/*
 * The complete Constraint structure
 */

typedef struct _TblConstraintsRec
    {
    TblConstraintsPart	tbl ;
    } TblConstraintsRec,
      *TblConstraints ;

/*
 * New fields added to the widget superclass class structure
 */

typedef String (*XtStringProc) () ;

typedef struct
    {
    XtStringProc interpret_string ;
    } TblClassPart ;

/*
 * The complete widget class structure for the widget
 */

typedef struct _TblClassRec
    {
    CoreClassPart	core_class ;
    CompositeClassPart	composite_class ;
    ConstraintClassPart	constraint_class ;
    TblClassPart	tbl_class ;
    } TblClassRec ;

/*
 * The name of a "constant" of the generic widget class structure
 */

extern TblClassRec tblClassRec ;

/*
 * For each new procedure in the widget class structure, an inherit operation
 */

#define XtInheritInterpretString ((XtStringProc) _XtInherit)

#endif _TblP_h
