%{

/* *
 * * This code is completely original.  Permission is granted to do with
 * * it as one wishes.  I disclaim any responsibility whatsoever for
 * * any bad things that may happen because of using it.
 * */

static void	col_exceeded () ;
static void	row_exceeded () ;
static void	find_strings () ;
static void	convert_nl () ;
static void	mismatch () ;
static void	no_rows () ;

static TblWidget tw_ ; /* no other way to get it into yylex... */
static Boolean new_menu_start = False ;

%}

%start	init

%union	{
	float	f_val ;
	int	i_val ;
	char	*s_val ;
	char	c_val ;
	}

%token <i_val>	INTEGER
%token <c_val>	CHARACTER
%token <s_val>	STRING
%token <s_val>	ITEM_ELEMENT
%token 		HSPAN_ELEMENT
%token 		VSPAN_ELEMENT
%token 		EQUAL_ROWS
%token 		EQUAL_COLUMNS
%token 		IGNORED_OPTION
%token 		TAMPERSAND
%token 		STRING_BREAKER
%token 		INTER_WIDTH
%token 		INTER_HEIGHT
%token 		INTERNAL_WIDTH
%token 		INTERNAL_HEIGHT
%token 		RESIZE_PARTICIPANTS
%token 		PADDING
%token 		INTERS
%token 		INTERNALS
%token 		CHILDREN
%token 		BACKGROUND_COLOR
%token 		T_BACKGROUND_COLOR
%token 		C_BACKGROUND_COLOR
%token 		FOREGROUND_COLOR
%token 		T_FOREGROUND_COLOR
%token 		C_FOREGROUND_COLOR
%token 		BORDER_COLOR
%token 		T_BORDER_COLOR
%token 		C_BORDER_COLOR
%token 		BORDER_WIDTH
%token 		T_BORDER_WIDTH
%token 		C_BORDER_WIDTH
%token 		TS
%token 		TE
%token 		NL
%token 		DOT_NL
%token 		ERROR

%%

init	:
	    {
	    /* One time initializations */
	    tw->tbl.null_elements = (ElementRecord *)
				    XtCalloc (1, sizeof (ElementRecord)) ;
	    tw_ = tw ;
	    }
	| init tbl
	;

tbl : dot_ts _options format_series dot_nl data dot_te
	{
	new_menu_start = True ;
	}
    ;

dot_nl	: '.'
	| DOT_NL
	;

dot_ts  :
	| TS NL
	;

dot_te	:
	| TE
	;

_options :
	 | options ';' NL
	 ;

format_series	: format
		| format_series NL format
		;

format : element_series
    {
    Cardinal i ;

    if (tw->tbl.rows == MAX_TBL_ROWS)
	row_exceeded () ;

    /* allocate just enough space for the number of columns in this row */

    tw->tbl.item[tw->tbl.rows] = (ElementRecord *)
			XtCalloc (tw->tbl.n_cols, sizeof (ElementRecord)) ;
    tw->tbl.cols[tw->tbl.rows] = tw->tbl.n_cols ;

    /* copy the elements found into the permanent record */

    for (i=0;  i < tw->tbl.n_cols;  i++)
	{
	tw->tbl.item[tw->tbl.rows][i] = tw->tbl.temp_elements[i] ;
	tw->tbl.temp_elements[i] = *tw->tbl.null_elements ;
	}
    tw->tbl.rows++ ;

    /* re-initialize for next row */

    tw->tbl.n_cols = 0 ;
    }
	| NL
	;

data	:
	| data_group_series
	;

data_group_series : data_group
		  | data_group_series data_group
		  ;

data_group : data_series
	   | TAMPERSAND NL format_series DOT_NL data_series
	   ;

data_series : stringline
	    | stringline data_series
	    ;

stringline : STRING
	{
	find_strings ($1, tw) ; 
	}
	   ;

options : option
	| option options
	| option NL options
	;

option	: EQUAL_ROWS
	    {
	    tw->tbl.equal_rows = True ;
	    }
	| EQUAL_COLUMNS
	    {
	    tw->tbl.equal_columns = True ;
	    }
	| IGNORED_OPTION
	    {
	    }
	| STRING_BREAKER '(' CHARACTER ')'
	    {
	    tw->tbl.string_breaker = $3 ;
	    }
	| INTER_WIDTH '(' INTEGER ')'
	    {
	    tw->tbl.inter_width = $3 ;
	    }
	| INTER_HEIGHT '(' INTEGER ')'
	    {
	    tw->tbl.inter_height = $3 ;
	    }
	| INTERNAL_WIDTH '(' INTEGER ')'
	    {
	    tw->tbl.internal_width = $3 ;
	    }
	| INTERNAL_HEIGHT '(' INTEGER ')'
	    {
	    tw->tbl.internal_height = $3 ;
	    }
	| INTERS '(' INTEGER ')'
	    {
	    tw->tbl.inter_width = $3 ;
	    tw->tbl.inter_height = $3 ;
	    }
	| INTERNALS '(' INTEGER ')'
	    {
	    tw->tbl.internal_width = $3 ;
	    tw->tbl.internal_height = $3 ;
	    }
	| PADDING '(' INTEGER ')'
	    {
	    tw->tbl.inter_width = $3 ;
	    tw->tbl.inter_height = $3 ;
	    tw->tbl.internal_width = $3 ;
	    tw->tbl.internal_height = $3 ;
	    }
	| BORDER_WIDTH '(' INTEGER ')'
	    {
	    tw->core.border_width = $3 ;
	    tw->tbl.child_border_width = $3 ;
	    }
	| T_BORDER_WIDTH '(' INTEGER ')'
	    {
	    tw->core.border_width = $3 ;
	    }
	| C_BORDER_WIDTH '(' INTEGER ')'
	    {
	    tw->tbl.child_border_width = $3 ;
	    tw->tbl.typical_border = $3 ;
	    }
	| BORDER_COLOR '(' INTEGER ')'
	    {
	    tw->core.border_pixel = $3 ; /* see comment below */
	    tw->tbl.child_border_color = $3 ;
	    }
	| T_BORDER_COLOR '(' INTEGER ')'
	    {
	    /*
	     * This doesn't work!
	     */
	    tw->core.border_pixel = $3 ;
	    }
	| C_BORDER_COLOR '(' INTEGER ')'
	    {
	    tw->tbl.child_border_color = $3 ;
	    }
	| FOREGROUND_COLOR '(' INTEGER ')'
	    {
	    tw->tbl.child_foreground_color = $3 ;
	    }
	| C_FOREGROUND_COLOR '(' INTEGER ')'
	    {
	    tw->tbl.child_foreground_color = $3 ;
	    }
	| BACKGROUND_COLOR '(' INTEGER ')'
	    {
	    tw->core.background_pixel = $3 ;
	    tw->tbl.child_background_color = $3 ;
	    }
	| T_BACKGROUND_COLOR '(' INTEGER ')'
	    {
	    tw->core.background_pixel = $3 ;
	    }
	| C_BACKGROUND_COLOR '(' INTEGER ')'
	    {
	    tw->tbl.child_background_color = $3 ;
	    }
	| resize_participants '(' participants ')'
	    {
	    }
	;

resize_participants : RESIZE_PARTICIPANTS
		{
		tw->tbl.resize_participants = XtResizeNone ;
		}
		    ;

participants : participant
	     | participants participant
	     ;

participant  : INTERS
		{
		tw->tbl.resize_participants =
		   (XtResizeParticipants) ((int)tw->tbl.resize_participants |
					   (int)XtResizeInters) ;
		}
	     | INTERNALS
		{
		tw->tbl.resize_participants =
		   (XtResizeParticipants) ((int)tw->tbl.resize_participants |
					   (int)XtResizeInternals) ;
		}
	     | CHILDREN
		{
		tw->tbl.resize_participants =
		   (XtResizeParticipants) ((int)tw->tbl.resize_participants |
					   (int)XtResizeChildren) ;
		}
	     ;

element_series	: element
		| element_series element
		;

element	: ITEM_ELEMENT
    {
    char *ptr ;
    int nc = tw->tbl.n_cols ;

    if (nc == MAX_TBL_COLS)
	col_exceeded () ;

    tw->tbl.temp_elements[nc].primary = TBL_ITEM ;

    /* check for qualifiers */

    ptr = $1 ;
    while (*ptr != 0)
	{
	switch (*ptr++)
	  {
	  case 'l' : case 'L' :
	    {
	    tw->tbl.temp_elements[nc].justify = XtJustifyLeft ;
	    break ;
	    }
	  case 'r' : case 'R' :
	    {
	    tw->tbl.temp_elements[nc].justify = XtJustifyRight ;
	    break ;
	    }
	  case 'c' : case 'C' :
	    {
	    tw->tbl.temp_elements[nc].justify = XtJustifyCenter;
	    break ;
	    }
	  case 'e' : case 'E' :
	    {
	    tw->tbl.temp_elements[nc].e = True ;
	    break ;
	    }
	  case '@' :
	    {
	    tw->tbl.temp_elements[nc].f = True ;
	    break ;
	    }
	  case 'g' : case 'G' :
	    {
	    switch (*ptr)
	      {
	      case 'n' : case 'N' :
		{
		switch (*(ptr+1))
		  {
		  case 'e' : case 'E' :
		    {
		    tw->tbl.temp_elements[nc].g = XtNorthEastGravity ;
		    ptr += 2 ;
		    break ;
		    }
		  case 'w' : case 'W' :
		    {
		    tw->tbl.temp_elements[nc].g = XtNorthWestGravity ;
		    ptr += 2 ;
		    break ;
		    }
		  default :
		    {
		    tw->tbl.temp_elements[nc].g = XtNorthGravity ;
		    ptr += 1 ;
		    break ;
		    }
		  }
		break ;
		}
	      case 's' : case 'S' :
		{
		switch (*(ptr+1))
		  {
		  case 'e' : case 'E' :
		    {
		    tw->tbl.temp_elements[nc].g = XtSouthEastGravity ;
		    ptr += 2 ;
		    break ;
		    }
		  case 'w' : case 'W' :
		    {
		    tw->tbl.temp_elements[nc].g = XtSouthWestGravity ;
		    ptr += 2 ;
		    break ;
		    }
		  default :
		    {
		    tw->tbl.temp_elements[nc].g = XtSouthGravity ;
		    ptr += 1 ;
		    break ;
		    }
		  }
		break ;
		}
	      case 'e' : case 'E' :
		{
		tw->tbl.temp_elements[nc].g = XtEastGravity ;
		ptr++ ;
		break ;
		}
	      case 'w' : case 'W' :
		{
		tw->tbl.temp_elements[nc].g = XtWestGravity ;
		ptr++ ;
		break ;
		}
	      case 'c' : case 'C' :
		{
		tw->tbl.temp_elements[nc].g = XtCenterGravity ;
		ptr++ ;
		break ;
		}
	      default :
		{
		char *my_text = "Tbl: Invalid gravity specifier: (%c)\n" ;
		char *etext = XtMalloc (strlen(my_text) + 1) ;
		sprintf (etext, my_text, *ptr) ;
		XtWarning (etext) ;
		break ;
		}
	      }
	    break ;
	    }
	  default :
	    {
	    break ;
	    }
	  }
	}

    XtFree ($1) ;
    tw->tbl.n_cols++ ;
    }
	| VSPAN_ELEMENT
    {
    if (tw->tbl.n_cols == MAX_TBL_COLS)
	col_exceeded () ;
    tw->tbl.temp_elements[tw->tbl.n_cols++].primary = TBL_VSPAN ;
    }
	| HSPAN_ELEMENT
    {
    if (tw->tbl.n_cols == MAX_TBL_COLS)
	col_exceeded () ;
    tw->tbl.temp_elements[tw->tbl.n_cols++].primary = TBL_HSPAN ;
    }
	;

%%

/***** **** *** ** * find_strings * ** *** **** *****/

static void
find_strings (text, tw)
    char *text ;
    TblWidget tw ;
{
/*
 * One quick pass to find out the number of sub-strings
 */
int *first_char ;
int *n_chars ;
Cardinal i, j ;
Cardinal istring ;
Cardinal n_strings ;
int length = strlen (text) ;

tw->tbl.n_cols = 0 ;
for (i=0;  i < length;  i++)
    {
    if (text[i] == tw->tbl.string_breaker)
	{
	tw->tbl.n_cols++ ;
	}
    }
tw->tbl.n_cols++ ;

/*
 * Check to see if there is a corresponding format row.
 * If not, duplicate the last format row.
 */

if (tw->tbl.data_row + 1 > tw->tbl.rows)
    {
    Cardinal i ;

    if (tw->tbl.rows == 0)
	no_rows () ;
    if (tw->tbl.rows == MAX_TBL_ROWS)
	row_exceeded () ;

    /* allocate just enough space for the number of columns in this row */

    tw->tbl.item[tw->tbl.rows] =
	(ElementRecord *) XtCalloc (tw->tbl.cols[tw->tbl.rows-1],
				    sizeof (ElementRecord)) ;
    /* make a copy of the previous row */
    for (i=0;  i < tw->tbl.cols[tw->tbl.rows-1];  i++)
	tw->tbl.item[tw->tbl.rows][i] = tw->tbl.item[tw->tbl.rows-1][i] ;
    tw->tbl.cols[tw->tbl.rows] = tw->tbl.cols[tw->tbl.rows-1] ;
    tw->tbl.rows++ ;
    }

/*
 * Check to see that the number of data items matches the number of format items
 */

 {
 Cardinal n_items = 0 ;
 for (i=0;  i < tw->tbl.cols[tw->tbl.data_row];  i++)
    if (tw->tbl.item[tw->tbl.data_row][i].primary == TBL_ITEM ||
	tw->tbl.item[tw->tbl.data_row][i].primary == TBL_VSPAN)
	n_items++ ;

 if (tw->tbl.n_cols != n_items)
    {
    mismatch ((Cardinal)tw->tbl.n_cols, n_items, tw->tbl.data_row);
    }
 }

/*
 * Do another pass of the string to find the starting points and lengths
 * of the the substrings
 */

first_char = (int *) XtMalloc (tw->tbl.n_cols * sizeof (int)) ;
n_chars = (int *) XtMalloc (tw->tbl.n_cols * sizeof (int)) ;

n_strings = 0 ;
first_char[0] = 0 ;

for (i=0;  i < length;  i++)
    {
    if (text[i] == tw->tbl.string_breaker)
	{
	n_chars[n_strings] = i - first_char[n_strings] ;
	n_strings++ ;
	first_char[n_strings] = i+1 ;
	}
    }
n_chars[n_strings] = length - first_char[n_strings] ;

/*
 * Now copy the substrings into the item records
 */

istring = 0 ;
for (j=0;  j < tw->tbl.cols[tw->tbl.data_row];  j++)
    {
    if (tw->tbl.item[tw->tbl.data_row][j].primary != TBL_ITEM)
	{
	if (tw->tbl.item[tw->tbl.data_row][j].primary == TBL_VSPAN)
	    istring++ ;
	continue ;
	}
    tw->tbl.item[tw->tbl.data_row][j].text = XtMalloc (n_chars[istring] + 1) ;
    strncpy (tw->tbl.item[tw->tbl.data_row][j].text,
	     &text[first_char[istring]], n_chars[istring]) ;
    tw->tbl.item[tw->tbl.data_row][j].text[n_chars[istring]] = '\0' ;
    /* Convert instances of "\n" to '\n' */
    convert_nl (tw->tbl.item[tw->tbl.data_row][j].text) ;

    istring++ ;
    }

tw->tbl.data_row++ ;
tw->tbl.n_cols = 0 ;

XtFree ((char *) first_char) ;
XtFree ((char *) n_chars) ;

return ;
}

/***** **** *** ** * row_exceeded * ** *** **** *****/

static void
row_exceeded ()
{
char *my_text = "Tbl: MAX_TBL_ROWS exceeded: %d\n" ;
char *etext = XtMalloc (strlen(my_text) + 5) ;
sprintf (etext, my_text, MAX_TBL_ROWS) ;
XtError (etext) ;
}

/***** **** *** ** * no_rows * ** *** **** *****/

static void
no_rows ()
{
XtError ("Tbl: No format items found before data!\n") ;
}

/***** **** *** ** * col_exceeded * ** *** **** *****/

static void
col_exceeded ()
{
char *my_text = "Tbl: MAX_TBL_COLS exceeded: %d\n" ;
char *etext = XtMalloc (strlen(my_text) + 5) ;
sprintf (etext, my_text, MAX_TBL_COLS) ;
XtError (etext) ;
}

/***** **** *** ** * mismatch * ** *** **** *****/

static void
mismatch (data_items, format_items, row_number)
Cardinal data_items ;
Cardinal format_items ;
Cardinal row_number ;
{
char *my_text = "Tbl: item/format mismatch in data row # %d (%d != %d)\n" ;
char *etext = XtMalloc (strlen(my_text) + 15) ;
sprintf (etext, my_text, row_number, data_items, format_items) ;
XtError (etext) ;
}

/***** **** *** ** * convert_nl * ** *** **** *****/

/*
 * convert instances of "\n" into '\n' and collapse the remainder of the text
 */

static void
convert_nl (text)
    char *text ;
{
Cardinal i, j ;
Cardinal len = strlen(text) ;

for (i=0;  i < len;  i++)
    {
    if (text[i] == '\\' && text[i+1] == 'n')
	{
	text[i] = '\n' ;
	j = i+1 ;
	while (text[j] != 0)
	    {
	    text[j] = text[j+1] ;
	    j++ ;
	    }
	}
    }
return ;
}

#include "lex.ytbl.c"
