/*
.nf
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		      Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP. MASSCOMP MAKES
 * NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
 * PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 *
 */

#ifndef _XtDLCommandP_h
#define _XtDLCommandP_h

/*
 *
 * DL Command Widget Private Data
 *
 */

/*
 *
 *  Class structure
 *
 */


   /* New fields for the Command widget class record */
 
typedef struct _DLCommandClass 
{
    int makes_compiler_happy;  /* not used */
} DLCommandClassPart;

   /* Full class record declaration */
typedef struct _DLCommandClassRec {
  CoreClassPart	core_class;
  DLCommandClassPart command_class;
} DLCommandClassRec;

extern DLCommandClassRec DLcommandClassRec;

/*
 *
 *  Instance (widget) structure 
 *
 */

    /* New fields for the Command widget record */
 
typedef struct {

    /* these are the semantic fields */	
	
    XtCallbackList callbacks;
    Boolean     set;
    Boolean     highlighted;
    Boolean     display_set;
    Boolean     display_highlighted;
    
    /* these are the graphics fields, added to hold the display lists */    
    
    unsigned int DLSize;
    short	*DL;
    unsigned int setDLSize;
    short	*setDL;
    unsigned int highlightedDLSize;
    short	*highlightedDL;
} DLCommandPart;


/* Full widget declaration */

typedef struct _DLCommandRec {
    CorePart         core;
    DLCommandPart    command;
} DLCommandRec;


typedef struct _DLCommandClassRec   *DLCommandWidgetClass;
typedef struct _DLCommandRec        *DLCommandWidget;

#endif _XtDLCommandP_h








