/*
.nf
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		      Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP. MASSCOMP MAKES
 * NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY
 * PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 *
 */

 
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "DLObedientP.h"


/* 
 * global GC's & pixmaps used by all display lists widgets
 */

extern GC GlobalGC;
extern GC GlobalGrayGC;
extern Pixmap GlobalGrayPixmap;

/*
 * private routines to handle class events
 */

static void ClassInitialize();
static void Initialize();
static void Realize();
static void Resize();
static void Notify();
static void Redisplay();
static XtGeometryResult GeometryManager();
static void ChangeManaged();
static void Destroy();
static Boolean SetValues();

static char defaultTranslations[] =
    "<Btn1Down>:	notify() \n\
     <Btn1Up>:		notify() \n\
     <EnterWindow>:	notify() \n\
     <LeaveWindow>:	notify()";

static XtActionsRec actionsList[] =
{
  {"notify",		Notify},
};

/*
 * class record initialized values
 */

DLObedientClassRec DLobedientClassRec = {
    {
		/* core_class fields      */
	
	(WidgetClass) &compositeClassRec, /* superclass */
	"DLObedient",		/* class name */
	sizeof(DLObedientRec),	/* widget size */
	ClassInitialize,	/* class initialize rtn */
	NULL, 			/* class_part_init    */
	FALSE,			/* class initialized flag */
	Initialize,		/* instance initialize rtn */
	NULL,			/* initialize_hook */
	Realize,		/* realize rtn */
	actionsList,            /* actions		*/
	XtNumber(actionsList),  /* num_actions	*/
	NULL,			/* resources */
	0,			/* number of resources */
	NULLQUARK,		/* xrm class */
	TRUE,			/* compress motion events */
	TRUE,			/* compress exposure events */
	TRUE,			/* compress_enterleave */
	FALSE,			/* visible interest */
	Destroy,		/* destroy rtn */
	Resize,			/* resize routine */
	Redisplay,		/* expose/Redisplay rtn */
	SetValues,		/* set values rtn */
	NULL,			/* set_values_hook    */
	XtInheritSetValuesAlmost,    /* set_values_almost  */    
	NULL, 			/* get_values_hook */
	NULL,			/* accept focus */
	XtVersion,		/* version */
	NULL,			/* call back private */
	defaultTranslations,			/* tm_table */
	NULL, 			/* query_geometry */
    },{
		/* composite_class fields */
	
	GeometryManager,	/* geometry manager */
	ChangeManaged,		/* change managed, isn't done, but composite hangs
				   without it */
	NULL,			/* insert_child, inherit from superclass */
	NULL,			/* delete_child, inherit from superclass */
	NULL			/* move focus to next */
    },{
		/* Currently empty obedient class structure */	
	0	
    }
};

WidgetClass DLobedientWidgetClass = (WidgetClass) &DLobedientClassRec;


/*
 * Widgets private routines
 */

static void ClassInitialize()
{
	CompositeWidgetClass superclass;
	DLObedientWidgetClass myclass;

	myclass = (DLObedientWidgetClass) DLobedientWidgetClass;
	superclass = (CompositeWidgetClass) myclass->core_class.superclass;

	/* Inherit insert_child and delete_child from Composite */
	
	myclass->composite_class.insert_child =
        	superclass->composite_class.insert_child;
	myclass->composite_class.delete_child =
		superclass->composite_class.delete_child;
}

static void Initialize( request, new )
DLObedientWidget request, new;
{
	/* 
	 * initialize the display list fields
	 */
	
	if (new->core.width == 0) new->core.width = 100;
	if (new->core.height == 0) new->core.height = 100;
	new->obedient.DLSize = 0;
	new->obedient.DL = NULL;
	
	/*
	 * initialize some fields to help out resizing
	 */
	
	new->obedient.owidth = new->core.width;
	new->obedient.oheight = new->core.height;
}


/*
 *
 * Rescale children of the obedient widget
 * and the obedient widget
 *
 */

static void Resize( ow )
DLObedientWidget	ow;
{
	register int i;
	Widget widget;
	double fwd_scale, fht_scale, fx, fy, fwd, fht;

	/*
	 * resize our displaylist if we have one
	 */
	
	if (ow->obedient.DL)
		resize_display_list( ow->obedient.DL, ow->core.x, ow->core.y, 
			ow->core.width,  ow->core.height);
			
	/*
	 * get the old height & width 
	 */
			
	fwd_scale = (float) ow->core.width / (float) ow->obedient.owidth;
	fht_scale = (float) ow->core.height / (float) ow->obedient.oheight;
	
	/*
	 * run thru the children, scaling them all evenly
	 */
	
	for (i = 0; i < ow->composite.num_children; i++) {
		widget = ow->composite.children[i];
		fx = (float)widget->core.x * fwd_scale;
		fy = (float)widget->core.y * fht_scale;
		fwd = (float)widget->core.width * fwd_scale;
		fht = (float)widget->core.height * fht_scale;
		XtResizeWidget( widget, (int)fwd, (int)fht, widget->core.border_width );
		XtMoveWidget( widget, (int) fx, (int) fy );
	}
	ow->obedient.owidth = ow->core.width;
	ow->obedient.oheight = ow->core.height;
}


/*
 * Redisplay widget using display list
 */

static void Redisplay( w, event, region )
Widget w;
XEvent *event;		/* unused */
Region region;		/* unused */
{
	DLObedientWidget ow = (DLObedientWidget) w;

	/* 
	 * use the display list if it exists
	 */
   
	if (ow->obedient.DLSize > 0)
		draw_display_list( XtDisplay(w), XtWindow(w),
				GlobalGC, ow->obedient.DL );

}


/*
 * Very kind and Obedient Geometry Manager
 */

static XtGeometryResult GeometryManager( w, request, reply )
Widget	w;
XtWidgetGeometry *request;
XtWidgetGeometry *reply;  /* returned */
{

    if (request->request_mode & CWX) w->core.x = request->x;
    if (request->request_mode & CWX) w->core.y = request->y;
    if (request->request_mode & CWWidth) w->core.width = request->width;
    if (request->request_mode & CWHeight) w->core.height = request->height;
    if (request->request_mode & CWBorderWidth)
    		w->core.border_width = request->border_width;	
	
    return XtGeometryYes;
}


static void ChangeManaged( ow )
DLObedientWidget ow;
{
  /* don't have any management */
}

   
static void Realize( w, valueMask, attributes )
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	attributes->bit_gravity = NorthWestGravity;
	*valueMask |= CWBitGravity;

	XtCreateWindow( w, InputOutput, (Visual *)CopyFromParent,
		    *valueMask, attributes);
}

/*
 *  Destroy procedure
 */

static void Destroy( w )
Widget w;
{
	/*
	 * we must free up display lists, 
	 * and any information bound into them.
	 */
}

/*
 * Set Values
 */

#define IsSensitive(w)	((w)->core.sensitive && (w)->core.ancestor_sensitive)

static Boolean SetValues ( current, request, new, last )
DLObedientWidget current, request, new;
Boolean last;
{
	DLObedientWidget curow = (DLObedientWidget) current;
	DLObedientWidget newow = (DLObedientWidget) new;
	
	if ((curow->core.sensitive != newow->core.sensitive ||
	 curow->core.ancestor_sensitive != newow->core.ancestor_sensitive)
	&& XtIsRealized(newow)) {
		if (IsSensitive(newow))
			XSetWindowBorder( XtDisplay(newow), XtWindow(newow), 
			      newow->core.border_pixel );
		else
			XSetWindowBorderPixmap(XtDisplay(newow), 
				XtWindow(newow), GlobalGrayPixmap);
		return True;
	}
	return False;
}

/* Don't do anything! Hack to get R3 version to work */

static void Notify(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;		/* unused */
Cardinal *num_params;	/* unused */
{
/*	DLObedientWidget obw = (DLObedientWidget)w;
	if (ComWset)
		XtCallCallbacks(w, XtNcallback, NULL);
 */
}
