/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */
/*.
.nf\
*/

#include <stdio.h>
#include "X11/Xlib.h"
#include "X11/Xatom.h"
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

typedef struct {
	int flags;
	int x;
	int y;
} Point;

long foreground = 1;

extern int max_colors;
extern int color_display;
extern Display *display, *toplevelDisplay;
extern Colormap colormap;
extern GC gc, cursor_gc;
extern Window window;
extern int colors[256];


#ifndef NULL
#define NULL 0L
#endif
#define FAIL 0
#define SUCCESS 1

Window get_two_points_and_window( x1, y1, x2, y2 )
int *x1, *y1, *x2, *y2;
{
	Window window;
	int t;
	Point *pt, *loop_until_down_and_get_window(), *echo_until_up();

	pt = loop_until_down_and_get_window( &window );
	if (!pt) return NULL;
	*x1 = pt->x; *y1 = pt->y;
	pt = echo_until_up( window, pt );
	if (!pt) { printf("No second point\n"); return NULL; }
	*x2 = pt->x;
	*y2 = pt->y;
	if (*x1 > *x2) { t = *x2; *x2 = *x1; *x1 = t; }
	if (*y1 > *y2) { t = *y2; *y2 = *y1; *y1 = t; }

	if (!window) printf("No window found\n");
	return window;
}
	


Window get_two_line_points_and_window( x1, y1, x2, y2 )
int *x1, *y1, *x2, *y2;
{
	Window window;
	Point *pt, *loop_until_down_and_get_window();
	Point *echo_line_until_up();

	pt = loop_until_down_and_get_window( &window );
	if (!pt) return NULL;
	*x1 = pt->x; *y1 = pt->y;
	pt = echo_line_until_up( window, pt );
	if (!pt) { printf("No second line point\n"); return NULL; }
	*x2 = pt->x;
	*y2 = pt->y;
	return window;
}

Point loop_down_pt;

Point *loop_until_down_and_get_window( window ) Window *window;
{

	int x, y;
	XEvent event;

	while( 1 ) {
		if(XPending( toplevelDisplay ) ) {
		        XtNextEvent( &event );
			if ((event.type != MotionNotify) &&	
			    (!BeingEdited( event.xbutton.window ))) {
				XtDispatchEvent( &event );
				if ((event.type == LeaveNotify) || (event.type == EnterNotify)) continue;
				return NULL;
			}
			switch( event.type ) {

				case ButtonPress:
					*window = event.xbutton.window;
					loop_down_pt.x = event.xbutton.x;
					loop_down_pt.y =  event.xbutton.y;
					return &loop_down_pt;
				case ButtonRelease:
						break;
				case MotionNotify:
						break;
				case Expose:
						break;
			}
		}
	}
}


Point loop_up_pt;

Point *loop_until_up( window ) Window window;
{

	XEvent event;

	while( 1 ) {
		if(XPending( display ) ) {
			XNextEvent( display, &event);
			if ((event.type == ButtonRelease) && check_palette( &event ))
				continue;
			
			if (event.xbutton.window != window) {
			  printf("Window does not match\n");
			  return NULL;
			}

			switch( event.type ) {
				case ButtonPress:
					break;
				case ButtonRelease:
					loop_up_pt.x = event.xbutton.x;
					loop_up_pt.y =  event.xbutton.y;
					return &loop_up_pt;
				case MotionNotify:
					break;
				case Expose:
					break;
			}
		}
	}
}

Point echo_pt;

Point *echo_until_up( window, pt ) Window window; Point *pt;
{

	XEvent event;
	int t, x1, y1, x2, y2, width, height, ox, oy, ow, oh;

	ox = -1;

	while( 1 ) {
			if( XPending( display ) ) {
				do {
					XNextEvent( display, &event);
					if ((event.type == ButtonRelease) 
						&& check_palette( &event ))
							continue;
					if (event.xbutton.window != window) {
						if ( ox >= 0 ) XDrawRectangle(
						   display, window, 
						   	cursor_gc, 
							    ox, oy, ow, oh );
						return NULL; 
					}
				} while( XPending( display )) ;	
			switch( event.type ) {
				case ButtonPress:
					break;
					

				case ButtonRelease:

					x1 = pt->x;
					y1 = pt->y;
					x2 = event.xbutton.x;
					y2 = event.xbutton.y;
					if (x1 > x2) { t = x2; x2 = x1; x1 = t; }
					if (y1 > y2) { t = y2; y2 = y1; y1 = t; }
					width = x2 - x1 + 1;
					height = y2 - y1 + 1; 
					
					if ( ox >= 0 ) 
					    XDrawRectangle(display, window, 
					        cursor_gc, ox, oy, ow, oh );

					XDrawRectangle(display, window, 
					    cursor_gc, x1, y1, width, height);
					XDrawRectangle(display, window, 
					    cursor_gc, x1, y1, width, height);
					
					echo_pt.x = event.xbutton.x;
					echo_pt.y = event.xbutton.y;
					return &echo_pt;
					
				case MotionNotify:
					x1 = pt->x;
					y1 = pt->y;
					x2 = event.xbutton.x;
					y2 = event.xbutton.y;
					if (x1 > x2) { t = x2; x2 = x1; x1 = t; }
					if (y1 > y2) { t = y2; y2 = y1; y1 = t; }
					width = x2 - x1 + 1;
					height = y2 - y1 + 1; 

					if ( ox >= 0 ) XDrawRectangle(
							display, window, 
							  cursor_gc,
							    ox, oy, ow, oh );
					XDrawRectangle(display, window, 
						cursor_gc, x1, y1, width, height);
					ox = x1; oy = y1; ow = width; oh = height;
					break;
				case Expose:
					break;
			}
		}
	}
}


Point *echo_line_until_up( window, pt ) Window window; Point *pt;
{

	XEvent event;
	int x1, y1, x2, y2, ox1, oy1, ox2, oy2;
	
	ox1 = -1;

	while( 1 ) {
			if( XPending( display ) ) {
				do {
					XNextEvent( display, &event);
					if ((event.type == ButtonRelease) 
						&& check_palette( &event ))
							continue;
					if (event.xbutton.window != window) {
						if ( ox1 >= 0) XDrawLine(
						   display, window, cursor_gc, 
							  ox1, oy1, ox2, oy2 );
						return NULL; 
					}
				} while( XPending( display )) ;	
			switch( event.type ) {
				case ButtonPress:
					break;
					
				case ButtonRelease:

					x1 = pt->x;
					y1 = pt->y;
					x2 = event.xbutton.x;
					y2 = event.xbutton.y;
					
				if ( ox1 >= 0 ) XDrawLine(display, window, 
					   cursor_gc, ox1, oy1, ox2, oy2 );

					XDrawLine(display, window, 
						cursor_gc, x1, y1, x2, y2 );
					XDrawLine(display, window, 
						cursor_gc, x1, y1, x2, y2 );
					
					echo_pt.x = event.xbutton.x;
					echo_pt.y = event.xbutton.y;
					return &echo_pt;
					
				case MotionNotify:
					x1 = pt->x;
					y1 = pt->y;
					x2 = event.xbutton.x;
					y2 = event.xbutton.y;
					if (ox1 >= 0) XDrawLine(display,window,
					    cursor_gc, ox1, oy1, ox2, oy2 );
					XDrawLine(display, window, 
						cursor_gc, x1, y1, x2, y2);
					ox1 = x1; oy1 = y1; ox2 = x2; oy2 = y2;
					break;
				case Expose:
					break;
			}
		}
	}
}


Window echo_box_and_loop_until_up( window, x1, y1, w, h, dx, dy )
Window window; int *x1, *y1, w, h, dx, dy;
{
	int x, y, ox, oy;
	XEvent event;
	
	if (!window) return NULL;
	ox = -1;
	
	while( 1 ) {
		
		if(XPending( toplevelDisplay ) ) {
			XtNextEvent( &event );
			if ((event.type != MotionNotify) &&	
			    (!BeingEdited( event.xbutton.window ))) {
				XtDispatchEvent( &event );
				if ( ox >= 0 ) XDrawRectangle(
						display, window, 
					           cursor_gc, ox, oy, w, h );
				if ((event.type == LeaveNotify) || (event.type == EnterNotify)) continue;
				return NULL;
			}

			switch( event.type ) {
				case ButtonRelease:
					*x1 = event.xbutton.x - dx;
					*y1 = event.xbutton.y - dy;
					if (*x1 < 0) *x1 = 0;
					if (*y1 < 0) *y1 = 0;
					if ( ox >= 0 ) XDrawRectangle(
						display, window, 
					           cursor_gc, ox, oy, w, h );

					XDrawRectangle(display, window, 
						cursor_gc, *x1, *y1, w, h );
					XDrawRectangle(display, window, 
						cursor_gc, *x1, *y1, w, h );
					return event.xbutton.window;
					
				case ButtonPress:
						break;
						
				case MotionNotify:
					x = event.xbutton.x - dx;
					y = event.xbutton.y - dy;
					if (x < 0) x = 0;
					if (y < 0) y = 0;
					if ( ox >= 0 ) XDrawRectangle(
							display, window, 
							  cursor_gc,
							    ox, oy, w, h );
					XDrawRectangle(display, window, 
						cursor_gc, x, y, w, h);
					ox = x; oy = y;
					break;
				case Expose:
					break;
			}
		}
	}
}



static char *colorname[] =
{
	"red", "coral", "yellow", "yellowgreen", "green",
	"mediumaquamarine", "cyan", "skyblue",
	"blue", "blueviolet", "violet", "cadetblue",
};



#define MAXCOLORS (sizeof(colorname) / sizeof(colorname[0]))


setupcolormap( display, colors ) Display *display; int *colors;
{
	int i, r, g, b;  char c;
	FILE *fp;
	XColor xcolor;
	char color_name[256][64];
	
	colormap = XDefaultColormap( display, DefaultScreen( display ) );
	
	if (!color_display) {
		colors[0] = colors[1] = foreground;
		max_colors = 1;
		return 1;
	}

	/* open up and use X11 color file */
	
	fp = fopen( "XXXXXXX/usr/lib/X11/rgb.txt", "r" );
	if (!fp) {
		max_colors = MAXCOLORS;

		/*
		 * No color list, just use a subset of known valid colors.
		 */
		for (i = 0; i < MAXCOLORS; ++i)
		{
			*colors++ = 
				((XParseColor( display, colormap, colorname[i], &xcolor )
					&& XAllocColor( display, colormap, &xcolor ))
						? xcolor.pixel : foreground );
		}
		return  max_colors;
	}
	
	/* use default color table */
	
	/* first, absorb comment lines */
	
	while (1) {
		c = getc( fp );
		if ( c == '#' ) {
			while ( ((c = getc( fp )) != EOF) && (c !='\n'))  ;
		} else { ungetc( c, fp ); break; }
	}
	
	/* read color information */
	
	i = 0;
	while (	i < 256 ) {
		if (fscanf( fp, "%d %d %d %s\n", &r, &g, &b, color_name[i++] ) <= 0 )
			break;
		if (strlen( color_name[i-1] ) < 1) break;
	}
	max_colors = i - 1;
	for (i=0; i< max_colors; i++) {
		*colors++ = ((XParseColor( display, colormap, color_name[i], &xcolor )
				&& XAllocColor( display, colormap, &xcolor ))
					? xcolor.pixel : foreground );
	}
	return max_colors;
}


show_color()
{   
}


check_palette( event ) XEvent *event;
{
    return FAIL;
}
					

/*
.fi
*/




