/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */


#include <stdio.h>
#include "qp.h"
#include <X11/Xatom.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#define SUCCESS	1
#define FAIL	0
#define HALT	0


extern GC gc;
extern int mode;		
extern int cur_color;
extern Display *display;

extern Widget workarea;
extern Window work_area_window;


do_filledrect()
{
	int x1, y1, x2, y2;
	Widget widget, BeingEdited();
	Window window, get_two_points_and_window();

	while (window = get_two_points_and_window( &x1, &y1, &x2, &y2 )) {
		
		widget = BeingEdited( window );
		if (!widget) return NULL;
		if (widget != workarea) return NULL;
		
		XSetForeground( display, gc, cur_color );
		XFillRectangle( display, work_area_window, gc, x1, y1, 
						x2-x1+1, y2-y1+1 );


	} 
}

do_rectangle()
{
	int x1, y1, x2, y2;
	Widget widget, BeingEdited();
	Window window, get_two_points_and_window();

	while (window = get_two_points_and_window( &x1, &y1, &x2, &y2 )) {
		
		widget = BeingEdited( window );
		if (!widget) return NULL;
		if (widget != workarea) return NULL;
		
		XSetForeground( display, gc, cur_color );
		XDrawRectangle(display, work_area_window, gc, x1, y1, 
						x2-x1+1, y2-y1+1 );
	} 
}

do_line()
{
	int x1, y1, x2, y2;
	Widget widget, BeingEdited();
	Window window, get_two_points_and_window();

	while (window = get_two_line_points_and_window( &x1, &y1, &x2, &y2 )) {
		
		widget = BeingEdited( window );
		if (!widget) return NULL;
		if (widget != workarea) return NULL;
		
		XSetForeground( display, gc, cur_color );
		XDrawLine(display, work_area_window, gc, x1, y1, x2, y2 );
	} 
}
