/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */


/*
 *	Quick Paint (qp), a simple application to demonstrate
 *      the concepts presented in the talk 
 *	 "Pickling and Embellishing Widgets" 
 *	presented at the 2nd annual X Conference by Richard Carling.
 *	The file inst.c in extensions provides the key XToolkit 
 *	application level extensions mechanism.
 *
 *      This Software is more interesting on Color displays.
 * 
 *	Copyright MASSCOMP  1988
 *
 * 	Author: Richard Carling
 */



/*.
.nf\
*/


#include "qp.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/AsciiText.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Label.h>
#include <X11/Scroll.h>
#include <X11/Shell.h>
#include <X11/VPaned.h>
#include <X11/Viewport.h>

#define NORMAL "8x13"
#define BOLD "8x13bold"
#define ITALIC "8x13"
#define NORMAL "8x13"


#define SUCCESS 1
#define FAIL	0

Display *display = NULL;
Display *toplevelDisplay = NULL;
Window root_window, work_area_window = NULL;
int window_x, window_y;
int window_width, window_height;
GC gc, cursor_gc;
Colormap colormap;
int colors[1024];
int screen, depth;
int cur_color = 0;
XColor xcolor;
char program_name[32];
int color_display = 0;
long foreground, background;
int max_colors;

int mode= 0;
int width_current_color;

Widget toplevel = NULL;
Widget XtInitialize();
Widget workarea = NULL, GetSubChildByName();

static XrmOptionDescRec options[] = {
{"-label",	XtNlabel,	XrmoptionSepArg,	NULL}
};


main( argc, argv ) int argc; char **argv;
{
    int i, geom_mask;
    char *bc_name, *fc_name, *geom;
    Font font;
    XEvent event;
    Visual visual;
    XSetWindowAttributes attributes;
    XGCValues gcvalues;
    unsigned int UI_event_mask;
    
    Widget box, shell, label, button, pbox, standby1, standby2;
    Arg arglist[10]; Cardinal num_args;
    
    
    strcpy( program_name, argv[0] );
    
    toplevel = XtInitialize( "edit", "edit", 
				options, XtNumber(options), &argc, argv );

    if (!toplevel) {
	fprintf( stderr, "Can't create toplevel user interface widget\n");
	exit();
    }
    toplevelDisplay = display = XtDisplay( toplevel );
    screen = DefaultScreen( display );
    depth = DefaultDepth( display, screen);
    
    /*
     * Set up user color defaults.
     */

    colormap = XDefaultColormap( display, screen );
    
    foreground = WhitePixel( display, screen );
    background = BlackPixel( display, screen );

    color_display = 0;
    if ( XDisplayCells( display, screen ) > 2) color_display = 1;

printf("Number of colors is %d\n", XDisplayCells( display, screen ));

    visual.visualid = CopyFromParent;
    attributes.background_pixel = background;
    attributes.border_pixel = foreground;
    attributes.backing_store = Always;

    font = XLoadFont( display, "fixed" ); 
    
    setupcolormap( display, colors ); 
    
    /* register display list handlers */
    
    init_instructions( display );
    
    /* generate the user interface */
    
    UI_event_mask = load_uims( toplevel );  

    /*
     * retrieve the work area obedient window
     */
/*
     this Xt routine only goes one level of Decendents, can't use it.
     workarea = XtNameToWidget( toplevel, "workarea" );
     so we use
 */
    workarea = GetSubChildByName( toplevel, "workarea" );
 

    if (!workarea) {
	printf("Can't get work area  obedient \"workarea\"\n");
	exit();
    }
    /* we register the work area, as well as special case it in places */

    RegisterWidget( workarea );

    work_area_window =  XtWindow( workarea );
    
    XSelectInput( display, work_area_window, (unsigned long)
    		KeyPressMask | KeyReleaseMask | ButtonPressMask
			| ButtonReleaseMask | ButtonMotionMask
				| ExposureMask | UI_event_mask 
		                     | MapNotify | VisibilityNotify);
				
    gcvalues.foreground = foreground;
    gcvalues.background = background;

    gcvalues.function = GXcopy;
/*    if (color_display) gcvalues.function = GXcopy;
      else gcvalues.function = GXinvert;
*/
    gcvalues.line_width = 0;
    gcvalues.font = font;
    
    XFlush( display );
    root_window = XtWindow( toplevel );
    gc = XCreateGC( display, root_window, GCFont | GCFunction | GCForeground
		   | GCBackground | GCLineWidth,
		   &gcvalues);
		   
		   
    gcvalues.foreground = 1;
    gcvalues.background = background;
    gcvalues.function = GXxor;
    gcvalues.line_width = 0;
    gcvalues.font = font;
    
    cursor_gc = XCreateGC( display, root_window, GCFont | GCFunction | GCForeground
		   | GCBackground | GCLineWidth,
		   &gcvalues);
		   
    
    XSetFillStyle( display, gc, FillSolid );
    XSetForeground( display, gc, foreground ); 
    XFlush( display );
    
    if (color_display) {
          cur_color = 7;
	  show_color();
	} else cur_color = 1;
    	
    /*
     * event loop for the commands supported by this simple editor
     */
    
     	while (1) {
		
	        if (mode == LINE) do_line();
		if (mode == RECTANGLE) do_rectangle();
		if (mode == FILLED_RECTANGLE) do_filledrect();

		if(XPending( toplevelDisplay ) ) {
			XtNextEvent( &event );
			XtDispatchEvent( &event );
		}
	}
}


line_cmd() { mode = LINE; }
rectangle_cmd() { mode = RECTANGLE; }
filled_rectangle_cmd() { mode = FILLED_RECTANGLE; }
exit_cmd() { exit(); }


advance_color()
{
}

