/*
 *			  COPYRIGHT 1988
 *	    MASSACHUSETTS COMPUTER CORPORATION (MASSCOMP)
 *		       WESTFORD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 *		       Author: Richard Carling
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY MASSCOMP CORPORATION.
 * MASSCOMP MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT 
 * RIGHTS, APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN 
 * ADDITION TO THAT SET FORTH ABOVE.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that the
 * copyright notice, and this permission notice appear in 
 * supporting documentation.
 */


/*
 *	Cheapo Edit, a simple application to demonstrate
 *      the concepts presented in the talk 
 *	 "Pickling and Embellishing Widgets" 
 *	presented at the 2nd annual X Conference by Richard Carling.
 *	The file inst.c in ../extensions provides the key XToolkit 
 *	application level extensions mechanism.
 *
 *      This Software is more interesting on color displays
 * 
 *	Copyright MASSCOMP  1988
 * 	Author: Richard Carling
 */



/*.
.nf\
*/


#include "editor.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/AsciiText.h>
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Label.h>
#include <X11/Scroll.h>
#include <X11/Shell.h>
#include <X11/VPaned.h>
#include <X11/Viewport.h>

#define NORMAL "8x13"
#define BOLD "8x13bold"
#define ITALIC "8x13"
#define NORMAL "8x13"

XFontStruct *bold, *normal, *italic;
static XtResource edit_resources[] = {
  {"manualFontNormal", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     (Cardinal) &normal, XtRString, NORMAL},
  {"manualFontBold", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     (Cardinal) &bold, XtRString, BOLD},
  {"manualFontItalic", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
     (Cardinal) &italic, XtRString, ITALIC},
     
/*
  {"helpCursor", XtCCursor, XtRCursor, sizeof(Cursor),
     (Cardinal) &(cursors.help), XtRString, HELP_CURSOR} */
};


#define SUCCESS 1
#define FAIL	0


Display *display;
Display *toplevelDisplay;
Window root_window, work_area_window = NULL;
int window_x, window_y;
int window_width, window_height;
GC gc, cursor_gc;
Colormap colormap;
int colors[1024];
int screen, depth;
int cur_color = 0;
XColor xcolor;
char program_name[32];
int color_display = 0;
long foreground, background;
int max_colors;

int mode= 0;
int width_current_color;

Widget toplevel = NULL;
Widget XtInitialize();
Widget workarea = NULL, GetSubChildByName();

static XrmOptionDescRec options[] = {
{"-label",	XtNlabel,	XrmoptionSepArg,	NULL}
};


main( argc, argv ) int argc; char **argv;
{
    int i, geom_mask;
    char *bc_name, *fc_name, *geom;
    Font font;
    XEvent event;
    Visual visual;
    XSetWindowAttributes attributes;
    XGCValues gcvalues;
    unsigned int UI_event_mask;
    
    Widget box, shell, label, button, pbox, standby1, standby2;
    Arg arglist[10]; Cardinal num_args;
    
    
    strcpy( program_name, argv[0] );
    
    toplevel = XtInitialize( "edit", "edit", 
				options, XtNumber(options), &argc, argv );

    if (!toplevel) {
	fprintf( stderr, "Can't create toplevel user interface widget\n");
	exit();
    }
    toplevelDisplay = display = XtDisplay( toplevel );
    screen = DefaultScreen( display );
    depth = DefaultDepth( display, screen);
    
    /*
     * Set up user color defaults.
     */

    colormap = XDefaultColormap( display, screen );
    
    foreground = WhitePixel( display, screen );
    background = BlackPixel( display, screen );

    color_display = 0;
    if ( XDisplayCells( display, screen ) > 2) color_display = 1;
/*
printf("Number of colors is %d\n", XDisplayCells( display, screen ));
*/
    visual.visualid = CopyFromParent;
    attributes.background_pixel = background;
    attributes.border_pixel = foreground;
    attributes.backing_store = Always;

    font = XLoadFont( display, "fixed" ); 
    
    setupcolormap( display, colors ); 
    
    /* register display list handlers */
    
    init_instructions( display );
    
    /* generate the user interface */
    
    UI_event_mask = load_uims( toplevel );  

    XFlush( display );

    geom = NULL;
    if (geom)
    {
	geom_mask = XParseGeometry( geom, &window_x, &window_y,
			&window_width, &window_height);
	if (geom_mask & XNegative) window_x += window_width;
	if (geom_mask & YNegative) window_y += window_height;
    }

    /*
     * retrieve the work area obedient window
     */
/*
     this Xt routine only goes one level of Decendents, can't use it.
     workarea = XtNameToWidget( toplevel, "workarea" );
     so we use
 */
    workarea = GetSubChildByName( toplevel, "workarea" );
 

    if (!workarea) {
	printf("Can't get work area  obedient \"workarea\"\n");
	exit();
    }
    /* we register the work area, as well as special case it in places */

    RegisterWidget( workarea );

    work_area_window =  XtWindow( workarea );
    
/*    event_mast =  (unsigned long) KeyPressMask | KeyReleaseMask | ButtonPressMask
			| ButtonReleaseMask | ButtonMotionMask
				| ExposureMask | UI_event_mask 
		                     | MapNotify | VisibilityNotify;
    XtAddEventHandler( workarea, event_mask, */
/*  XSelectInput( display, work_area_window, event_mask ); */
				
    gcvalues.foreground = foreground;
    gcvalues.background = background;

    gcvalues.function = GXcopy;
/*    if (color_display) gcvalues.function = GXcopy;
      else gcvalues.function = GXinvert;
*/
    gcvalues.line_width = 0;
    gcvalues.font = font;
    
    XFlush( display );
    root_window = XtWindow( toplevel );
    gc = XCreateGC( display, root_window, GCFont | GCFunction | GCForeground
		   | GCBackground | GCLineWidth,
		   &gcvalues);
		   
		   
    gcvalues.foreground = 1;
    gcvalues.background = background;
    gcvalues.function = GXxor;
    gcvalues.line_width = 0;
    gcvalues.font = font;
    
    cursor_gc = XCreateGC( display, root_window, GCFont | GCFunction | GCForeground
		   | GCBackground | GCLineWidth,
		   &gcvalues);
		   
    
    XSetFillStyle( display, gc, FillSolid );
    XSetForeground( display, gc, foreground ); 
    XFlush( display );
    
    if (color_display) {
          cur_color = 7;
	  show_color();
	} else cur_color = 1;
    	
    /*
     * event loop for the commands supported by this simple editor
     */
    
     	while (1) {
		
		if (mode == MAKE_DLOBEDIENT) do_make_obedient();
		if (mode == MAKE_DLCOMMAND) do_make_command();
		if (mode == MAKE_DLLABEL) do_make_label();
		
		if (mode == MAKE_OBEDIENT) do_make_obedient();
		if (mode == MAKE_COMMAND) do_make_command();
		if (mode == MAKE_LABEL) do_make_label();
		
		if (mode == COPY_WIDGET) do_copy_widget();
		if (mode == MOVE_WIDGET) do_move_widget();
		if (mode == RESIZE_WIDGET) do_resize_widget();
		if (mode == RENAME_WIDGET) do_rename_widget(); 
		if (mode == DELETE_WIDGET) do_delete_widget();
		
		if (mode == LOAD_WIDGET) do_load_widget();
		if (mode == SAVE_WIDGET) do_save_widget();
		if (mode == RELABEL_WIDGET) do_relabel_widget();
		if (mode == RECALLBACK_WIDGET) do_change_callback();
		
		if (mode == LINE) do_line();
		if (mode == RECTANGLE) do_rect();
		if (mode == FILLED_RECTANGLE) do_filledrect();
		if (mode == TEXT) do_text();

		/* handle toolkit events */

		if(XPending( toplevelDisplay ) ) {
			XtNextEvent( &event );
			XtDispatchEvent( &event );
		}
	}
}

/*
 *   We chose an internal model of the user interface returning
 *   a key which identifies the toplevel routine.
 *   The following routines map routines into this set of keys.
 *   We could have used one routine and a multitude of calldata values
 *   but users generally find it easier to think of each operation
 *   as having a routine associated with it. Since we don't want the user interface
 *   to directly call the actual routines, these routines hide
 *   some implementation details for the benefit of the widget editor user.
 */

make_toplevel_obedient_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = MAKE_TOPLEVEL_OBEDIENT;
}

make_dlobedient_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = MAKE_DLOBEDIENT;
}

make_obedient_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = MAKE_OBEDIENT;
}

make_command_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = MAKE_COMMAND;
}

make_label_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = MAKE_LABEL;
}


load_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = LOAD_WIDGET;
}

save_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = SAVE_WIDGET;
}

move_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = MOVE_WIDGET;
}

copy_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = COPY_WIDGET;
}

resize_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = RESIZE_WIDGET;
}

rename_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = RENAME_WIDGET;
}

delete_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = DELETE_WIDGET;
}


recallback_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = RECALLBACK_WIDGET;
}

relabel_widget_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = RELABEL_WIDGET;
}



line_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = LINE;
}

void linerect_cmd( widget,closure,callData )
char *widget;
char *closure;
char *callData;
{
	mode = LINERECT;
}

void linefrect_cmd( widget,closure,callData )
char *widget;
char *closure;
char *callData;
{
	mode = LINEFILLRECT;
}

rectangle_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = RECTANGLE;
}

filled_rectangle_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = FILLED_RECTANGLE;
}

text_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	mode = TEXT;
}

exit_cmd( widget,closure,calldata )
char *widget;
char *closure;
char *calldata;
{
	handle_exit();
}

/* set up a 3-3-2 color map */

setup332colormap(  )
{
	int i, r, g, b;
	XColor xcolor;

	Colormap cmap, XCreateColormap();

	/* create a full color map */
	
	cmap = XCreateColormap( display, root_window, 
				DefaultVisual( display, 0), AllocAll );
	
	/*
	 * Initialize to rgb 332 allocation
	 */
	for (i=0; i<256; i++) {
		r = i & 07;
		g = (i>>3) & 07;
		b = (i>>6) & 03;
		r = r << 13;
		g = g << 13;
		b = b << 14;
		xcolor.red = r;
		xcolor.green = g;
		xcolor.blue = b;
		xcolor.pixel = i;
		xcolor.flags = DoRed | DoGreen | DoBlue;
		XStoreColors( display, cmap, &xcolor, 1);
	}
	/*
	 * and install
	 */
	XInstallColormap( display, cmap );
	max_colors = 256;
	return  256;
}



handle_exit()
{
	exit();
}



