


#ifndef lint
static char *rcsid_Icons_c = "$Header: Icons.c,v 1.3 88/07/23 17:24:56 jkh Exp $";
#endif  lint

#include "X11/copyright.h"
/*
 *
 * Copyright 1987, 1988 by Ardent Computer Corporation, Sunnyvale, Ca.
 *
 * Copyright 1987 by Jordan Hubbard.
 *
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Ardent Computer
 * Corporation or Jordan Hubbard not be used in advertising or publicity
 * pertaining to distribution of the software without specific, written
 * prior permission.
 *
 */

/*
 * Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.
 *
 *                         All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.
 *
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */


 
/*
 * MODIFICATION HISTORY
 *
 * 000 -- L. Guarino Reid, DEC Ultrix Engineering Group
 * 001 -- Jordan Hubbard, Ardent Computer
 *  Many modifications for titled windows.
 * 1.2 -- Jordan Hubbard, Ardent Computer.
 * vPad and hPad usage corrected (Chris Thewalt fix).
 * Clipping now set on right GC. 
 * 1.3 -- Changed the way icon button events are handled.
 */
 
#include "awm.h"
#include "X11/Xutil.h"

extern XContext AwmContext;

/* the client should pass us a bitmap (single-plane pixmap with background=0
 * and foreground = 1).  It is our responsibility to convert it to a pixmap
 * of the appropriate depth for a window tile and also color it with the
 * appropriate background and foreground pixels.
 *
 * we'll use the (global) IconGC for the fore/background pixels.
 */

static Pixmap MakePixmapFromBitmap( bitmap, clipmask, width_return, height_return )
Pixmap bitmap, clipmask;
unsigned int *width_return, *height_return;
{
     Pixmap tile;
     Window junkW;
     int junk, width, height;
     GC iGC;
     XGCValues gcv;
     
     Entry("MakePixmapFromBitmap")
	  
     if (!XGetGeometry( dpy, bitmap, &junkW, &junk, &junk,
		       &width, &height, &junk, &junk )) {
	  Warning( "client passed invalid pixmap for icon." );
	  Leave( NULL )
     }
     tile = XCreatePixmap( dpy, RootWindow(dpy, scr), width, height,
			  DefaultDepth(dpy, scr) );
     gcv.foreground = ITextForeground;
     gcv.background = ITextBackground;
     iGC = XCreateGC(dpy, RootWindow(dpy, scr), (GCForeground | GCBackground),
		     &gcv);
     if (clipmask)
	  XSetClipMask(dpy, iGC, clipmask);
     XCopyPlane(dpy, bitmap, tile, iGC, 0, 0, width, height, 0, 0, 1 );
     XFreeGC(dpy, iGC);
     if (width_return)
	  *width_return = width;
     if (height_return)
	  *height_return = height;
     Leave(tile)
}

char *GetIconName(window)
Window window;
{
     char *name;
     Status status;
     long len, after;
     Atom a_type;
     int a_form;
     
     Entry("GetIconName")
     
     status = XGetWindowProperty(dpy, window, XA_WM_ICON_NAME, 0, 256,
				 False, XA_STRING, &a_type, &a_form, &len, &after,
				 &name);
     
     if (status != Success) {
	  status = XGetWindowProperty(dpy, window, XA_WM_NAME, 0, NAME_LEN,
				      False, XA_STRING, &a_type, &a_form, &len,
				      &after, &name);
	  if (status != Success)
	       Leave((char *)NULL)
     }
     if (a_form == 0)	/* we have no bananas */
	  Leave((char *)NULL)
     if (a_form != 8) {
	  Warning("Window has icon_name in wrong format");
	  if (name)
	       free(name);
	  Leave((char *)NULL)
     }
     if (len > NAME_LEN) {
	  Warning("Window has icon_name greater than maximum length");
	  len = NAME_LEN;
     }
     if (!len)
	  Leave((char *)NULL)
     name[len] = 0;
     Leave(name)
}

Boolean IsIcon(icon, win)
Window icon;
Window *win;
{
     AwmInfoPtr awi;

     Entry("IsIcon")

     if (win)
	  *win = 0;
     awi = GetAwmInfo(icon);
     if (!awi)
	  Leave(FALSE)
     if (awi->icon == icon) {
	  if (win)
	       *win = awi->client;
	  Leave(TRUE)
     }
     else if (awi->client == icon || awi->frame == icon) {
	  if (win)
	       *win = awi->icon;
	  Leave(FALSE)
     }
     Leave(FALSE)
}

RemoveIcon(window)
Window window;
{
     AwmInfoPtr awi;

     Entry("RemoveIcon")
     
     if ((awi = GetAwmInfo(window)) != NULL) {
	  XDeleteContext(dpy, awi->icon, AwmContext);
	  if (awi->own) {
	       XDestroyWindow(dpy, awi->icon);
	       if (awi->iconPixmap != IBackPixmap)
		    XFreePixmap(dpy, awi->iconPixmap);
	  }
	  awi->icon = (Drawable)NULL;
	  awi->state ^= ST_ICON;
	  awi->state |= ST_WINDOW;
     }
     Leave_void
}

GetDefaultSize(window, icon_w, icon_h)
Window window;
int *icon_w, *icon_h;
{
     char *name;				/* Event window name. */

     Entry("GetDefaultSize")

     /*
      * Determine the size of the icon window.
      */ 
     name = GetIconName(window);
     *icon_h = IFontInfo->ascent + IFontInfo->descent;
     if (name) {
	  *icon_w = XTextWidth(IFontInfo, name, strlen(name));
	  if (*icon_w == 0)
	       *icon_w = *icon_h;
     }
     else 
	  *icon_w = *icon_h;
     Leave_void
}

Window MakeIcon(window, x, y, mousePositioned)
Window window;                          /* associated window. */
int x, y;                               /* Event mouse position. */
Boolean mousePositioned;
{
     Window icon;			/* icon window. */
     int icon_x, icon_y;		/* Icon U. L. X and Y coordinates. */
     int icon_w, icon_h;		/* Icon width and height. */
     int icon_bdr;			/* Icon border width. */
     int mask;				/* Icon event mask */
     int depth;				/* for XGetGeometry */
     XSetWindowAttributes iconValues;	/* for icon window creation */
     unsigned long iconValues_mask;	/* for above */
     XWMHints *wmhints;			/* see if icon position provided */
     XWMHints *XGetWMHints();
     Pixmap clip = 0;
     Window AddIcon();

     Entry("MakeIcon")

     iconValues.background_pixmap = IBackPixmap;
     mask = (ExposureMask | StructureNotifyMask | KeyPressMask);
     /*
      * Process window manager hints.
      */ 
     if (wmhints = XGetWMHints(dpy, window)) {
	  if (wmhints->flags & IconWindowHint)
	       Leave(AddIcon(window, wmhints->icon_window, FALSE,
			     (StructureNotifyMask), (Pixmap)NULL))
	  else if (wmhints->flags & IconPixmapHint) {
	       if (wmhints->flags & IconMaskHint)
		    clip = wmhints->icon_mask;
	       iconValues.background_pixmap =
		    MakePixmapFromBitmap(wmhints->icon_pixmap, clip,
					 &icon_w, &icon_h );
	       if (iconValues.background_pixmap)
		    mask = (StructureNotifyMask);
	       else {
		    iconValues.background_pixmap = IBackPixmap;
		    wmhints->flags &= ~IconPixmapHint;
		    GetDefaultSize(window, &icon_w, &icon_h);
	       }
	  }
	  else GetDefaultSize(window, &icon_w, &icon_h);
     }
     else GetDefaultSize(window, &icon_w, &icon_h);

     /*
      * Fix up sizes by padding.
      */
     if (!wmhints || !(wmhints->flags & (IconPixmapHint|IconWindowHint))) {
	  icon_w += (HIconPad);
	  icon_h += (VIconPad);
     }

     /*
      * Set the icon border attributes.
      */ 
     if (!wmhints || !(wmhints->flags & IconWindowHint)) {
	  icon_bdr = IBorderWidth;
	  iconValues.border_pixel = IBorder;
     }
 
     if (wmhints && (wmhints->flags & IconPositionHint)) {
	  icon_x = wmhints->icon_x;
	  icon_y = wmhints->icon_y;
     } else {
	  if (mousePositioned) {
	       /*
		* Determine the coordinates of the icon window;
		* normalize so that we don't lose the icon off the
		* edge of the screen.
		*/
	       icon_x = x - (icon_w >> 1) + 1;
	       if (icon_x < 0) icon_x = 0;
	       icon_y = y - (icon_h >> 1) + 1;
	       if (icon_y < 0) icon_y = 0;
	       if ((icon_x - 1 + icon_w + (icon_bdr << 1)) > ScreenWidth) {
		    icon_x = ScreenWidth - icon_w - (icon_bdr << 1) + 1;
	       }
	       if ((icon_y - 1 + icon_h + (icon_bdr << 1)) > ScreenHeight) {
		    icon_y = ScreenHeight - icon_h - (icon_bdr << 1) + 1;
	       }
	  }
	  else {
	       icon_x = x + (icon_w >> 1);
	       icon_y = y + (icon_y >> 1);
	  }
	  
     }
     
     /*
      * Create the icon window.
      */
     iconValues_mask = CWBorderPixel | CWBackPixmap;
     /*
      * Here we assume that if they want save unders, they'll also want
      * backing store on the icons. Perhaps a dangerous assumption, but
      * one we have to make at this point.
      */
     if (SaveUnder) {
	  iconValues.backing_store = WhenMapped;
	  iconValues_mask |= CWBackingStore;
     }
     Leave(AddIcon(window,
		   XCreateWindow(
				 dpy, RootWindow(dpy, scr),
				 icon_x, icon_y,
				 icon_w, icon_h,
				 icon_bdr, 0, CopyFromParent, CopyFromParent,
				 iconValues_mask, &iconValues),
		   TRUE, mask, iconValues.background_pixmap))
	  
}

Window AddIcon(window, icon, own, mask, background)
Window window, icon;
Boolean own;
int mask;
Pixmap background;
{
     Binding *bptr;
     AwmInfoPtr awi;

     Entry("AddIcon")

     if (icon == NULL)
	  Leave(NULL)
     /*
      * Use the text cursor whenever the mouse is in the icon window.
      */
     XDefineCursor(dpy, icon, TextCursor);
     
     /*
      * Select "key pressed", "window exposure" and "unmap window"
      * events for the icon window.
      */
     XSelectInput(dpy, icon, mask | ButtonPressMask | ButtonReleaseMask);

     awi = GetAwmInfo(window);
     awi->icon = icon;
     awi->own = own;
     awi->iconPixmap = background;
     XSaveContext(dpy, icon, AwmContext, awi);
     Leave(icon)
}
