/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */
/* $Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcCmap.c,v 6.5 89/03/01 15:55:22 paul Exp $ */
/* $Source: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcCmap.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/release/server/ddx/ibm/ibm8514/RCS/brcCmap.c,v 6.5 89/03/01 15:55:22 paul Exp $" ;
#endif

#include "X.h"
#include "screenint.h"
#include "scrnintstr.h"

#include "OScompiler.h"

#include "x8514.h"

#include "ibmTrace.h"

extern int ibm8514NumberOfPlanes ;

void
ibm8514SetColor( number, r, g, b, pVisual )
register unsigned long int number ;
register unsigned short int r, g, b ;
VisualPtr pVisual ;
{
TRACE( ( "ibm8514SetColor(num=%d,r=%d,g=%d,b=%d)\n", number, r, g, b ) ) ;

	if ( number > pVisual->ColormapEntries )
		return ;

	r >>= 10 ;
	g >>= 10 ; /* only top 6 bits sent to 8514 */
	b >>= 10 ;

	if ( ibm8514NumberOfPlanes == 8 ) {
		/* FOLLOWING OPS ARE BYTE OUTS!!! */
		ibm8514ClearQueue( 5 ) ;
		outb( PALWRITE_ADDR, number ) ;
		outb( PALMASK, 0xFFFF ) ;   /* enable all color bits */
		outb( PALDATA, (unsigned char) r ) ;
		outb( PALDATA, (unsigned char) g ) ;
		outb( PALDATA, (unsigned char) b ) ;
	}
	else {
		register unsigned int top ;
		for ( top = 0 ; top < 16 ; top++ ) {
			ibm8514ClearQueue( 5 ) ;
			outb( PALWRITE_ADDR, ( top << 4 ) + number ) ;
			outb( PALMASK, 0xFFFF ) ;   /* enable all color bits */
			outb( PALDATA, (unsigned char) r ) ;
			outb( PALDATA, (unsigned char) g ) ;
			outb( PALDATA, (unsigned char) b ) ;
		}
	}
	return ;
}
