/*
 * Copyright IBM Corporation 1987,1990
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that 
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
*/
/*
 * PRPQ 5799-PFF (C) COPYRIGHT IBM CORPORATION 1987,1990
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 *  Hardware interface routines for IBM 8514/A adapter for
 *  X.11 server(s) on IBM equipment.
 *
 */

/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcDLine.c,v 6.2 88/11/16 18:44:54 paquin Exp $ */
/* $Source: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcDLine.c,v $ */

#ifndef lint
static char *rcsid = "$Header: /andrew/X11/r3src/earlyRelease/server/ddx/ibm/ibm8514/RCS/brcDLine.c,v 6.2 88/11/16 18:44:54 paquin Exp $";
#endif


#include "X.h"

#include "misc.h"
#include "gcstruct.h"
#include "gc.h"
#include "pixmap.h"
#include "window.h"
#include "windowstr.h"
#include "pixmapstr.h"
#include "regionstr.h"
#include "scrnintstr.h"
#include "mistruct.h"

#include "mfb.h"
#include "ppc.h"
#include "ppcUtils.h"

#include "x8514.h"

/* ibm8514 dashed line
 *
 */

extern void ibm8514BresDash();
extern void ibm8514HorzDash();
extern void ibm8514VertDash();
extern void ibm8514BresLineStart();
extern void ibm8514BresLineCont();
extern void ibm8514BresLineStop();

extern void ibm8514HorzDashPat();
extern void ibm8514BresDashPat();

#define X_AXIS 0

extern int mergexlate[];
extern int ibm8514cursorSemaphore ;

/* NOTE
   maybe OUTCODES should take box (the one that includes all
edges) instead of pbox (the standard no-right-or-lower-edge one)?
*/
#define OUTCODES(result, x, y, pbox) \
    if (x < pbox->x1) \
	result |= OUT_LEFT; \
    else if (x >= pbox->x2) \
	result |= OUT_RIGHT; \
    if (y < pbox->y1) \
	result |= OUT_ABOVE; \
    else if (y >= pbox->y2) \
	result |= OUT_BELOW;

void
ibm8514ZeroDash(pDrawable, pGC, mode, npt, pptInit)
    DrawablePtr pDrawable;
    GCPtr pGC;
    int mode;		/* Origin or Previous */
    int npt;		/* number of points */
    DDXPointPtr pptInit;
{
    int nboxInit;
    register int nbox;
    BoxPtr pboxInit;
    register BoxPtr pbox;
    int nptTmp;
    DDXPointPtr ppt;		/* pointer to list of translated points */

    DDXPointRec pt1;
    DDXPointRec pt2;

    unsigned int oc1;		/* outcode of point 1 */
    unsigned int oc2;		/* outcode of point 2 */

    int xorg, yorg;		/* origin of window */

    int adx;		/* abs values of dx and dy */
    int ady;
    int signdx;		/* sign of dx and dy */
    int signdy;
    int e, e1, e2;		/* bresenham error and increments */
    int len;			/* length of segment */

    int clipDone;		/* flag for clipping loop */
    DDXPointRec pt1Orig;	/* unclipped start point */
    DDXPointRec pt2Orig;	/* unclipped end point */
    int err;			/* modified bresenham error term */
    int clip1, clip2;		/* clippedness of the endpoints */

    int alu ;			/* Screen Raster-Op value */
    long fg ;			/* foreground Pixel value */
    long bg ;			/* background Pixel value */
    unsigned long pm ;			/* plane mask */
    register int tmp;
    int x1, x2, y1, y2;
				/* a bunch of temporaries */
    void (* scrnFunc)();
#ifdef notyet
    int hardware_pat =
	((ibm8514GCPrivPtr)(pGC->devPriv))->flags & HARDWARE_PAT;
#endif

    if ( pDrawable->type != DRAWABLE_WINDOW )
    {
	ErrorF("ibm8514ZeroDash: not a window\n");
	return;
    }

    switch ( ( (ppcPrivGC *) pGC->devPriv )->colorRrop.fillStyle ) {
	case FillStippled :
	case FillSolid : /* Can Use Optimized Color Raster-Op */
	    alu = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.alu ;
	    pm = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.planemask ;
	    if(pGC->lineStyle == LineOnOffDash){
		ibm8514ClearQueue(1);
		SETCOL1( ( (ppcPrivGC *) pGC->devPriv )->colorRrop.fgPixel) ;
	    } else {
	    	fg = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.fgPixel ;
	    	bg = ( (ppcPrivGC *) pGC->devPriv )->colorRrop.bgPixel ;
	    }
	    break ;
	case FillOpaqueStippled :
	case FillTiled : /* Can't Use Optimized Color Raster-Op */
	    alu = pGC->alu ;
	    pm = pGC->planemask ;
	    if(pGC->lineStyle == LineOnOffDash){
		ibm8514ClearQueue(1);
		SETCOL1(pGC->fgPixel);
	    } else {
	    	fg = pGC->fgPixel ;
	    	bg = pGC->bgPixel ;
	    }
	    break ;
    }
    if ( alu == GXnoop )
	return ;

    pboxInit = ((mfbPrivGC *)(pGC->devPriv))->pCompositeClip->rects;
    nboxInit = ((mfbPrivGC *)(pGC->devPriv))->pCompositeClip->numRects;

    xorg = ((WindowPtr)pDrawable)->absCorner.x;
    yorg = ((WindowPtr)pDrawable)->absCorner.y;

    /* translate the point list */
    ppt = pptInit;
    nptTmp = npt;
    if (mode == CoordModeOrigin)
    {
	while(nptTmp--)
	{
	    ppt->x += xorg;
	    ppt++->y += yorg;
	}
    }
    else
    {
	ppt->x += xorg;
	ppt->y += yorg;
	nptTmp--;
	while ( nptTmp-- )
	{
	    ppt++;
	    ppt->x += (ppt-1)->x;
	    ppt->y += (ppt-1)->y;
	}
    }

    ppt = pptInit;
    while ( --npt )
    {
	nbox = nboxInit;
	pbox = pboxInit;

	pt1 = *ppt++;
	pt2 = *ppt;

	if ( !( adx = ( pt2.x - pt1.x ) ) )
	{
	    /* make the line go top to bottom of screen, keeping
	       endpoint semantics
	    */
	    if ( pt1.y > pt2.y )
	    {
		tmp = pt2.y;
		pt2.y = pt1.y + 1;
		pt1.y = tmp + 1;
	    }

	    /* get to first band that might contain part of line */
	    while ((nbox) && (pbox->y2 <= pt1.y))
	    {
		pbox++;
		nbox--;
	    }

	    if ( nbox )
	    {
		/* stop when lower edge of box is beyond end of line */
		while ( ( nbox ) && ( pt2.y >= pbox->y1 ) ) {
		    if ( ( pt1.x >= pbox->x1 ) && ( pt1.x < pbox->x2 ) ) {
			/* this box has part of the line in it */
			if ( ( y1 = MAX( pt1.y, pbox->y1 ) )
			  != ( y2 = MIN( pt2.y, pbox->y2 ) ) ) {
			    ibm8514VertDash( pGC, fg, bg,
				alu, pm, pt1.x, y1, y2 - y1 ) ;
			}
		    }
		    nbox--;
		    pbox++;
		}
	    }

	}
	else if ( !( ady = ( pt2.y - pt1.y ) ) )
	{
	    /* force line from left to right, keeping
	       endpoint semantics
	    */
	    if (pt1.x > pt2.x)
	    {
		tmp = pt2.x;
		pt2.x = pt1.x + 1;
		pt1.x = tmp + 1;
	    }

	    /* find the correct band */
	    while( nbox && (pbox->y2 <= pt1.y))
	    {
		pbox++;
		nbox--;
	    }

	    /* try to draw the line, if we haven't gone beyond it */
	    if ((nbox) && (pbox->y1 <= pt1.y))
	    {
		/* when we leave this band, we're done */
		tmp = pbox->y1;
		while((nbox) && (pbox->y1 == tmp))
		{
		    if (pbox->x2 <= pt1.x)
		    {
			/* skip boxes until one might contain start point */
			nbox--;
			pbox++;
			continue;
		    }

		    /* stop if left of box is beyond right of line */
		    if (pbox->x1 >= pt2.x)
		    {
			nbox = 0;
			continue;
		    }
		    if ( ( x1 = MAX( pt1.x, pbox->x1 ) )
		      != ( x2 = MIN( pt2.x, pbox->x2 ) ) ) {
#ifdef notyet
			    if(hardware_pat)
			    	ibm8514HorzDashPat( pGC, fg, bg,
					alu, pm, x1, pt1.y, x2 - x1 ) ;
			    else
#endif
			    	ibm8514HorzDash( pGC, fg, bg,
					alu, pm, x1, pt1.y, x2 - x1 ) ;
		    }
		    nbox--;
		    pbox++;
		}
	    }
	}
	else	/* sloped line */
	{
	    signdx = sign(adx);
	    signdy = sign(ady);
	    adx = ABS(adx);
	    ady = ABS(ady);

	    if (adx > ady)
	    {
		e1 = ady*2;
		e2 = e1 - 2*adx;
		e = e1 - adx;

	    }
	    else
	    {
		e1 = adx*2;
		e2 = e1 - 2*ady;
		e = e1 - ady;
	    }

	    /* we have bresenham parameters and two points.
	       all we have to do now is clip and draw.
	    */

	    pt1Orig = pt1;
	    pt2Orig = pt2;

	    while(nbox--)
	    {

		BoxRec box;

		pt1 = pt1Orig;
		pt2 = pt2Orig;
		clipDone = 0;
		box.x1 = pbox->x1;
		box.y1 = pbox->y1;
		box.x2 = pbox->x2-1;
		box.y2 = pbox->y2-1;
		clip1 = 0;
		clip2 = 0;

		oc1 = 0;
		oc2 = 0;
		OUTCODES(oc1, pt1.x, pt1.y, pbox);
		OUTCODES(oc2, pt2.x, pt2.y, pbox);

		if (oc1 & oc2)
		    clipDone = -1;
		else if ((oc1 | oc2) == 0)
		    clipDone = 1;
		else /* have to clip */
		    clipDone = mfbClipLine(pbox, box,
					   &pt1Orig, &pt1, &pt2, 
					   adx, ady, signdx, signdy,
					   ( ( adx > ady ) ? X_AXIS : Y_AXIS ),
					   &clip1, &clip2);

		if (clipDone == -1)
		{
		    pbox++;
		}
		else
		{
		    if ( adx > ady )
			len = ABS(pt2.x - pt1.x);
		    else
			len = ABS(pt2.y - pt1.y);

		    len += (clip2 != 0);
		    if (len)
		    {
			/* unwind bresenham error term to first point */
			if (clip1)
			{
			    if ( adx > ady )
			        err = e
				    + ( ABS( pt1.y - pt1Orig.y ) * ( e2 - e1 ) )
				    + ( ABS( pt1.x - pt1Orig.x ) * e1 ) ;
			    else
			        err = e
				    + ( ABS( pt1.x - pt1Orig.x ) * ( e2 - e1 ) )
				    + ( ABS( pt1.y - pt1Orig.y ) * e1 ) ;
			}
			else
			    err = e;
			ibm8514BresDash( pGC, fg, bg, alu, pm,
				      signdx, signdy,
				      ( ( adx > ady ) ? X_AXIS : Y_AXIS ),
				      pt1.x, pt1.y, err, e1, e2, len ) ;
		    }

		    /* if segment is unclipped, skip remaining rectangles */
		    if (!(clip1 || clip2))
			break;
		    else
			pbox++;
		}
	    } /* while (nbox--) */
	} /* sloped line */
    } /* while (nline--) */

    /* paint the last point if the end style isn't CapNotLast.
       (Assume that a projecting, butt, or round cap that is one
        pixel wide is the same as the single pixel of the endpoint.)
    */

    if ((pGC->capStyle != CapNotLast) &&
	((ppt->x != pptInit->x) ||
	 (ppt->y != pptInit->y)))
    {
	nbox = nboxInit;
	pbox = pboxInit;
	scrnFunc =
	 ( (ppcScrnPriv *)(pDrawable->pScreen->devPrivate))->solidFill ;
	while (nbox--)
	{
	    if ((ppt->x >= pbox->x1) &&
		(ppt->y >= pbox->y1) &&
		(ppt->x <  pbox->x2) &&
		(ppt->y <  pbox->y2))
	    {
		(* scrnFunc)( fg, alu, pm, ppt->x, ppt->y, 1, 1 ) ;
		break;
	    }
	    else
		pbox++;
	}
    }
    return ;
}

void
ibm8514VertDash(pGC, fg, bg, alu, pm, x, y, len)
GCPtr pGC;
long fg;
long bg;
int alu;
int pm;
int x;
int y;
int len;
{
	int talu = alu;
	long color = fg;
	int nseg;			/* number of dashed segments */
	miDashPtr pdash;		/* list of dashes */
	miDashPtr pdashInit;
	DDXPointRec pt[2];
	DDXPointRec pt1, pt2;
	int lx;

	pt[0].x = x;
	pt[0].y = y;
	pt[1].x = x;	
	pt[1].y = y + len;

	pdashInit = pdash = miDashLine( 2, pt, pGC->numInDashList,
		pGC->dash, pGC->dashOffset, &nseg ) ;

	ibm8514ClearQueue(1);
	PLNWENBL(pm);

	for(; nseg--; pdash++){
		ibm8514ClearQueue(2);
		if(pGC->lineStyle == LineOnOffDash){
			if(pdash->which == ODD_DASH)
				SETFN1(FNCOLOR1,mergexlate[alu]);
			else 
				SETFN1(FNCOLOR1,mergexlate[GXnoop]);
		} else {
			if(pdash->which == EVEN_DASH)
				SETCOL1(fg);
			else
				SETCOL1(bg);
		}

		pt1 = pdash->pt;
		pt2 = (pdash+1)->pt;

		if (lx = (pt2.y - pt1.y))  /* SIC */
			{
			ibm8514ClearQueue(4);
			SETLX(lx);
			SETX0(pt1.x);
			SETY0(pt1.y);
			COMMAND(0x20df);
			}
	}
	Xfree(pdashInit);
}

#ifdef notyet
void
ibm8514HorzDashPat(pGC, fg, bg, alu, pm, x, y, len)
GCPtr pGC;
long fg;
long bg;
int alu;
unsigned long pm;
int x;
int y;
int len;
{
	short pattern = ;

	barrel_shift8(pattern, x % 8);
	ibm8514ATRNotBusy();

	ibm8514CheckQueue(4);
	SETMODE(M_PATTS);
	SETPAT0(pattern >> 3);
	SETPAT1(pattern << 1);
	PLNWENBL(pm);

	ibm8514CheckQueue(4);
	if(pGC->lineStyle == LineOnOffDash){
		SETCOL1(fg);
		SETFN0(FNCOLOR0,mergexlate[GXnoop]);
		SETFN1(FNCOLOR1,mergexlate[alu]);
	} else {
		SETCOL0(bg);
		SETCOL1(fg);
		SETFN0(FNCOLOR0,mergexlate[alu]);
		SETFN1(FNCOLOR1,mergexlate[alu]);
	}
	ibm8514HorzLine(color, alu, pm,
		x, y, len);
}
#endif

void
ibm8514HorzDash(pGC, fg, bg, alu, pm, x, y, len)
GCPtr pGC;
long fg;
long bg;
int alu;
unsigned long pm;
int x;
int y;
int len;
{
	int talu = alu;
	long color = fg;
	int nseg;			/* number of dashed segments */
	miDashPtr pdash;		/* list of dashes */
	miDashPtr pdashInit;
	DDXPointRec pt[2];
	DDXPointRec pt1, pt2;
	int lx;

	pt[0].x = x;
	pt[0].y = y;
	pt[1].x = x + len;	
	pt[1].y = y;

	pdashInit = pdash = miDashLine( 2, pt, pGC->numInDashList,
		pGC->dash, pGC->dashOffset, &nseg ) ;

	ibm8514ClearQueue(1);
	PLNWENBL(pm);

	for(; nseg--; pdash++){
		if(pGC->lineStyle == LineOnOffDash){
			if(pdash->which == ODD_DASH)
				talu = alu;
			else 
				talu = GXnoop;
		} else {
			if(pdash->which == EVEN_DASH)
				color = fg;
			else
				color = bg;
		}
		pt1 = pdash->pt;
		pt2 = (pdash+1)->pt;

		if (lx = (pt2.x - pt1.x)) /* SIC */
			{
			ibm8514ATRNotBusy();
			ibm8514CheckQueue(6);
			SETFN1(FNCOLOR1,mergexlate[talu]);
			SETCOL1(color);
			SETLX(lx);
			SETX0(pt1.x);
			SETY0(pt1.y);
			COMMAND(0x201f);
			}
	}
	Xfree(pdashInit);
}

void
ibm8514BresDash( pGC, fg, bg, alu, pm, sdx, sdy, axis, x, y, et, e1, e2, len )
GCPtr pGC;
unsigned long int fg, bg;
int alu ;
unsigned long int pm ;
int sdx, sdy, axis, x, y, et, e1, e2, len;
{
	int talu = alu;
	long color = fg;
	int nseg;			/* number of dashed segments */
	miDashPtr pdash;		/* list of dashes */
	miDashPtr pdashInit;
	DDXPointRec pt[2];
	DDXPointRec pt1, pt2;
	int olen = len;

	pt[0].x = x;
	pt[0].y = y;
	pt[1].x = x + len;	
	pt[1].y = y + len;

	pdashInit = pdash = miDashLine( 2, pt, pGC->numInDashList,
		pGC->dash, pGC->dashOffset, &nseg ) ;

	ibm8514ClearQueue(1);
	PLNWENBL(pm);
	for(; nseg--; pdash++){
		if(pGC->lineStyle == LineOnOffDash){
			if(pdash->which == ODD_DASH)
				talu = alu;
			else 
				talu = GXnoop;
		} else {
			if(pdash->which == EVEN_DASH)
				color = fg;
			else
				color = bg;
		}
		pt1 = pdash->pt;
		pt2 = (pdash+1)->pt;
		if ( axis == X_AXIS )
			len = ABS(pt2.x - pt1.x);
		else
			len = ABS(pt2.y - pt1.y);

		if(pdash->newLine)
			ibm8514BresLineStart( color, talu, pm,
				sdx, sdy, axis,
				pt1.x, pt1.y , et, e1, e2, olen );
		ibm8514BresLineCont( color, talu, pm, sdx, sdy, axis, len );
	}
	ibm8514BresLineStop();
	Xfree(pdashInit);
}

static int bres_saved;

void
ibm8514BresLineStart( color, alu, pm, sdx, sdy, axis, x, y, et, e1, e2, len)
unsigned long int color ;
int alu ;
unsigned long int pm ;
int sdx, sdy, axis, x, y, et, e1, e2, len;
{
	int cx, cy;

	if ( len <= 0 )
		return;
	if (sdx == -1)
    		cx = x - len;
	else
    		cx = x;
	if (sdy == -1)
    		cy = y - len;
	else
    		cy = y;
	bres_saved =
		!ibm8514cursorSemaphore && ibm8514CheckCursor( cx,cy,len,len ) ;

	ibm8514ATRNotBusy();
	ibm8514CheckQueue(6);
	PLNWENBL(pm);
	SETET(et); 
	SETK1(e1); 
	SETK2(e2); 
	SETX0(x);
	SETY0(y);

	return;
}

void
ibm8514BresLineCont( color, alu, pm, sdx, sdy, axis, len)
unsigned long int color ;
int alu ;
unsigned long int pm ;
int sdx, sdy, axis, len;
{
	unsigned short command;

	if ( len <= 0 )
		return;

	ibm8514ATRNotBusy();
	ibm8514CheckQueue(4);
	SETCOL1(color);
	SETFN1(FNCOLOR1,mergexlate[alu]);

	SETLX(len); /* going to use LAST PEL NULL in Line command to brecon */

	if (axis==X_AXIS)
		command = 0x2017; /* draw bres. line on X, W, LPN, */
	else
		command = 0x2057; /* same, on Y */
	if (sdx > 0)
		command |= 0x0020;
	if (sdy > 0)
		command |= 0x0080;
	COMMAND(command);

	return;
}

void
ibm8514BresLineStop()
{
	ibm8514ATRNotBusy();
	ibm8514CheckQueue(2);
	SETFN1(FNCOLOR1,FNREPLACE);
	PLNWENBL(ALLPLANES);

	if (bres_saved)
    		ibm8514ReplaceCursor();
	return;
}
